/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.beans.PropertyChangeListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyService;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;

public class EditorContextBridge {
    private static final EditorContextDispatcher contextDispatcher = EditorContextDispatcher.getDefault();

    public static String getCurrentURL() {
        return contextDispatcher.getCurrentURLAsString();
    }

    public static String getCurrentFilePath() {
        FileObject currentFile = contextDispatcher.getCurrentFile();
        if (currentFile != null) {
            return currentFile.getPath();
        }
        return "";
    }

    public static int getCurrentLineNumber() {
        return contextDispatcher.getCurrentLineNumber();
    }

    public static String getCurrentMIMEType() {
        FileObject fo = contextDispatcher.getCurrentFile();
        return fo != null ? fo.getMIMEType() : "";
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        contextDispatcher.addPropertyChangeListener("text/x-c", l);
        contextDispatcher.addPropertyChangeListener("text/x-c++", l);
        contextDispatcher.addPropertyChangeListener("text/x-h", l);
        contextDispatcher.addPropertyChangeListener("text/x-asm", l);
        contextDispatcher.addPropertyChangeListener("text/x-fortran", l);
    }

    public static DisassemblyService getCurrentDisassemblyService() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (DisassemblyService)currentEngine.lookupFirst(null, DisassemblyService.class);
    }
}

