/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class MacroSupport {
    private MacroSupport() {
    }

    public static String expandMacro(NativeDebugger debugger, String expr) {
        String expand;
        int offset;
        StyledDocument doc;
        Frame currentFrame = debugger.getCurrentFrame();
        if (currentFrame != null && (doc = MacroSupport.getDocument(currentFrame)) != null && (offset = MacroSupport.getOffset(currentFrame, doc)) >= 0 && (expand = CsmMacroExpansion.expand((Document)doc, (int)offset, (String)expr)) != null) {
            return expand;
        }
        return expr;
    }

    private static StyledDocument getDocument(Frame frame) {
        String fullPath = frame.getFullPath();
        if (fullPath == null) {
            return null;
        }
        FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)fullPath));
        if (fo != null && fo.isValid()) {
            return (StyledDocument)CsmUtilities.getDocument((FileObject)fo);
        }
        return null;
    }

    private static int getOffset(Frame frame, StyledDocument doc) {
        try {
            int lineNumber = Integer.valueOf(frame.getLineNo());
            if (lineNumber >= 0 && doc != null) {
                return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
            }
        }
        catch (NumberFormatException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return -1;
    }
}

