/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachOutputActionProvider
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String ioTabName, ProjectActionEvent[] events) {
        if (events != null && events.length > 0 && events[events.length - 1].getType() == ProjectActionEvent.PredefinedType.RUN) {
            return Collections.singletonList(new AttachAction(events));
        }
        return Collections.emptyList();
    }

    private static final class AttachAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction {
        ProjectActionEvent[] events;
        private int step = -1;
        private int pid = -1;

        public AttachAction(ProjectActionEvent[] events) {
            this.events = events;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/actions/Attach.gif", (boolean)false));
            this.putValue("ShortDescription", NbBundle.getBundle(AttachOutputActionProvider.class).getString("OUTPUT_ATTACH_ACTION_TEXT"));
            this.setEnabled(false);
        }

        public void executionStarted(int pid) {
            if (this.step == this.events.length - 1 && pid != -1) {
                this.pid = pid;
                this.setEnabled(true);
            }
        }

        public void executionFinished(int rc) {
            this.setEnabled(false);
        }

        public void setStep(int step) {
            this.step = step;
        }

        public void actionPerformed(ActionEvent e) {
            Project project;
            MakeConfiguration conf;
            if (!this.isEnabled()) {
                return;
            }
            if (this.pid == -1) {
                return;
            }
            ProjectActionEvent event = this.events[this.step];
            ProjectInformation info = ProjectUtils.getInformation((Project)event.getProject());
            if (info == null) {
                return;
            }
            int attachPid = this.pid;
            ExecutionEnvironment exEnv = event.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
            if (exEnv.isLocal() && Utilities.isWindows()) {
                attachPid = WindowsSupport.getInstance().getWinPID(this.pid);
            }
            if ((conf = ConfigurationSupport.getProjectActiveConfiguration((Project)(project = info.getProject()))) != null) {
                EngineType projectDebuggerType = DebuggerManager.debuggerType((Configuration)conf);
                String path = conf.getAbsoluteOutputValue().replace("\\", "/");
                path = HostInfoProvider.getMapper((ExecutionEnvironment)exEnv).getRemotePath(path, true);
                if (projectDebuggerType != null) {
                    DebugTarget dt = new DebugTarget(conf.clone());
                    dt.setExecutable(path);
                    dt.setPid(attachPid);
                    dt.setHostName(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)exEnv));
                    dt.setEngine(projectDebuggerType);
                    DebuggerManager.get().attach(dt);
                }
            }
        }
    }
}

