/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.StateListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.EditMaxFramePanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class MaxFrameAction
extends CallableSystemAction
implements StateListener {
    public void performAction() {
        String max_frame;
        MaxFrameProcessor processor;
        NativeDebugger debugger = DebuggerManager.get().currentNativeDebugger();
        if (debugger != null && (processor = new MaxFrameProcessor(debugger, max_frame = DebuggerOption.STACK_MAX_SIZE.getCurrValue(debugger.optionLayers()))) != null) {
            processor.setVisible(true);
        }
    }

    public boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Catalog.get("ACT_Max_Frames");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    protected String iconResource() {
        return "org/netbeans/modules/debugger/resources/actions/NewWatch.gif";
    }

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    public void update(State state) {
        boolean enable = false;
        if (state != null) {
            enable = state.isLoaded && state.isListening();
        }
        this.setEnabled(enable);
    }

    private static class MaxFrameProcessor
    implements PropertyChangeListener {
        private final DialogDescriptor dd;
        private final EditMaxFramePanel panel;

        MaxFrameProcessor(NativeDebugger debugger, String max_frame) {
            this.panel = new EditMaxFramePanel(debugger, max_frame);
            Catalog.setAccessibleDescription(this.panel, "ACSD_MaxFrames");
            boolean isModal = true;
            this.dd = new DialogDescriptor((Object)this.panel, Catalog.get("TTL_MaxFrames"), isModal, null);
            Object[] buttons = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
            this.dd.setOptions(buttons);
            this.dd.setClosingOptions(buttons);
            this.panel.getController().addPropertyChangeListener((PropertyChangeListener)this);
            this.setValid();
        }

        public void setVisible(boolean v) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dd);
            boolean ok = this.dd.getValue() == DialogDescriptor.OK_OPTION;
            Controller controller = this.panel.getController();
            if (ok) {
                controller.ok();
            } else {
                controller.cancel();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "valid") {
                this.setValid();
            }
        }

        void setValid() {
            this.dd.setValid(this.panel.getController().isValid());
        }
    }
}

