/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.LocaleVariants;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class StandardModule
extends Module {
    private final File jar;
    private File physicalJar = null;
    private Manifest manifest;
    private static final Map<File, Set<File>> extensionOwners = new HashMap<File, Set<File>>();
    private static final Set<File> moduleJARs = new HashSet<File>();
    private Set<File> localeVariants = null;
    private Set<File> plainExtensions = null;
    private Set<File> localeExtensions = null;
    private Set<File> patches = null;
    private Properties localizedProps;
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;

    public StandardModule(ModuleManager mgr, Events ev, File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        super(mgr, ev, history, reloadable, autoload, eager);
        this.jar = jar;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        Set<File> bogoOwners = extensionOwners.get(jar);
        if (bogoOwners != null) {
            Util.err.warning("module " + jar + " was incorrectly placed in the Class-Path of other JARs " + bogoOwners + "; please use OpenIDE-Module-Module-Dependencies instead");
        }
        moduleJARs.add(jar);
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.loadManifest();
            }
            catch (IOException x) {
                Util.err.log(Level.WARNING, "While loading manifest for " + (Object)((Object)this), x);
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    @Override
    public void releaseManifest() {
        this.manifest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String attr) {
        int idx;
        String locb = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean usingLoader = false;
        if (locb != null) {
            if (this.classloader != null) {
                if (locb.endsWith(".properties")) {
                    usingLoader = true;
                    String basename = locb.substring(0, locb.length() - 11).replace('/', '.');
                    try {
                        ResourceBundle bundle = NbBundle.getBundle((String)basename, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return bundle.getString(attr);
                        }
                        catch (MissingResourceException mre) {
                        }
                    }
                    catch (MissingResourceException mre) {
                        String resource = basename.replace('.', '/') + ".properties";
                        Exceptions.attachMessage((Throwable)mre, (String)("#149833: failed to find " + basename + " in locale " + Locale.getDefault() + " in " + this.classloader + " for " + this.jar + "; resource lookup of " + resource + " -> " + this.classloader.getResource(resource)));
                        Exceptions.printStackTrace((Throwable)mre);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + locb);
                }
            }
            if (!usingLoader) {
                String val;
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log(Level.FINE, "Trying to get localized attr {0} from disabled module {1}", new Object[]{attr, this.getCodeNameBase()});
                        try {
                            if (this.jar != null && this.jar.isFile()) {
                                JarFile jarFile = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps(jarFile, this.getManifest());
                                    break block19;
                                }
                                finally {
                                    jarFile.close();
                                }
                            }
                            Util.err.log(Level.FINE, "Cannot get localized attr {0} from module {1} (missing or deleted JAR file: {2})", new Object[]{attr, this.getCodeNameBase(), this.jar});
                        }
                        catch (IOException ioe) {
                            Util.err.log(Level.WARNING, this.jar.getAbsolutePath(), ioe);
                        }
                    }
                }
                if (this.localizedProps != null && (val = this.localizedProps.getProperty(attr)) != null) {
                    return val;
                }
            }
        }
        if ((idx = attr.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(attr));
        }
        String section = attr.substring(0, idx);
        String realAttr = attr.substring(idx + 1);
        Attributes attrs = this.getManifest().getAttributes(section);
        if (attrs != null) {
            return NbBundle.getLocalizedValue((Attributes)attrs, (Attributes.Name)new Attributes.Name(realAttr));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.warning("temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.fine("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.fine("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block8: {
            Util.err.fine("loading manifest of " + this.jar);
            File jarBeingOpened = null;
            try {
                if (this.reloadable) {
                    jarBeingOpened = this.physicalJar;
                    this.ensurePhysicalJar();
                    jarBeingOpened = this.physicalJar;
                    JarFile jarFile = new JarFile(this.physicalJar, false);
                    try {
                        Manifest m = jarFile.getManifest();
                        if (m == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = m;
                        break block8;
                    }
                    finally {
                        jarFile.close();
                    }
                }
                jarBeingOpened = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException e) {
                if (jarBeingOpened != null) {
                    Exceptions.attachMessage((Throwable)e, (String)("While loading manifest from: " + jarBeingOpened));
                }
                throw e;
            }
        }
    }

    private void findExtensionsAndVariants(Manifest m) {
        assert (this.jar != null) : "Cannot load extensions from classpath module " + this.getCodeNameBase();
        this.localeVariants = null;
        List<File> l = LocaleVariants.findLocaleVariantsOf(this.jar, this.getCodeNameBase());
        if (!l.isEmpty()) {
            this.localeVariants = new HashSet<File>(l);
        }
        this.plainExtensions = null;
        this.localeExtensions = null;
        String classPath = m.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                String ext = tok.nextToken();
                if (new File(ext).isAbsolute()) {
                    Util.err.log(Level.WARNING, "Class-Path value {0} from {1} is illegal according to the Java Extension Mechanism: must be relative", new Object[]{ext, this.jar});
                }
                File base = this.jar.getParentFile();
                while (ext.startsWith("../")) {
                    ext = ext.substring(3);
                    base = base.getParentFile();
                }
                File extfile = new File(base, ext.replace('/', File.separatorChar));
                Set<File> owners = extensionOwners.get(extfile);
                if (owners == null) {
                    owners = new HashSet<File>(2);
                    owners.add(this.jar);
                    extensionOwners.put(extfile, owners);
                } else if (!owners.contains(this.jar)) {
                    owners.add(this.jar);
                    this.events.log("extensionMultiplyLoaded", extfile, owners);
                }
                if (moduleJARs.contains(extfile)) {
                    Util.err.warning("Class-Path value " + ext + " from " + this.jar + " illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead");
                }
                if (this.plainExtensions == null) {
                    this.plainExtensions = new HashSet<File>();
                }
                this.plainExtensions.add(extfile);
                l = LocaleVariants.findLocaleVariantsOf(extfile, this.getCodeNameBase());
                if (l.isEmpty()) continue;
                if (this.localeExtensions == null) {
                    this.localeExtensions = new HashSet<File>();
                }
                this.localeExtensions.addAll(l);
            }
        }
        File patchdir = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        this.scanForPatches(patchdir);
        String patchesClassPath = System.getProperty("netbeans.patches." + this.getCodeNameBase());
        if (patchesClassPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(patchesClassPath, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                File fileElement = new File(element);
                if (!fileElement.exists()) continue;
                if (this.patches == null) {
                    this.patches = new HashSet<File>(15);
                }
                this.patches.add(fileElement);
            }
        }
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("localeVariants of " + this.jar + ": " + this.localeVariants);
            Util.err.fine("plainExtensions of " + this.jar + ": " + this.plainExtensions);
            Util.err.fine("localeExtensions of " + this.jar + ": " + this.localeExtensions);
            Util.err.fine("patches of " + this.jar + ": " + this.patches);
        }
        if (this.patches != null) {
            for (File patch : this.patches) {
                this.events.log("patch", patch);
            }
        }
    }

    private void scanForPatches(File patchdir) {
        if (!patchdir.isDirectory()) {
            return;
        }
        File[] jars = patchdir.listFiles(Util.jarFilter());
        if (jars != null) {
            for (File patchJar : jars) {
                if (this.patches == null) {
                    this.patches = new HashSet<File>(5);
                }
                this.patches.add(patchJar);
            }
        } else {
            Util.err.warning("Could not search for patches in " + patchdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest m) throws IOException {
        String locbundle = m.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            String ext;
            String name;
            int idx;
            ZipEntry bundleFile = jarFile.getEntry(locbundle);
            if (bundleFile != null) {
                this.localizedProps = new Properties();
                InputStream is = jarFile.getInputStream(bundleFile);
                try {
                    this.localizedProps.load(is);
                }
                finally {
                    is.close();
                }
            }
            if ((idx = locbundle.lastIndexOf(46)) == -1) {
                name = locbundle;
                ext = "";
            } else {
                name = locbundle.substring(0, idx);
                ext = locbundle.substring(idx);
            }
            List<LocaleVariants.FileWithSuffix> pairs = LocaleVariants.findLocaleVariantsWithSuffixesOf(this.jar, this.getCodeNameBase());
            Collections.reverse(pairs);
            for (LocaleVariants.FileWithSuffix pair : pairs) {
                File localeJar = pair.file;
                String suffix = pair.suffix;
                String rsrc = name + suffix + ext;
                JarFile localeJarFile = new JarFile(localeJar, false);
                try {
                    ZipEntry bundleFile2 = localeJarFile.getEntry(rsrc);
                    if (bundleFile2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    InputStream is = localeJarFile.getInputStream(bundleFile2);
                    try {
                        this.localizedProps.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    localeJarFile.close();
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + locbundle);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        ArrayList<File> l = new ArrayList<File>();
        if (this.patches != null) {
            l.addAll(this.patches);
        }
        if (this.physicalJar != null) {
            l.add(this.physicalJar);
        } else if (this.jar != null) {
            l.add(this.jar);
        }
        if (this.plainExtensions != null) {
            l.addAll(this.plainExtensions);
        }
        if (this.localeVariants != null) {
            l.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            l.addAll(this.localeExtensions);
        }
        return l;
    }

    @Override
    public void setReloadable(boolean r) {
        this.getManager().assertWritable();
        if (this.reloadable != r) {
            this.reloadable = r;
            this.getManager().fireReloadable(this);
        }
    }

    @Override
    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String codeNameBase1 = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        String codeNameBase2 = this.getCodeNameBase();
        if (!codeNameBase1.equals(codeNameBase2)) {
            throw new InvalidException("Code name base changed during reload: " + codeNameBase1 + " -> " + codeNameBase2);
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> parents) throws IOException {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("classLoaderUp on " + (Object)((Object)this) + " with parents " + parents);
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(parents.size() + 1);
        loaders.add(Module.class.getClassLoader());
        for (Module parent : parents) {
            Module.PackageExport[] exports = parent.getPublicPackages();
            if (exports != null && exports.length == 0) {
                boolean implDep = false;
                for (Dependency dep : this.getDependenciesArray()) {
                    if (dep.getType() != 1 || dep.getComparison() != 2 || !dep.getName().equals(parent.getCodeName())) continue;
                    implDep = true;
                    break;
                }
                if (!implDep) continue;
            }
            ClassLoader l = parent.getClassLoader();
            if (parent.isFixed() && loaders.contains(l)) {
                Util.err.log(Level.FINE, "#24996: skipping duplicate classloader from {0}", (Object)parent);
                continue;
            }
            loaders.add(l);
        }
        ArrayList<File> classp = new ArrayList<File>(3);
        if (this.patches != null) {
            classp.addAll(this.patches);
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            classp.add(this.physicalJar);
        } else {
            classp.add(this.jar);
        }
        if (this.localeVariants != null) {
            classp.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            classp.addAll(this.localeExtensions);
        }
        if (this.plainExtensions != null) {
            classp.addAll(this.plainExtensions);
        }
        this.getManager().refineClassLoader(this, loaders);
        try {
            this.classloader = new OneModuleClassLoader(classp, loaders.toArray(new ClassLoader[loaders.size()]));
        }
        catch (IllegalArgumentException iae) {
            throw (IOException)new IOException(iae.toString()).initCause(iae);
        }
    }

    @Override
    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.fine("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    @Override
    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.fine("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.fine("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    @Override
    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    @Override
    public String toString() {
        String s = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider {
        private int rc;

        public OneModuleClassLoader(List<File> classp, ClassLoader[] parents) throws IllegalArgumentException {
            super(classp, parents, false, StandardModule.this);
            this.rc = StandardModule.this.releaseCount++;
        }

        @Override
        public Module getModule() {
            return StandardModule.this;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource cs) {
            return StandardModule.getAllPermission();
        }

        @Override
        protected String findLibrary(String libname) {
            InstalledFileLocator ifl = InstalledFileLocator.getDefault();
            String arch = System.getProperty("os.arch");
            String system = System.getProperty("os.name").toLowerCase();
            String mapped = System.mapLibraryName(libname);
            File lib = ifl.locate("modules/lib/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                return lib.getAbsolutePath();
            }
            lib = ifl.locate("modules/lib/" + arch + "/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                return lib.getAbsolutePath();
            }
            lib = ifl.locate("modules/lib/" + arch + "/" + system + "/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                return lib.getAbsolutePath();
            }
            return null;
        }

        @Override
        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            if (!super.shouldDelegateResource(pkg, parent)) {
                return false;
            }
            Module other = parent instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)parent)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, other, pkg);
        }

        public String toString() {
            return "ModuleCL@" + Integer.toHexString(System.identityHashCode(this)) + "[" + StandardModule.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + StandardModule.this.releaseCount + " released=" + StandardModule.this.released);
            if (this.rc == StandardModule.this.releaseCount) {
                StandardModule.this.released = true;
            } else {
                Util.err.fine("Now resources for " + StandardModule.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

