/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import com.thaiopensource.relaxng.impl.IdTypeMapSchema;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.xml.sax.Resolver;
import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class SchemaReaderImpl
extends AbstractSchemaReader {
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, ValidateProperty.URI_RESOLVER, ValidateProperty.RESOLVER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, WrapProperty.ATTRIBUTE_OWNER};

    public Schema createSchema(SAXSource source, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder spb = new SchemaPatternBuilder();
        Resolver resolver = ResolverFactory.createResolver(properties);
        ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
        DatatypeLibraryFactory dlf = RngProperty.DATATYPE_LIBRARY_FACTORY.get(properties);
        if (dlf == null) {
            dlf = new DatatypeLibraryLoader();
        }
        try {
            Pattern start = SchemaBuilderImpl.parse(this.createParseable(source, resolver, eh), eh, dlf, spb, properties.contains(WrapProperty.ATTRIBUTE_OWNER));
            return SchemaReaderImpl.wrapPattern(start, spb, properties);
        }
        catch (IllegalSchemaException e) {
            throw new IncorrectSchemaException();
        }
    }

    public Option getOption(String uri) {
        return RngProperty.getOption(uri);
    }

    static Schema wrapPattern(Pattern start, SchemaPatternBuilder spb, PropertyMap properties) throws SAXException, IncorrectSchemaException {
        if ((properties = AbstractSchema.filterProperties(properties, supportedPropertyIds)).contains(RngProperty.FEASIBLE)) {
            start = FeasibleTransform.transform(spb, start);
        }
        AbstractSchema schema = new PatternSchema(spb, start, properties);
        if (spb.hasIdTypes() && properties.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(eh, start).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema idSchema = properties.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, properties) : new IdTypeMapSchema(idTypeMap, properties);
            schema = new CombineSchema(schema, idSchema, properties);
        }
        return schema;
    }

    protected abstract Parseable createParseable(SAXSource var1, Resolver var2, ErrorHandler var3) throws SAXException;
}

