/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.indexing.CheckSums;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;

class JavaParsingContext {
    final ClasspathInfo cpInfo;
    final String sourceLevel;
    final JavaFileFilterImplementation filter;
    final Charset encoding;
    final ClassIndexImpl uq;
    final SourceAnalyser sa;
    final CheckSums checkSums;
    final FQN2Files fqn2Files;

    public JavaParsingContext(Context context) throws IOException, NoSuchAlgorithmException {
        this(context, false);
    }

    JavaParsingContext(Context context, boolean allowNonExistentRoot) throws IOException, NoSuchAlgorithmException {
        FileObject root = context.getRoot();
        boolean rootNotNeeded = allowNonExistentRoot && root == null;
        this.cpInfo = rootNotNeeded ? null : ClasspathInfo.create(root);
        this.sourceLevel = rootNotNeeded ? null : SourceLevelQuery.getSourceLevel((FileObject)root);
        this.filter = rootNotNeeded ? null : JavaFileFilterQuery.getFilter(root);
        this.encoding = rootNotNeeded ? null : FileEncodingQuery.getEncoding((FileObject)root);
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
        this.sa = this.uq != null ? this.uq.getSourceAnalyser() : null;
        this.checkSums = CheckSums.forContext(context);
        this.fqn2Files = FQN2Files.forRoot(context.getRootURI());
    }

    public JavaParsingContext(Context context, ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) throws IOException, NoSuchAlgorithmException {
        this.filter = JavaFileFilterQuery.getFilter(context.getRoot());
        this.cpInfo = ClasspathInfoAccessor.getINSTANCE().create(bootPath, compilePath, sourcePath, this.filter, true, context.isSourceForBinaryRootIndexing(), !virtualSources.isEmpty(), context.checkForEditorModifications());
        JavaParsingContext.registerVirtualSources(this.cpInfo, virtualSources);
        this.sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)context.getRoot());
        this.encoding = FileEncodingQuery.getEncoding((FileObject)context.getRoot());
        this.uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
        this.sa = this.uq != null ? this.uq.getSourceAnalyser() : null;
        this.checkSums = CheckSums.forContext(context);
        this.fqn2Files = FQN2Files.forRoot(context.getRootURI());
    }

    private static void registerVirtualSources(ClasspathInfo cpInfo, Collection<? extends JavaCustomIndexer.CompileTuple> virtualSources) {
        for (JavaCustomIndexer.CompileTuple compileTuple : virtualSources) {
            ClasspathInfoAccessor.getINSTANCE().registerVirtualSource(cpInfo, compileTuple.jfo);
        }
    }
}

