/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class CompilationInfoImpl {
    private JavaSource.Phase phase = JavaSource.Phase.MODIFIED;
    private CompilationUnitTree compilationUnit;
    private JavacTaskImpl javacTask;
    private final ClasspathInfo cpInfo;
    Pair<DocPositionRegion, MethodTree> changedMethod;
    private final FileObject file;
    private final FileObject root;
    final JavaFileObject jfo;
    private Snapshot snapshot;
    private final JavacParser parser;
    private final boolean isClassFile;
    private final boolean isDetached;
    JavaSource.Phase parserCrashed = JavaSource.Phase.UP_TO_DATE;

    CompilationInfoImpl(JavacParser parser, FileObject file, FileObject root, JavacTaskImpl javacTask, Snapshot snapshot, boolean detached) throws IOException {
        assert (parser != null);
        this.parser = parser;
        this.cpInfo = parser.getClasspathInfo();
        assert (this.cpInfo != null);
        this.file = file;
        this.root = root;
        this.snapshot = snapshot;
        assert (file == null || snapshot != null);
        this.jfo = file != null ? JavacParser.jfoProvider.createJavaFileObject(file, root, JavaFileFilterQuery.getFilter(file), snapshot.getText()) : null;
        this.javacTask = javacTask;
        this.isClassFile = false;
        this.isDetached = detached;
    }

    CompilationInfoImpl(ClasspathInfo cpInfo) {
        assert (cpInfo != null);
        this.parser = null;
        this.file = null;
        this.root = null;
        this.jfo = null;
        this.snapshot = null;
        this.cpInfo = cpInfo;
        this.isClassFile = false;
        this.isDetached = false;
    }

    CompilationInfoImpl(ClasspathInfo cpInfo, FileObject file, FileObject root) throws IOException {
        assert (cpInfo != null);
        assert (file != null);
        assert (root != null);
        this.parser = null;
        this.file = file;
        this.root = root;
        this.jfo = FileObjects.nbFileObject(file, root);
        this.snapshot = null;
        this.cpInfo = cpInfo;
        this.isClassFile = true;
        this.isDetached = false;
    }

    void update(Snapshot snapshot) throws IOException {
        assert (snapshot != null);
        JavacParser.jfoProvider.update(this.jfo, snapshot.getText());
        this.snapshot = snapshot;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public JavaSource.Phase getPhase() {
        return this.phase;
    }

    public Pair<DocPositionRegion, MethodTree> getChangedTree() {
        return this.changedMethod;
    }

    public CompilationUnitTree getCompilationUnit() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        if (this.phase.compareTo(JavaSource.Phase.PARSED) < 0) {
            throw new IllegalStateException("Cannot call getCompilationInfo() if current phase < JavaSource.Phase.PARSED. You must call toPhase(Phase.PARSED) first.");
        }
        return this.compilationUnit;
    }

    public String getText() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return ((Object)this.jfo.getCharContent(false)).toString();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return ((SourceFileObject)this.jfo).getTokenHierarchy();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    public List<Diagnostic> getDiagnostics() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        Collection errors = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).getErrors(this.jfo).values();
        List partialReparseErrors = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).partialReparseErrors;
        List affectedErrors = ((DiagnosticListenerImpl)this.javacTask.getContext().get(DiagnosticListener.class)).affectedErrors;
        ArrayList<Diagnostic> localErrors = new ArrayList<Diagnostic>(errors.size() + (partialReparseErrors == null ? 0 : partialReparseErrors.size()) + (affectedErrors == null ? 0 : affectedErrors.size()));
        localErrors.addAll(errors);
        if (partialReparseErrors != null) {
            localErrors.addAll(partialReparseErrors);
        }
        if (affectedErrors != null) {
            localErrors.addAll(affectedErrors);
        }
        return localErrors;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public JavacParser getParser() {
        return this.parser;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isClassFile() {
        return this.isClassFile;
    }

    public Document getDocument() {
        if (this.file == null) {
            return null;
        }
        if (!this.file.isValid()) {
            return null;
        }
        try {
            DataObject od = DataObject.find((FileObject)this.file);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            if (ec != null) {
                return ec.getDocument();
            }
            return null;
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(CompilationInfoImpl.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        if (phase == JavaSource.Phase.MODIFIED) {
            throw new IllegalArgumentException("Invalid phase: " + (Object)((Object)phase));
        }
        if (!this.hasSource()) {
            JavaSource.Phase currentPhase = this.getPhase();
            if (currentPhase.compareTo(phase) < 0) {
                this.setPhase(phase);
                if (currentPhase == JavaSource.Phase.MODIFIED) {
                    this.getJavacTask().parse();
                }
                currentPhase = phase;
            }
            return currentPhase;
        }
        JavaSource.Phase currentPhase = this.parser.moveToPhase(phase, this, false);
        return currentPhase.compareTo(phase) < 0 ? currentPhase : phase;
    }

    public synchronized JavacTaskImpl getJavacTask() {
        if (this.javacTask == null) {
            this.javacTask = JavacParser.createJavacTask(this.file, this.root, this.cpInfo, this.parser, new DiagnosticListenerImpl(this.jfo), null, this.isDetached);
        }
        return this.javacTask;
    }

    void setPhase(JavaSource.Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    void setChangedMethod(Pair<DocPositionRegion, MethodTree> changedMethod) {
        this.changedMethod = changedMethod;
    }

    void setCompilationUnit(CompilationUnitTree compilationUnit) {
        assert (compilationUnit != null);
        this.compilationUnit = compilationUnit;
    }

    private boolean hasSource() {
        return this.jfo != null && !this.isClassFile;
    }

    static class DiagnosticListenerImpl
    implements DiagnosticListener<JavaFileObject> {
        private final Map<JavaFileObject, TreeMap<Integer, Diagnostic<? extends JavaFileObject>>> source2Errors;
        private final JavaFileObject jfo;
        private volatile List<Diagnostic<? extends JavaFileObject>> partialReparseErrors;
        private volatile List<Diagnostic<? extends JavaFileObject>> affectedErrors;
        private volatile int currentDelta;

        public DiagnosticListenerImpl(JavaFileObject jfo) {
            this.jfo = jfo;
            this.source2Errors = new HashMap<JavaFileObject, TreeMap<Integer, Diagnostic<? extends JavaFileObject>>>();
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> message) {
            if (this.partialReparseErrors != null) {
                if (this.jfo != null && this.jfo == message.getSource()) {
                    this.partialReparseErrors.add(message);
                }
            } else {
                this.getErrors(message.getSource()).put((int)message.getPosition(), message);
            }
        }

        private TreeMap<Integer, Diagnostic<? extends JavaFileObject>> getErrors(JavaFileObject file) {
            TreeMap<Integer, Diagnostic<JavaFileObject>> errors = this.source2Errors.get(file);
            if (errors == null) {
                errors = new TreeMap();
                this.source2Errors.put(file, errors);
            }
            return errors;
        }

        final boolean hasPartialReparseErrors() {
            return this.partialReparseErrors != null && !this.partialReparseErrors.isEmpty();
        }

        final void startPartialReparse(int from, int to) {
            if (this.partialReparseErrors == null) {
                this.partialReparseErrors = new ArrayList<Diagnostic<? extends JavaFileObject>>();
                TreeMap<Integer, Diagnostic<? extends JavaFileObject>> errors = this.getErrors(this.jfo);
                errors.subMap(from, to).clear();
                SortedMap<Integer, Diagnostic<? extends JavaFileObject>> tail = errors.tailMap(to);
                this.affectedErrors = new ArrayList<Diagnostic<? extends JavaFileObject>>(tail.size());
                Iterator it = tail.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    JCDiagnostic diagnostic = (JCDiagnostic)e.getValue();
                    it.remove();
                    if (diagnostic == null) {
                        throw new IllegalStateException("#184910: diagnostic == null " + DiagnosticListenerImpl.mapArraysToLists(Thread.getAllStackTraces()));
                    }
                    this.affectedErrors.add(new D(diagnostic));
                }
            } else {
                this.partialReparseErrors.clear();
            }
        }

        final void endPartialReparse(int delta) {
            this.currentDelta += delta;
        }

        private static <A, B> Map<A, List<B>> mapArraysToLists(Map<? extends A, B[]> map) {
            HashMap<A, List<B>> result = new HashMap<A, List<B>>();
            for (Map.Entry<A, B[]> entry : map.entrySet()) {
                result.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
            return result;
        }

        private final class D
        implements Diagnostic {
            private final JCDiagnostic delegate;

            public D(JCDiagnostic delegate) {
                assert (delegate != null);
                this.delegate = delegate;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return this.delegate.getKind();
            }

            public Object getSource() {
                return this.delegate.getSource();
            }

            @Override
            public long getPosition() {
                long ret = this.delegate.getPosition();
                if (this.delegate.hasFixedPositions()) {
                    ret += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return ret;
            }

            @Override
            public long getStartPosition() {
                long ret = this.delegate.getStartPosition();
                if (this.delegate.hasFixedPositions()) {
                    ret += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return ret;
            }

            @Override
            public long getEndPosition() {
                long ret = this.delegate.getEndPosition();
                if (this.delegate.hasFixedPositions()) {
                    ret += (long)DiagnosticListenerImpl.this.currentDelta;
                }
                return ret;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return this.delegate.getCode();
            }

            @Override
            public String getMessage(Locale locale) {
                return this.delegate.getMessage(locale);
            }
        }
    }
}

