/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.ForwardingInferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.GeneratedFileMarker;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.util.Iterators;

public class ProxyFileManager
implements JavaFileManager {
    private static final JavaFileManager.Location ALL = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "ALL";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private static final JavaFileManager.Location SOURCE_PATH_WRITE = new JavaFileManager.Location(){

        @Override
        public String getName() {
            return "SOURCE_PATH_WRITE";
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    };
    private final JavaFileManager bootPath;
    private final JavaFileManager classPath;
    private final JavaFileManager sourcePath;
    private final JavaFileManager aptSources;
    private final MemoryFileManager memoryFileManager;
    private final JavaFileManager outputhPath;
    private final GeneratedFileMarker marker;
    private final SiblingSource siblings;
    private JavaFileObject lastInfered;
    private String lastInferedResult;
    private static final Logger LOG = Logger.getLogger(ProxyFileManager.class.getName());

    public ProxyFileManager(JavaFileManager bootPath, JavaFileManager classPath, JavaFileManager sourcePath, JavaFileManager aptSources, JavaFileManager outputhPath, MemoryFileManager memoryFileManager, GeneratedFileMarker marker, SiblingSource siblings) {
        assert (bootPath != null);
        assert (classPath != null);
        assert (memoryFileManager == null || sourcePath != null);
        assert (marker != null);
        assert (siblings != null);
        this.bootPath = bootPath;
        this.classPath = classPath;
        this.sourcePath = sourcePath;
        this.aptSources = aptSources;
        this.memoryFileManager = memoryFileManager;
        this.outputhPath = outputhPath;
        this.marker = marker;
        this.siblings = siblings;
    }

    private JavaFileManager[] getFileManager(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_PATH) {
            JavaFileManager[] javaFileManagerArray;
            if (this.outputhPath == null) {
                JavaFileManager[] javaFileManagerArray2 = new JavaFileManager[1];
                javaFileManagerArray = javaFileManagerArray2;
                javaFileManagerArray2[0] = this.classPath;
            } else {
                JavaFileManager[] javaFileManagerArray3 = new JavaFileManager[2];
                javaFileManagerArray3[0] = this.classPath;
                javaFileManagerArray = javaFileManagerArray3;
                javaFileManagerArray3[1] = this.outputhPath;
            }
            return javaFileManagerArray;
        }
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return new JavaFileManager[]{this.bootPath};
        }
        if (location == StandardLocation.SOURCE_PATH && this.sourcePath != null) {
            if (this.memoryFileManager != null) {
                if (this.aptSources != null) {
                    return new JavaFileManager[]{this.sourcePath, this.aptSources, this.memoryFileManager};
                }
                return new JavaFileManager[]{this.sourcePath, this.memoryFileManager};
            }
            if (this.aptSources != null) {
                return new JavaFileManager[]{this.sourcePath, this.aptSources};
            }
            return new JavaFileManager[]{this.sourcePath};
        }
        if (location == StandardLocation.CLASS_OUTPUT && this.outputhPath != null) {
            return new JavaFileManager[]{this.outputhPath};
        }
        if (location == StandardLocation.SOURCE_OUTPUT && this.aptSources != null) {
            return new JavaFileManager[]{this.aptSources};
        }
        if (location == SOURCE_PATH_WRITE) {
            return new JavaFileManager[]{this.sourcePath};
        }
        if (location == ALL) {
            return this.getAllFileManagers();
        }
        return new JavaFileManager[0];
    }

    private JavaFileManager[] getAllFileManagers() {
        ArrayList<JavaFileManager> result = new ArrayList<JavaFileManager>(4);
        if (this.sourcePath != null) {
            result.add(this.sourcePath);
        }
        if (this.aptSources != null) {
            result.add(this.aptSources);
        }
        if (this.memoryFileManager != null) {
            result.add(this.memoryFileManager);
        }
        result.add(this.bootPath);
        result.add(this.classPath);
        if (this.outputhPath != null) {
            result.add(this.outputhPath);
        }
        return result.toArray(new JavaFileManager[result.size()]);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavaFileManager[] fms;
        LinkedList<Iterable<JavaFileObject>> iterables = new LinkedList<Iterable<JavaFileObject>>();
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            iterables.add(fm.list(l, packageName, kinds, recurse));
        }
        Iterable<JavaFileObject> result = Iterators.chained(iterables);
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder urls = new StringBuilder();
            for (JavaFileObject jfo : result) {
                urls.append(jfo.toUri().toString());
                urls.append(", ");
            }
            LOG.finer(String.format("list %s package: %s type: %s found files: [%s]", l.toString(), packageName, kinds.toString(), urls.toString()));
        }
        return result;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location l, String packageName, String relativeName) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            FileObject result = fm.getFileForInput(l, packageName, relativeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location l, String packageName, String relativeName, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManager(l == StandardLocation.SOURCE_PATH ? SOURCE_PATH_WRITE : l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        return this.mark(fms[0].getFileForOutput(l, packageName, relativeName, sibling), l);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public void flush() throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getAllFileManagers()) {
            fm.flush();
        }
    }

    @Override
    public void close() throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getAllFileManagers()) {
            fm.close();
        }
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleOption(String current, Iterator<String> remains) {
        Collection<String> defensiveCopy = ProxyFileManager.copy(remains);
        if ("apt-origin".equals(current)) {
            Iterator<String> it = defensiveCopy.iterator();
            if (!it.hasNext()) {
                throw new IllegalArgumentException("The apt-source-root requires folder.");
            }
            String sib = it.next();
            if (sib.length() != 0) {
                this.siblings.push(ProxyFileManager.asURL(sib));
            } else {
                try {
                    this.markerFinished();
                }
                finally {
                    this.siblings.pop();
                }
            }
        } else {
            boolean isSourceElement = "apt-source-element".equals(current);
            if (isSourceElement || "apt-resource-element".equals(current)) {
                if (!defensiveCopy.isEmpty()) {
                    URL bestSoFar = this.siblings.getProvider().getSibling();
                    for (String surl : defensiveCopy) {
                        if (!"java".equals(FileObjects.getExtension(surl))) continue;
                        bestSoFar = ProxyFileManager.asURL(surl);
                        break;
                    }
                    if (LOG.isLoggable(Level.INFO) && isSourceElement && defensiveCopy.size() > 1) {
                        StringBuilder sb = new StringBuilder();
                        for (String surl : defensiveCopy) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(surl);
                        }
                        LOG.log(Level.INFO, "Multiple source files passed as ORIGIN_SOURCE_ELEMENT_URL{0} using: {1}", new Object[]{sb.toString(), bestSoFar});
                    }
                    this.siblings.push(bestSoFar);
                } else {
                    try {
                        this.markerFinished();
                    }
                    finally {
                        this.siblings.pop();
                    }
                }
            }
        }
        for (JavaFileManager m : this.getFileManager(ALL)) {
            if (!m.handleOption(current, defensiveCopy.iterator())) continue;
            return true;
        }
        return false;
    }

    private static URL asURL(String url) throws IllegalArgumentException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid path argument: " + url);
        }
    }

    private static Collection<String> copy(Iterator<String> from) {
        if (!from.hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        while (from.hasNext()) {
            result.add(from.next());
        }
        return result;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH || location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_OUTPUT;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(l)) {
            JavaFileObject result = fm.getJavaFileForInput(l, className, kind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        JavaFileManager[] fms = this.getFileManager(l);
        assert (fms.length <= 1);
        if (fms.length == 0) {
            return null;
        }
        JavaFileObject result = fms[0].getJavaFileForOutput(l, className, kind, sibling);
        return this.mark(result, l);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        JavaFileManager[] fms;
        InferableJavaFileObject ifo;
        String result;
        assert (javaFileObject != null);
        if (javaFileObject == this.lastInfered) {
            return this.lastInferedResult;
        }
        if (javaFileObject instanceof InferableJavaFileObject && (result = (ifo = (InferableJavaFileObject)javaFileObject).inferBinaryName()) != null) {
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        for (JavaFileManager fm : fms = this.getFileManager(location)) {
            result = fm.inferBinaryName(location, javaFileObject);
            if (result == null || result.length() <= 0) continue;
            this.lastInfered = javaFileObject;
            this.lastInferedResult = result;
            return result;
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject0) {
        JavaFileManager[] fms;
        for (JavaFileManager fm : fms = this.getFileManager(ALL)) {
            if (!fm.isSameFile(fileObject, fileObject0)) continue;
            return true;
        }
        return fileObject.toUri().equals(fileObject0.toUri());
    }

    private <T extends FileObject> T mark(T result, JavaFileManager.Location l) throws MalformedURLException {
        boolean write;
        GeneratedFileMarker.Type type = null;
        if (l == StandardLocation.CLASS_OUTPUT) {
            type = GeneratedFileMarker.Type.RESOURCE;
        } else if (l == StandardLocation.SOURCE_OUTPUT) {
            type = GeneratedFileMarker.Type.SOURCE;
        }
        boolean hasSibling = this.siblings.getProvider().hasSibling();
        boolean bl = write = this.marker.allowsWrite() || !hasSibling;
        if (result != null && hasSibling) {
            if (type == GeneratedFileMarker.Type.SOURCE) {
                this.marker.mark(result.toUri().toURL(), type);
            } else if (type == GeneratedFileMarker.Type.RESOURCE) {
                try {
                    result.openInputStream().close();
                }
                catch (IOException ioe) {
                    this.marker.mark(result.toUri().toURL(), type);
                }
            }
        }
        return (T)(write ? result : new NullFileObject((InferableJavaFileObject)result));
    }

    private void markerFinished() {
        if (this.siblings.getProvider().hasSibling()) {
            this.marker.finished(this.siblings.getProvider().getSibling());
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static final class NullFileObject
    extends ForwardingInferableJavaFileObject {
        private NullFileObject(@NonNull InferableJavaFileObject delegate) {
            super(delegate);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new NullOutputStream();
        }

        @Override
        public Writer openWriter() throws IOException {
            return new OutputStreamWriter(this.openOutputStream());
        }
    }
}

