/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.glassfish.common.AdminAuthenticator;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.PartialCompletionException;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.spi.WSDesc;

public class CommandRunner
extends BasicTask<GlassfishModule.OperationState> {
    public final int HTTP_RETRY_DELAY = 3000;
    private static ExecutorService executor;
    private static Authenticator AUTH;
    private ServerCommand serverCmd;
    private boolean authorized;
    private final CommandFactory cf;
    private final boolean isReallyRunning;

    private static synchronized ExecutorService executor() {
        if (executor == null) {
            executor = Executors.newFixedThreadPool(1);
        }
        return executor;
    }

    public CommandRunner(boolean isReallyRunning, CommandFactory cf, Map<String, String> properties, OperationStateListener ... stateListener) {
        super(properties, stateListener);
        this.cf = cf;
        this.isReallyRunning = isReallyRunning;
    }

    public Future<GlassfishModule.OperationState> stopServer() {
        return this.execute(Commands.STOP, "MSG_STOP_SERVER_IN_PROGRESS");
    }

    public Future<GlassfishModule.OperationState> restartServer(int debugPort, String query) {
        Map<String, String> data;
        final String restartQuery = query;
        if (-1 == debugPort || "".equals(restartQuery)) {
            return this.execute(new ServerCommand("restart-domain"){

                @Override
                public String getQuery() {
                    return restartQuery;
                }
            }, "MSG_RESTART_SERVER_IN_PROGRESS");
        }
        CommandRunner inner = new CommandRunner(this.isReallyRunning, this.cf, this.ip, new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            }
        });
        ServerCommand.GetPropertyCommand getCmd = new ServerCommand.GetPropertyCommand("configs.config.server-config.java-config.debug-options");
        GlassfishModule.OperationState state = null;
        try {
            state = inner.execute(getCmd).get();
        }
        catch (InterruptedException ie) {
            Logger.getLogger("glassfish").log(Level.INFO, debugPort + "", ie);
        }
        catch (ExecutionException ee) {
            Logger.getLogger("glassfish").log(Level.INFO, debugPort + "", ee);
        }
        String qs = null;
        if (state == GlassfishModule.OperationState.COMPLETED && !(data = getCmd.getData()).isEmpty()) {
            String oldValue = data.get("configs.config.server-config.java-config.debug-options");
            ServerCommand.SetPropertyCommand setCmd = this.cf.getSetPropertyCommand("configs.config.server-config.java-config.debug-options", oldValue.replace("transport=dt_shmem", "transport=dt_socket").replace("address=[^,]+", "address=" + debugPort));
            try {
                state = inner.execute(setCmd).get();
                qs = "debug=true";
            }
            catch (InterruptedException ie) {
                Logger.getLogger("glassfish").log(Level.INFO, debugPort + "", ie);
            }
            catch (ExecutionException ee) {
                Logger.getLogger("glassfish").log(Level.INFO, debugPort + "", ee);
            }
        }
        if (null == qs) {
            qs = "debug=false";
        }
        final String fqs = qs;
        return this.execute(new ServerCommand("restart-domain"){

            @Override
            public String getQuery() {
                return fqs;
            }
        }, "MSG_RESTART_SERVER_IN_PROGRESS");
    }

    public Map<String, List<AppDesc>> getApplications(String container) {
        Map<String, List<AppDesc>> result = Collections.emptyMap();
        try {
            Map<String, List<String>> apps = Collections.emptyMap();
            Commands.ListComponentsCommand cmd = new Commands.ListComponentsCommand(container);
            this.serverCmd = cmd;
            Future<GlassfishModule.OperationState> task = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState state = task.get();
            if (state == GlassfishModule.OperationState.COMPLETED) {
                apps = cmd.getApplicationMap();
            }
            ServerCommand.GetPropertyCommand getCmd = new ServerCommand.GetPropertyCommand("applications.application.*");
            this.serverCmd = getCmd;
            task = CommandRunner.executor().submit(this);
            state = task.get();
            if (state == GlassfishModule.OperationState.COMPLETED) {
                ServerCommand.GetPropertyCommand getRefs = new ServerCommand.GetPropertyCommand("servers.server.server.application-ref.*");
                this.serverCmd = getRefs;
                task = CommandRunner.executor().submit(this);
                state = task.get();
                if (GlassfishModule.OperationState.COMPLETED == state) {
                    result = this.processApplications(apps, getCmd.getData(), getRefs.getData());
                }
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return result;
    }

    private Map<String, List<AppDesc>> processApplications(Map<String, List<String>> appsList, Map<String, String> properties, Map<String, String> refProperties) {
        HashMap<String, List<AppDesc>> result = new HashMap<String, List<AppDesc>>();
        Iterator<String> appsItr = appsList.keySet().iterator();
        while (appsItr.hasNext()) {
            boolean enabled = false;
            String engine = appsItr.next();
            List<String> apps = appsList.get(engine);
            for (int i = 0; i < apps.size(); ++i) {
                String enabledKey;
                String enabledValue;
                String path;
                String name = apps.get(i).trim();
                String appname = "applications.application." + name;
                String contextKey = appname + ".context-root";
                String pathKey = appname + ".location";
                String contextRoot = properties.get(contextKey);
                if (contextRoot == null) {
                    contextRoot = name;
                }
                if (contextRoot.startsWith("/")) {
                    contextRoot = contextRoot.substring(1);
                }
                if ((path = properties.get(pathKey)) == null) {
                    path = "unknown";
                }
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if (null == (enabledValue = refProperties.get(enabledKey = "servers.server.server.application-ref." + name + ".enabled"))) continue;
                enabled = Boolean.parseBoolean(enabledValue);
                ArrayList<AppDesc> appList = (ArrayList<AppDesc>)result.get(engine);
                if (appList == null) {
                    appList = new ArrayList<AppDesc>();
                    result.put(engine, appList);
                }
                appList.add(new AppDesc(name, path, contextRoot, enabled));
            }
        }
        return result;
    }

    public List<WSDesc> getWebServices() {
        List<WSDesc> result = Collections.emptyList();
        try {
            List<String> wss = Collections.emptyList();
            Commands.ListWebservicesCommand cmd = new Commands.ListWebservicesCommand();
            this.serverCmd = cmd;
            Future<GlassfishModule.OperationState> task = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState state = task.get();
            if (state == GlassfishModule.OperationState.COMPLETED) {
                wss = cmd.getWebserviceList();
                result = this.processWebServices(wss);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return result;
    }

    private List<WSDesc> processWebServices(List<String> wssList) {
        ArrayList<WSDesc> result = new ArrayList<WSDesc>();
        for (String a : wssList) {
            result.add(new WSDesc(a, a + "?wsdl", a + "?Tester"));
        }
        return result;
    }

    public List<ResourceDesc> getResources(String type) {
        List<ResourceDesc> result = Collections.emptyList();
        try {
            Commands.ListResourcesCommand cmd = new Commands.ListResourcesCommand(type);
            this.serverCmd = cmd;
            Future<GlassfishModule.OperationState> task = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState state = task.get();
            if (state == GlassfishModule.OperationState.COMPLETED) {
                result = cmd.getResourceList();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return result;
    }

    public Map<String, String> getResourceData(String name) {
        try {
            String query = "resources.*";
            ServerCommand.GetPropertyCommand cmd = new ServerCommand.GetPropertyCommand(query);
            this.serverCmd = cmd;
            Future<GlassfishModule.OperationState> task = CommandRunner.executor().submit(this);
            GlassfishModule.OperationState state = task.get();
            if (state == GlassfishModule.OperationState.COMPLETED) {
                Map<String, String> retVal = cmd.getData();
                if (retVal.isEmpty()) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, new IllegalStateException(query + " has no data"));
                }
                return retVal;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return new HashMap<String, String>();
    }

    public void putResourceData(Map<String, String> data) throws PartialCompletionException {
        Set<String> keys = data.keySet();
        String itemsNotUpdated = null;
        Exception lastEx = null;
        Iterator<String> i$ = keys.iterator();
        while (i$.hasNext()) {
            String k;
            String compName = k = i$.next();
            String compValue = data.get(k);
            try {
                ServerCommand.SetPropertyCommand cmd = this.cf.getSetPropertyCommand(compName, compValue);
                this.serverCmd = cmd;
                Future<GlassfishModule.OperationState> task = CommandRunner.executor().submit(this);
                GlassfishModule.OperationState state = task.get();
                if (state != GlassfishModule.OperationState.COMPLETED) continue;
                cmd.processResponse();
            }
            catch (InterruptedException ex) {
                lastEx = ex;
                Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
                itemsNotUpdated = this.addName(compName, itemsNotUpdated);
            }
            catch (ExecutionException ex) {
                lastEx = ex;
                Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
                itemsNotUpdated = this.addName(compName, itemsNotUpdated);
            }
        }
        if (null != itemsNotUpdated) {
            PartialCompletionException pce = new PartialCompletionException(itemsNotUpdated);
            if (null != lastEx) {
                pce.initCause(lastEx);
            }
            throw pce;
        }
    }

    public Future<GlassfishModule.OperationState> deploy(File dir) {
        return this.deploy(dir, dir.getParentFile().getName(), null);
    }

    public Future<GlassfishModule.OperationState> deploy(File dir, String moduleName) {
        return this.deploy(dir, moduleName, null);
    }

    public Future<GlassfishModule.OperationState> deploy(File dir, String moduleName, String contextRoot) {
        return this.deploy(dir, moduleName, contextRoot, null, new File[0]);
    }

    public Future<GlassfishModule.OperationState> deploy(File dir, String moduleName, String contextRoot, Map<String, String> properties, File[] libraries) {
        LogViewMgr.displayOutput(this.ip, null);
        return this.execute(new Commands.DeployCommand(dir, moduleName, contextRoot, CommandRunner.computePreserveSessions(this.ip), properties, libraries));
    }

    public Future<GlassfishModule.OperationState> redeploy(String moduleName, String contextRoot, File[] libraries, boolean resourcesChanged) {
        LogViewMgr.displayOutput(this.ip, null);
        return this.execute(new Commands.RedeployCommand(moduleName, contextRoot, CommandRunner.computePreserveSessions(this.ip), libraries, resourcesChanged));
    }

    private static Boolean computePreserveSessions(Map<String, String> ip) {
        String sessionPreservationFlag = ip.get("preserveSessionsOn");
        if (null == sessionPreservationFlag) {
            sessionPreservationFlag = System.getProperty("glassfish.session.preservation.enabled", "false");
        }
        return Boolean.parseBoolean(sessionPreservationFlag);
    }

    public Future<GlassfishModule.OperationState> undeploy(String moduleName) {
        LogViewMgr.displayOutput(this.ip, null);
        return this.execute(new Commands.UndeployCommand(moduleName));
    }

    public Future<GlassfishModule.OperationState> enable(String moduleName) {
        return this.execute(new Commands.EnableCommand(moduleName));
    }

    public Future<GlassfishModule.OperationState> disable(String moduleName) {
        return this.execute(new Commands.DisableCommand(moduleName));
    }

    public Future<GlassfishModule.OperationState> unregister(String resourceName, String suffix, String cmdPropName, boolean cascade) {
        return this.execute(new Commands.UnregisterCommand(resourceName, suffix, cmdPropName, cascade));
    }

    public Future<GlassfishModule.OperationState> execute(ServerCommand command) {
        return this.execute(command, null);
    }

    private String addName(String compName, String itemsNotUpdated) {
        String retVal = itemsNotUpdated;
        retVal = null != itemsNotUpdated ? retVal + ", " + compName : compName;
        return retVal;
    }

    private Future<GlassfishModule.OperationState> execute(ServerCommand command, String msgResId) {
        this.serverCmd = command;
        if (msgResId != null) {
            this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, msgResId, this.instanceName);
        }
        return CommandRunner.executor().submit(this);
    }

    @Override
    public GlassfishModule.OperationState call() {
        String commandUrl;
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_ServerCmdRunning", this.serverCmd.toString(), this.instanceName);
        if (!this.isReallyRunning) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_ServerCmdFailedIncorrectInstance", this.serverCmd.toString(), this.instanceName);
        }
        boolean httpSucceeded = false;
        boolean commandSucceeded = false;
        URL urlToConnectTo = null;
        URLConnection conn = null;
        try {
            commandUrl = this.constructCommandUrl(this.serverCmd.getSrc(), this.serverCmd.getCommand(), this.serverCmd.getQuery());
        }
        catch (URISyntaxException ex) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_ServerCmdException", this.serverCmd.toString(), this.instanceName, ex.getLocalizedMessage());
        }
        int retries = 1;
        Logger.getLogger("glassfish").log(Level.FINEST, "CommandRunner.call({0}) called on thread \"{1}\"", new Object[]{commandUrl, Thread.currentThread().getName()});
        try {
            urlToConnectTo = new URL(commandUrl);
            while (!httpSucceeded && retries-- > 0) {
                block22: {
                    try {
                        Logger.getLogger("glassfish").log(Level.FINE, "HTTP Command: {0}", commandUrl);
                        conn = urlToConnectTo.openConnection();
                        if (conn instanceof HttpURLConnection) {
                            HttpURLConnection hconn = (HttpURLConnection)conn;
                            if (conn instanceof HttpsURLConnection) {
                                TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                                    @Override
                                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                                    }

                                    @Override
                                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                                    }

                                    @Override
                                    public X509Certificate[] getAcceptedIssuers() {
                                        return null;
                                    }
                                }};
                                SSLContext context = null;
                                try {
                                    context = SSLContext.getInstance("SSL");
                                    context.init(null, tm, null);
                                    ((HttpsURLConnection)hconn).setSSLSocketFactory(context.getSocketFactory());
                                    ((HttpsURLConnection)hconn).setHostnameVerifier(new HostnameVerifier(){

                                        @Override
                                        public boolean verify(String string, SSLSession ssls) {
                                            return true;
                                        }
                                    });
                                }
                                catch (Exception ex) {
                                    Logger.getLogger("glassfish").log(Level.INFO, "trust manager problem: " + urlToConnectTo, ex);
                                }
                            }
                            hconn.setAllowUserInteraction(false);
                            hconn.setDoInput(true);
                            hconn.setUseCaches(false);
                            hconn.setRequestMethod(this.serverCmd.getRequestMethod());
                            hconn.setDoOutput(this.serverCmd.getDoOutput());
                            String contentType = this.serverCmd.getContentType();
                            if (contentType != null && contentType.length() > 0) {
                                hconn.setRequestProperty("Content-Type", contentType);
                                hconn.setChunkedStreamingMode(0);
                            }
                            hconn.setRequestProperty("User-Agent", "hk2-agent");
                            if (this.serverCmd.acceptsGzip()) {
                                hconn.setRequestProperty("Accept-Encoding", "gzip");
                            }
                            Authenticator.setDefault(AUTH);
                            hconn.connect();
                            this.handleSend(hconn);
                            int respCode = hconn.getResponseCode();
                            if (respCode == 401 || respCode == 403) {
                                this.authorized = false;
                                String messageId = "MSG_AuthorizationFailed";
                                if (this.ip.get("domainsfolder") == null) {
                                    messageId = "MSG_AuthorizationFailedRemote";
                                }
                                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, messageId, this.serverCmd.toString(), this.instanceName);
                            }
                            if (Boolean.getBoolean("org.netbeans.modules.hk2.LogManagerCommands")) {
                                Logger.getLogger("glassfish").log(Level.FINE, "  receiving response, code: {0}", respCode);
                            }
                            if (this.handleReceive(hconn)) {
                                commandSucceeded = this.serverCmd.processResponse();
                            }
                            httpSucceeded = true;
                            break block22;
                        }
                        Logger.getLogger("glassfish").log(Level.INFO, "Unexpected connection type: {0}", urlToConnectTo);
                    }
                    catch (ProtocolException ex) {
                        this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_Exception", ex.getLocalizedMessage());
                        retries = 0;
                    }
                    catch (IOException ex) {
                        if (retries > 0) break block22;
                        this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_Exception", ex.getLocalizedMessage());
                    }
                }
                if (httpSucceeded || retries <= 0) continue;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        if (commandSucceeded) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_ServerCmdCompleted", this.serverCmd.toString(), this.instanceName);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_ServerCmdFailed", this.serverCmd.toString(), this.instanceName, this.serverCmd.getServerMessage());
    }

    private String constructCommandUrl(String cmdSrc, String cmd, String query) throws URISyntaxException {
        String host = (String)this.ip.get("host");
        boolean useAdminPort = !"false".equals(System.getProperty("glassfish.useadminport"));
        int port = Integer.parseInt((String)this.ip.get(useAdminPort ? "adminPort" : "httpportnumber"));
        URI uri = new URI(Utils.getHttpListenerProtocol(host, port), null, host, port, cmdSrc + cmd, query, null);
        return uri.toASCIIString().replace("+", "%2b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSend(HttpURLConnection hconn) throws IOException {
        InputStream istream = this.serverCmd.getInputStream();
        if (istream != null) {
            ZipOutputStream ostream = null;
            try {
                int n;
                ostream = new ZipOutputStream(new BufferedOutputStream(hconn.getOutputStream(), 0x100000));
                ZipEntry e = new ZipEntry(this.serverCmd.getInputName());
                e.setExtra(this.getExtraProperties());
                ostream.putNextEntry(e);
                byte[] buffer = new byte[0x100000];
                while ((n = istream.read(buffer)) >= 0) {
                    ostream.write(buffer, 0, n);
                }
                ostream.closeEntry();
                ostream.flush();
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    ostream = null;
                }
            }
        }
        if ("POST".equalsIgnoreCase(this.serverCmd.getRequestMethod())) {
            Logger.getLogger("glassfish").log(Level.INFO, "HTTP POST request but no data stream provided");
        }
    }

    private byte[] getExtraProperties() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = new Properties();
        props.setProperty("data-request-type", "file-xfer");
        props.setProperty("last-modified", this.serverCmd.getLastModified());
        props.put("data-request-name", "DEFAULT");
        props.put("data-request-is-recursive", "true");
        props.put("Content-Type", "application/octet-stream");
        props.list(new PrintStream(baos));
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleReceive(HttpURLConnection hconn) throws IOException {
        boolean result = false;
        InputStream httpInputStream = hconn.getInputStream();
        try {
            result = this.serverCmd.readResponse(httpInputStream, hconn);
        }
        finally {
            try {
                httpInputStream.close();
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return result;
    }

    static {
        AUTH = new AdminAuthenticator();
    }
}

