/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.PortCollection;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.glassfish.common.ui.InstanceCustomizer;
import org.netbeans.modules.glassfish.common.ui.VmCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModuleFactory;
import org.netbeans.modules.glassfish.spi.RemoveCookie;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

public class GlassfishInstance
implements ServerInstanceImplementation,
LookupListener {
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ADMIN_NAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWORD = "adminadmin";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_HTTPS_PORT = 8181;
    public static final int DEFAULT_ADMIN_PORT = 4848;
    public static final String DEFAULT_DOMAINS_FOLDER = "domains";
    public static final String DEFAULT_DOMAIN_NAME = "domain1";
    private boolean removable;
    private transient CommonServerSupport commonSupport;
    private transient InstanceContent ic;
    private transient Lookup lookup;
    private final transient Lookup.Result<GlassfishModuleFactory> lookupResult;
    private transient Collection<? extends GlassfishModuleFactory> currentFactories;
    private ServerInstance commonInstance;
    private GlassfishInstanceProvider instanceProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlassfishInstance(Map<String, String> ip, GlassfishInstanceProvider instanceProvider, boolean updateNow) {
        block6: {
            this.removable = true;
            this.lookupResult = Lookups.forPath((String)"Servers/GlassFish").lookupResult(GlassfishModuleFactory.class);
            this.currentFactories = Collections.emptyList();
            String deployerUri = null;
            try {
                PortCollection pc;
                File domainDir;
                this.ic = new InstanceContent();
                this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
                this.instanceProvider = instanceProvider;
                String domainDirPath = ip.get("domainsfolder");
                String domainName = ip.get("domainname");
                if (null != domainDirPath && null != domainName && Util.readServerConfiguration(domainDir = new File(domainDirPath, domainName), pc = new PortCollection())) {
                    ip.put("adminPort", Integer.toString(pc.getAdminPort()));
                    ip.put("httpportnumber", Integer.toString(pc.getHttpPort()));
                }
                this.commonSupport = new CommonServerSupport(this.lookup, ip, instanceProvider);
                deployerUri = this.commonSupport.getDeployerUri();
                GlassfishInstanceProvider.activeRegistrationSet.add(deployerUri);
                if (null == instanceProvider.getInstance(deployerUri)) {
                    this.ic.add((Object)this);
                    this.ic.add((Object)this.commonSupport);
                    this.commonInstance = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)this);
                    if (updateNow) {
                        this.updateModuleSupport();
                    }
                    instanceProvider.addServerInstance(this);
                }
                if (deployerUri == null) break block6;
                GlassfishInstanceProvider.activeRegistrationSet.remove(deployerUri);
            }
            catch (Throwable throwable) {
                if (deployerUri != null) {
                    GlassfishInstanceProvider.activeRegistrationSet.remove(deployerUri);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFactories() {
        Properties asenvProps = new Properties();
        String homeFolder = this.commonSupport.getGlassfishRoot();
        File asenvConf = new File(homeFolder, "config/asenv.conf");
        if (asenvConf.exists()) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(asenvConf));
                asenvProps.load(is);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, null, ex);
                asenvProps.clear();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "{0} does not exist", asenvConf.getAbsolutePath());
        }
        HashSet added = new HashSet();
        Lookup.Result<GlassfishModuleFactory> result = this.lookupResult;
        synchronized (result) {
            Collection factories = this.lookupResult.allInstances();
            added.addAll(factories);
            added.removeAll(this.currentFactories);
            this.currentFactories = factories;
            for (GlassfishModuleFactory moduleFactory : added) {
                if (!moduleFactory.isModuleSupported(homeFolder, asenvProps)) continue;
                Object t = moduleFactory.createModule(this.lookup);
                if (null == t) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "{0} created a null module", moduleFactory);
                    continue;
                }
                this.ic.add(t);
            }
        }
    }

    void updateModuleSupport() {
        this.updateFactories();
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent ev) {
        this.updateFactories();
    }

    public static GlassfishInstance create(String displayName, String installRoot, String glassfishRoot, String domainsDir, String domainName, int httpPort, int adminPort, String url, String uriFragment, GlassfishInstanceProvider gip) {
        String[] urlParts;
        HashMap<String, String> ip = new HashMap<String, String>();
        ip.put("displayName", displayName);
        ip.put("installfolder", installRoot);
        ip.put("homefolder", glassfishRoot);
        ip.put("domainsfolder", domainsDir);
        ip.put("domainname", domainName);
        ip.put("httpportnumber", Integer.toString(httpPort));
        ip.put("adminPort", Integer.toString(adminPort));
        ip.put("url", url);
        String[] bigUrlParts = url.split("]");
        if (null != bigUrlParts && bigUrlParts.length > 1 && null != (urlParts = bigUrlParts[1].split(":")) && urlParts.length > 2) {
            ip.put("host", urlParts[2]);
        }
        GlassfishInstance result = new GlassfishInstance(ip, gip, true);
        return result;
    }

    public static GlassfishInstance create(Map<String, String> ip, GlassfishInstanceProvider gip, boolean updateNow) {
        return new GlassfishInstance(ip, gip, updateNow);
    }

    public static GlassfishInstance create(Map<String, String> ip, GlassfishInstanceProvider gip) {
        GlassfishInstance result = new GlassfishInstance(ip, gip, true);
        return result;
    }

    public ServerInstance getCommonInstance() {
        return this.commonInstance;
    }

    public CommonServerSupport getCommonSupport() {
        return this.commonSupport;
    }

    public String getDeployerUri() {
        return this.commonSupport.getDeployerUri();
    }

    public String getInstallRoot() {
        return this.commonSupport.getInstallRoot();
    }

    public String getGlassfishRoot() {
        return this.commonSupport.getGlassfishRoot();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void addChangeListener(ChangeListener listener) {
        this.commonSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.commonSupport.removeChangeListener(listener);
    }

    public GlassfishModule.ServerState getServerState() {
        return this.commonSupport.getServerState();
    }

    void stopIfStartedByIde(long timeout) {
        if (this.commonSupport.isStartedByIde()) {
            GlassfishModule.ServerState state = this.commonSupport.getServerState();
            if (state == GlassfishModule.ServerState.STARTING || state == GlassfishModule.ServerState.RUNNING && this.commonSupport.isReallyRunning()) {
                try {
                    GlassfishModule.OperationState opState;
                    Future<GlassfishModule.OperationState> stopServerTask = this.commonSupport.stopServer(null);
                    if (timeout > 0L && (opState = stopServerTask.get(timeout, TimeUnit.MILLISECONDS)) != GlassfishModule.OperationState.COMPLETED) {
                        Logger.getLogger("glassfish").info("Stop server failed...");
                    }
                }
                catch (TimeoutException ex) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Server {0} timed out sending stop-domain command.", this.getDeployerUri());
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        } else {
            this.commonSupport.disableStop();
        }
    }

    public String getDisplayName() {
        return this.commonSupport.getDisplayName();
    }

    public String getServerDisplayName() {
        return this.commonSupport.getInstanceProvider().getDisplayName(this.commonSupport.getDeployerUri());
    }

    public Node getFullNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [FULL]");
        return new Hk2InstanceNode(this, true);
    }

    public Node getBasicNode() {
        Logger.getLogger("glassfish").finer("Creating GF Instance node [BASIC]");
        return new Hk2InstanceNode(this, false);
    }

    public JComponent getCustomizer() {
        InstanceCustomizer commonCustomizer = new InstanceCustomizer(this.commonSupport);
        VmCustomizer vmCustomizer = new VmCustomizer(this.commonSupport);
        LinkedList<JPanel> pages = new LinkedList<JPanel>();
        Collection lookupAll = this.lookup.lookupAll(CustomizerCookie.class);
        for (CustomizerCookie cookie : lookupAll) {
            pages.addAll(cookie.getCustomizerPages());
        }
        pages.add(vmCustomizer);
        JComponent tabbedPane = null;
        for (JPanel page : pages) {
            if (tabbedPane == null) {
                tabbedPane = new JTabbedPane();
                ((JTabbedPane)tabbedPane).add(commonCustomizer);
            }
            ((JTabbedPane)tabbedPane).add(page);
        }
        return tabbedPane != null ? tabbedPane : commonCustomizer;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public void remove() {
        if (!this.removable) {
            return;
        }
        this.stopIfStartedByIde(3000L);
        String uri = this.commonSupport.getDeployerUri();
        InputOutput io = LogViewMgr.getServerIO(uri);
        if (io != null && !io.isClosed()) {
            io.closeInputOutput();
        }
        Collection lookupAll = this.lookup.lookupAll(RemoveCookie.class);
        for (RemoveCookie cookie : lookupAll) {
            cookie.removeInstance(this.getDeployerUri());
        }
        this.instanceProvider.removeServerInstance(this);
        this.ic.remove((Object)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlassfishInstance)) {
            return false;
        }
        GlassfishInstance other = (GlassfishInstance)obj;
        if (null == this.getDeployerUri()) {
            return false;
        }
        if (null == other.getDeployerUri()) {
            return false;
        }
        if (null == this.commonSupport) {
            return false;
        }
        if (null == this.commonSupport.getDomainName()) {
            return false;
        }
        if (null == other.getCommonSupport()) {
            return false;
        }
        if (null == other.getCommonSupport().getDomainName()) {
            return false;
        }
        return this.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME).equals(other.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME)) && this.commonSupport.getDomainName().equals(other.getCommonSupport().getDomainName()) && this.commonSupport.getDomainsRoot().equals(other.getCommonSupport().getDomainsRoot()) && this.commonSupport.getHttpPort().equals(other.getCommonSupport().getHttpPort());
    }

    public int hashCode() {
        String tmp = this.getDeployerUri().replace("127.0.0.1", DEFAULT_HOST_NAME) + this.commonSupport.getHttpPort() + this.commonSupport.getDomainsRoot() + this.commonSupport.getDomainName();
        return tmp.hashCode();
    }
}

