/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.maven.codegen.NewProfilePanel;
import org.netbeans.modules.maven.model.settings.Mirror;
import org.netbeans.modules.maven.model.settings.SettingsModel;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewMirrorPanel
extends JPanel {
    private SettingsModel model;
    private NotificationLineSupport nls;
    private static final String CENTRAL = "central";
    private static final String ALL = "*";
    private static final String ALL_NON_LOCAL = "external:*";
    private static final String ALL_BUT_FOO = "*,!foo";
    private static final String LIST = "foo,bar";
    private final String[] MIRROROFS = new String[]{"central", "*", "external:*", "*,!foo", "foo,bar"};
    private DefaultComboBoxModel urlmodel;
    private JButton btnLink;
    private JComboBox comMirrorOf;
    private JComboBox comUrl;
    private JLabel lblId;
    private JLabel lblMirrorOf;
    private JLabel lblUrl;
    private JTextField txtId;

    public NewMirrorPanel(SettingsModel model) {
        this.initComponents();
        this.model = model;
        this.txtId.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewMirrorPanel.this.checkId();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewMirrorPanel.this.checkId();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewMirrorPanel.this.checkId();
            }
        });
        DefaultComboBoxModel<String> mirrormodel = new DefaultComboBoxModel<String>(this.MIRROROFS);
        this.comMirrorOf.setModel(mirrormodel);
        this.comMirrorOf.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component toRet = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (toRet instanceof JLabel) {
                    JLabel label = (JLabel)toRet;
                    if (NewMirrorPanel.CENTRAL.equals(value)) {
                        label.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_Central"));
                    } else if (NewMirrorPanel.ALL.equals(value)) {
                        label.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_All"));
                    } else if (NewMirrorPanel.ALL_NON_LOCAL.equals(value)) {
                        label.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_NonLocal"));
                    } else if (NewMirrorPanel.ALL_BUT_FOO.equals(value)) {
                        label.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_AllButFoo"));
                    } else if (NewMirrorPanel.LIST.equals(value)) {
                        label.setText(NbBundle.getMessage(NewMirrorPanel.class, (String)"LBL_List"));
                    }
                }
                return toRet;
            }
        });
        Component cmp = this.comMirrorOf.getEditor().getEditorComponent();
        if (cmp instanceof JTextField) {
            JTextField fld = (JTextField)cmp;
            fld.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    NewMirrorPanel.this.checkCentral();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    NewMirrorPanel.this.checkCentral();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    NewMirrorPanel.this.checkCentral();
                }
            });
        }
        this.urlmodel = new DefaultComboBoxModel();
        this.comUrl.setModel(this.urlmodel);
        this.btnLink.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URL link = new URL("http://maven.apache.org/guides/mini/guide-mirror-settings.html");
                    HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.checkCentral();
    }

    public void attachDialogDisplayer(DialogDescriptor dd) {
        this.nls = dd.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dd.createNotificationLineSupport();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    private void checkId() {
        String id = this.txtId.getText().trim();
        Mirror existing = this.model.getSettings().findMirrorById(id);
        if (existing != null) {
            this.nls.setErrorMessage(NbBundle.getMessage(NewProfilePanel.class, (String)"ERR_SameMirrorId"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void checkCentral() {
        String sel = (String)this.comMirrorOf.getSelectedItem();
        this.urlmodel.removeAllElements();
        if (CENTRAL.equals(sel)) {
            this.urlmodel.addElement("http://mirrors.ibiblio.org/pub/mirrors/maven2");
            this.urlmodel.addElement("http://www.ibiblio.net/pub/packages/maven2");
            this.urlmodel.addElement("http://ftp.cica.es/mirrors/maven2");
            this.urlmodel.addElement("http://repo1.sonatype.net/maven2");
            this.urlmodel.addElement("http://repo.exist.com/maven2");
            this.urlmodel.addElement("http://mirrors.redv.com/maven2");
            this.urlmodel.addElement("http://mirrors.dotsrc.org/maven2");
        }
    }

    private void initComponents() {
        this.lblId = new JLabel();
        this.txtId = new JTextField();
        this.lblMirrorOf = new JLabel();
        this.comMirrorOf = new JComboBox();
        this.lblUrl = new JLabel();
        this.comUrl = new JComboBox();
        this.btnLink = new JButton();
        this.lblId.setLabelFor(this.txtId);
        Mnemonics.setLocalizedText((JLabel)this.lblId, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblId.text"));
        this.lblMirrorOf.setLabelFor(this.comMirrorOf);
        Mnemonics.setLocalizedText((JLabel)this.lblMirrorOf, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblMirrorOf.text"));
        this.comMirrorOf.setEditable(true);
        this.comMirrorOf.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblUrl.setLabelFor(this.comUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.lblUrl.text"));
        this.comUrl.setEditable(true);
        this.comUrl.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLink, (String)NbBundle.getMessage(NewMirrorPanel.class, (String)"NewMirrorPanel.btnLink.text"));
        this.btnLink.setBorder(null);
        this.btnLink.setBorderPainted(false);
        this.btnLink.setContentAreaFilled(false);
        this.btnLink.setHorizontalAlignment(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMirrorOf).addComponent(this.lblId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.txtId, -1, 159, Short.MAX_VALUE).addGap(145, 145, 145)).addComponent(this.comMirrorOf, 0, 304, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.lblUrl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comUrl, 0, 303, Short.MAX_VALUE)).addComponent(this.btnLink, -1, 400, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblId).addComponent(this.txtId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMirrorOf).addComponent(this.comMirrorOf, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUrl).addComponent(this.comUrl, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.btnLink, -2, -1, -2).addContainerGap(36, Short.MAX_VALUE)));
    }

    String getMirrorId() {
        return this.txtId.getText().trim();
    }

    String getMirrorOf() {
        return (String)this.comMirrorOf.getSelectedItem();
    }

    String getMirrorUrl() {
        return (String)this.comUrl.getSelectedItem();
    }
}

