/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.dd.api.common.CreateCapability;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.JspConfig;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.Taglib;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.config.model.MessageResources;
import org.netbeans.modules.web.struts.ui.StrutsConfigurationPanel;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class StrutsFrameworkProvider
extends WebFrameworkProvider {
    private static String RESOURCE_FOLDER = "org/netbeans/modules/web/struts/resources/";
    private StrutsConfigurationPanel panel;
    private static String defaultAppResource = "com.myapp.struts.ApplicationResource";

    public StrutsFrameworkProvider() {
        super(NbBundle.getMessage(StrutsFrameworkProvider.class, (String)"Sruts_Name"), NbBundle.getMessage(StrutsFrameworkProvider.class, (String)"Sruts_Description"));
    }

    public Set extendImpl(WebModule wm) {
        FileObject fo = wm.getDocumentBase();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<FileObject> result = new HashSet<FileObject>();
        Library lib = LibraryManager.getDefault().getLibrary("struts");
        if (lib != null) {
            ProjectClassPathExtender cpExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
            if (cpExtender != null) {
                try {
                    cpExtender.addLibrary(lib);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                Logger.getLogger("global").log(Level.INFO, "WebProjectClassPathExtender not found in the project lookup of project: " + project.getProjectDirectory().getPath());
            }
            try {
                FileSystem fs = wm.getWebInf().getFileSystem();
                fs.runAtomicAction((FileSystem.AtomicAction)new CreateStrutsConfig(wm));
                result.add(wm.getDocumentBase().getFileObject("welcomeStruts", "jsp"));
            }
            catch (FileNotFoundException exc) {
                Exceptions.printStackTrace((Throwable)exc);
            }
            catch (IOException exc) {
                Logger.getLogger("global").log(Level.INFO, null, exc);
            }
        }
        return result;
    }

    private static String readResource(InputStream is, String encoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public File[] getConfigurationFiles(WebModule wm) {
        FileObject webinf = wm.getWebInf();
        ArrayList<File> files = new ArrayList<File>();
        FileObject dd = wm.getDeploymentDescriptor();
        if (dd != null) {
            FileObject fo;
            FileObject[] configs = StrutsConfigUtilities.getConfigFilesFO(dd);
            if (configs != null) {
                for (int i = 0; i < configs.length; ++i) {
                    files.add(FileUtil.toFile((FileObject)configs[i]));
                }
            }
            if ((fo = webinf.getFileObject("tiles-defs.xml")) != null) {
                files.add(FileUtil.toFile((FileObject)fo));
            }
            if ((fo = webinf.getFileObject("validation.xml")) != null) {
                files.add(FileUtil.toFile((FileObject)fo));
            }
            if ((fo = webinf.getFileObject("validator-rules.xml")) != null) {
                files.add(FileUtil.toFile((FileObject)fo));
            }
        }
        File[] rFiles = new File[files.size()];
        files.toArray(rFiles);
        return rFiles;
    }

    public boolean isInWebModule(WebModule wm) {
        FileObject dd = wm.getDeploymentDescriptor();
        return dd != null && StrutsConfigUtilities.getActionServlet(dd) != null;
    }

    public WebModuleExtender createWebModuleExtender(WebModule wm, ExtenderController controller) {
        boolean defaultValue = wm == null || !this.isInWebModule(wm);
        this.panel = new StrutsConfigurationPanel(this, controller, !defaultValue);
        if (defaultValue) {
            this.panel.setAppResource(defaultAppResource);
        } else {
            String name;
            Servlet servlet = StrutsConfigUtilities.getActionServlet(wm.getDeploymentDescriptor());
            this.panel.setServletName(servlet.getServletName());
            this.panel.setURLPattern(StrutsConfigUtilities.getActionServletMapping(wm.getDeploymentDescriptor()));
            MessageResources resource = StrutsConfigUtilities.getDefatulMessageResource(wm.getDeploymentDescriptor());
            if (resource != null && (name = resource.getAttributeValue("parameter")) != null) {
                name = name.replaceAll("/", ".");
                this.panel.setAppResource(name);
            }
        }
        return this.panel;
    }

    private class CreateStrutsConfig
    implements FileSystem.AtomicAction {
        WebModule wm;

        public CreateStrutsConfig(WebModule wm) {
            this.wm = wm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createFile(FileObject target, String content, String encoding) throws IOException {
            FileLock lock = target.lock();
            try {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(lock), encoding));
                bw.write(content);
                bw.close();
            }
            finally {
                lock.releaseLock();
            }
        }

        public void run() throws IOException {
            FileObject target;
            String content;
            if (this.canCreateNewFile(this.wm.getWebInf(), "struts-config.xml")) {
                content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-config.xml"), "UTF-8");
                content = content.replaceFirst("____ACTION_MAPPING___", StrutsConfigUtilities.getActionAsResource(StrutsFrameworkProvider.this.panel.getURLPattern(), "/Welcome"));
                content = content.replaceFirst("_____MESSAGE_RESOURCE____", StrutsFrameworkProvider.this.panel.getAppResource().replace('.', '/'));
                target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-config.xml");
                this.createFile(target, content, "UTF-8");
            }
            if (this.canCreateNewFile(this.wm.getWebInf(), "tiles-defs.xml")) {
                content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "tiles-defs.xml"), "UTF-8");
                target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"tiles-defs.xml");
                this.createFile(target, content, "UTF-8");
            }
            if (this.canCreateNewFile(this.wm.getWebInf(), "validation.xml")) {
                content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "validation.xml"), "UTF-8");
                target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"validation.xml");
                this.createFile(target, content, "UTF-8");
            }
            if (this.canCreateNewFile(this.wm.getWebInf(), "validator-rules.xml")) {
                content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "validator-rules.xml"), "UTF-8");
                target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"validator-rules.xml");
                this.createFile(target, content, "UTF-8");
            }
            Project project = FileOwnerQuery.getOwner((FileObject)this.wm.getDocumentBase());
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            String sresource = StrutsFrameworkProvider.this.panel.getAppResource();
            if (sresource != null && sresource.trim().length() > 0) {
                int index = sresource.lastIndexOf(46);
                String path = "";
                String name = sresource;
                if (index > -1) {
                    path = sresource.substring(0, sresource.lastIndexOf("."));
                    name = sresource.substring(sresource.lastIndexOf(".") + 1);
                }
                name = name + ".properties";
                FileObject targetFolder = sourceGroups[0].getRootFolder();
                String[] folders = path.split("\\.");
                for (int i = 0; i < folders.length; ++i) {
                    targetFolder = targetFolder.getFileObject(folders[i]) == null ? targetFolder.createFolder(folders[i]) : targetFolder.getFileObject(folders[i]);
                }
                if (this.canCreateNewFile(targetFolder, name)) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "MessageResources.properties"), "UTF-8");
                    target = FileUtil.createData((FileObject)targetFolder, (String)name);
                    this.createFile(target, content, "UTF-8");
                }
            }
            if (StrutsFrameworkProvider.this.panel.addTLDs()) {
                if (this.canCreateNewFile(this.wm.getWebInf(), "struts-bean.tld")) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-bean.tld"), "UTF-8");
                    target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-bean.tld");
                    this.createFile(target, content, "UTF-8");
                }
                if (this.canCreateNewFile(this.wm.getWebInf(), "struts-html.tld")) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-html.tld"), "UTF-8");
                    target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-html.tld");
                    this.createFile(target, content, "UTF-8");
                }
                if (this.canCreateNewFile(this.wm.getWebInf(), "struts-logic.tld")) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-logic.tld"), "UTF-8");
                    target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-logic.tld");
                    this.createFile(target, content, "UTF-8");
                }
                if (this.canCreateNewFile(this.wm.getWebInf(), "struts-nested.tld")) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-nested.tld"), "UTF-8");
                    target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-nested.tld");
                    this.createFile(target, content, "UTF-8");
                }
                if (this.canCreateNewFile(this.wm.getWebInf(), "struts-tiles.tld")) {
                    content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "struts-tiles.tld"), "UTF-8");
                    target = FileUtil.createData((FileObject)this.wm.getWebInf(), (String)"struts-tiles.tld");
                    this.createFile(target, content, "UTF-8");
                }
            }
            FileObject dd = this.wm.getDeploymentDescriptor();
            WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
            if (ddRoot != null) {
                try {
                    WelcomeFileList welcomeFiles;
                    Servlet servlet = (Servlet)ddRoot.createBean("Servlet");
                    servlet.setServletName("action");
                    servlet.setServletClass("org.apache.struts.action.ActionServlet");
                    ddRoot.addServlet(servlet);
                    InitParam param = (InitParam)servlet.createBean("InitParam");
                    param.setParamName("config");
                    param.setParamValue("/WEB-INF/struts-config.xml");
                    servlet.addInitParam(param);
                    param = (InitParam)servlet.createBean("InitParam");
                    param.setParamName("debug");
                    param.setParamValue("2");
                    servlet.addInitParam(param);
                    param = (InitParam)servlet.createBean("InitParam");
                    param.setParamName("detail");
                    param.setParamValue("2");
                    servlet.addInitParam(param);
                    servlet.setLoadOnStartup(new BigInteger("2"));
                    ServletMapping mapping = (ServletMapping)ddRoot.createBean("ServletMapping");
                    mapping.setServletName(StrutsFrameworkProvider.this.panel.getServletName());
                    mapping.setUrlPattern(StrutsFrameworkProvider.this.panel.getURLPattern());
                    ddRoot.addServletMapping(mapping);
                    if (StrutsFrameworkProvider.this.panel.addTLDs()) {
                        try {
                            JspConfig jspConfig = ddRoot.getSingleJspConfig();
                            if (jspConfig == null) {
                                jspConfig = (JspConfig)ddRoot.createBean("JspConfig");
                                ddRoot.setJspConfig(jspConfig);
                            }
                            jspConfig.addTaglib(this.createTaglib((CreateCapability)jspConfig, "/WEB-INF/struts-bean.tld", "/WEB-INF/struts-bean.tld"));
                            jspConfig.addTaglib(this.createTaglib((CreateCapability)jspConfig, "/WEB-INF/struts-html.tld", "/WEB-INF/struts-html.tld"));
                            jspConfig.addTaglib(this.createTaglib((CreateCapability)jspConfig, "/WEB-INF/struts-logic.tld", "/WEB-INF/struts-logic.tld"));
                            jspConfig.addTaglib(this.createTaglib((CreateCapability)jspConfig, "/WEB-INF/struts-nested.tld", "/WEB-INF/struts-nested.tld"));
                            jspConfig.addTaglib(this.createTaglib((CreateCapability)jspConfig, "/WEB-INF/struts-tiles.tld", "/WEB-INF/struts-tiles.tld"));
                        }
                        catch (VersionNotSupportedException e) {
                            Logger.getLogger("global").log(Level.WARNING, null, e);
                        }
                    }
                    if ((welcomeFiles = ddRoot.getSingleWelcomeFileList()) == null) {
                        welcomeFiles = (WelcomeFileList)ddRoot.createBean("WelcomeFileList");
                        ddRoot.setWelcomeFileList(welcomeFiles);
                    }
                    if (welcomeFiles.sizeWelcomeFile() == 0) {
                        welcomeFiles.addWelcomeFile("index.jsp");
                    }
                    ddRoot.write(dd);
                }
                catch (ClassNotFoundException cnfe) {
                    Exceptions.printStackTrace((Throwable)cnfe);
                }
            }
            if (this.canCreateNewFile(this.wm.getDocumentBase(), "welcomeStruts.jsp")) {
                content = StrutsFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_FOLDER + "welcome.jsp"), "UTF-8");
                content = content.replaceAll("__ENCODING__", FileEncodingQuery.getDefaultEncoding().name());
                target = FileUtil.createData((FileObject)this.wm.getDocumentBase(), (String)"welcomeStruts.jsp");
                this.createFile(target, content, "UTF-8");
                File indexJsp = new File(FileUtil.toFile((FileObject)this.wm.getDocumentBase()), "index.jsp");
                if (indexJsp.exists()) {
                    FileObject documentBase = this.wm.getDocumentBase();
                    FileObject indexjsp = documentBase.getFileObject("index.jsp");
                    if (indexjsp != null) {
                        this.changeIndexJSP(indexjsp);
                    }
                } else {
                    content = "<%@page contentType=\"text/html\"%>\n<%@page pageEncoding=\"" + FileEncodingQuery.getDefaultEncoding().name() + "\"%>\n\n" + "<jsp:forward page=\"" + StrutsConfigUtilities.getWelcomeFile(StrutsFrameworkProvider.this.panel.getURLPattern(), "Welcome") + "\"/>";
                    target = FileUtil.createData((FileObject)this.wm.getDocumentBase(), (String)"index.jsp");
                    this.createFile(target, content, "UTF-8");
                }
            }
        }

        private boolean canCreateNewFile(FileObject parent, String name) {
            File fileToBe = new File(FileUtil.toFile((FileObject)parent), name);
            boolean create = true;
            if (fileToBe.exists()) {
                DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(StrutsFrameworkProvider.class, (String)"MSG_OverwriteFile", (Object)fileToBe.getAbsolutePath()), NbBundle.getMessage(StrutsFrameworkProvider.class, (String)"TTL_OverwriteFile"), true, 0, DialogDescriptor.NO_OPTION, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
                d.setVisible(true);
                create = dialog.getValue() == DialogDescriptor.NO_OPTION;
            }
            return create;
        }

        private Taglib createTaglib(CreateCapability createObject, String location, String uri) throws ClassNotFoundException {
            Taglib taglib = (Taglib)createObject.createBean("Taglib");
            taglib.setTaglibLocation(location);
            taglib.setTaglibUri(uri);
            return taglib;
        }

        private void changeIndexJSP(FileObject indexjsp) throws IOException {
            String content = StrutsFrameworkProvider.readResource(indexjsp.getInputStream(), "UTF-8");
            String find = "<h1>JSP Page</h1>";
            String endLine = System.getProperty("line.separator");
            if (content.indexOf(find) > 0) {
                StringBuffer replace = new StringBuffer();
                replace.append(find);
                replace.append(endLine);
                replace.append("    <br/>");
                replace.append(endLine);
                replace.append("    <a href=\".");
                replace.append(StrutsConfigUtilities.getActionAsResource(StrutsFrameworkProvider.this.panel.getURLPattern(), "/Welcome"));
                replace.append("\">");
                replace.append(NbBundle.getMessage(StrutsFrameworkProvider.class, (String)"LBL_STRUTS_WELCOME_PAGE"));
                replace.append("</a>");
                content = content.replaceFirst(find, replace.toString());
                this.createFile(indexjsp, content, "UTF-8");
            }
        }
    }
}

