/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class InputBuffer {
    private int nMarkers = 0;
    private int size = 0;
    private int position = 0;
    public static final int INITIAL_BUFFER_SIZE;
    public static final int READ_BUFFER_SIZE;
    private char[] data;

    public InputBuffer(char[] data) {
        this.data = data;
        this.size = data.length;
    }

    public InputBuffer(Reader input) {
        this.data = new char[INITIAL_BUFFER_SIZE + READ_BUFFER_SIZE / 2];
        try {
            int numRead = 0;
            int p = 0;
            do {
                if (p + READ_BUFFER_SIZE > this.data.length) {
                    char[] newdata = new char[this.data.length * 2];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                numRead = input.read(this.data, p, READ_BUFFER_SIZE);
                p += numRead;
            } while (numRead != -1);
            this.size = p + 1;
        }
        catch (IOException io) {
            System.err.println("tmp error: can't load input: " + io);
        }
    }

    public InputBuffer(InputStream input) {
        this(new InputStreamReader(input));
    }

    public final void consume() {
        ++this.position;
    }

    public final char LA(int i) {
        if (this.position + i - 1 >= this.size) {
            return '\uffff';
        }
        return this.data[this.position + i - 1];
    }

    public final int mark() {
        ++this.nMarkers;
        return this.position;
    }

    public final void rewind(int mark) {
        this.position = mark;
        --this.nMarkers;
    }

    static {
        READ_BUFFER_SIZE = INITIAL_BUFFER_SIZE = 8192 * Integer.getInteger("antlr.input.buffer", 1);
    }
}

