/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.syntax;

import java.util.List;
import org.netbeans.modules.cnd.asm.base.att.TokenIterator;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmBaseTokenId;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmToken;

public class SmartTemplateMatcher {
    private List<Object[]> templ;
    private int[] pos;

    public SmartTemplateMatcher(List<Object[]> templ) {
        this.templ = templ;
        this.pos = new int[templ.size()];
    }

    public void reset() {
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i] = 0;
        }
    }

    public int match(TokenIterator it) {
        int succCount;
        int matchNum = -1;
        int afterEndMatch = 0;
        do {
            AsmToken tok = it.next();
            ++afterEndMatch;
            succCount = 0;
            for (int i = 0; i < this.pos.length; ++i) {
                if (this.pos[i] >= 0 && this.isMatch(this.templ.get(i)[this.pos[i]], tok)) {
                    int n = i;
                    this.pos[n] = this.pos[n] + 1;
                    ++succCount;
                    if (this.templ.get(i).length != this.pos[i]) continue;
                    matchNum = i;
                    afterEndMatch = 0;
                    continue;
                }
                this.pos[i] = -1;
            }
        } while (succCount != 0);
        if (afterEndMatch == 1) {
            return matchNum;
        }
        return -1;
    }

    private boolean isMatch(Object pat, AsmToken tok) {
        if (pat instanceof Character && tok.getId() == AsmBaseTokenId.ASM_MARK) {
            char ch = ((Character)pat).charValue();
            if (tok.getText().length() == 1 && tok.getText().charAt(0) == ch) {
                return true;
            }
        } else if (pat instanceof AsmBaseTokenId) {
            return (AsmBaseTokenId)pat == tok.getId();
        }
        return false;
    }
}

