/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.editor;

import java.io.IOException;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmDataObject;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class AsmEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie,
EditorCookie.Observable,
OpenCookie,
CloseCookie,
PrintCookie,
ReadOnlySupport {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            AsmEditorSupport.this.saveDocument();
            AsmEditorSupport.this.getDataObject().setModified(false);
        }
    };
    private boolean isReadOnly = false;

    public AsmEditorSupport(DataObject obj) {
        super(obj, (CloneableEditorSupport.Env)new Environment(obj));
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    private void addSaveCookie() {
        AsmDataObject obj = (AsmDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(this.saveCookie);
        }
    }

    private void removeSaveCookie() {
        AsmDataObject obj = (AsmDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.removeSaveCookie(this.saveCookie);
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            ReadOnlySupport readOnly = (ReadOnlySupport)this.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (readOnly != null && readOnly.isReadOnly()) {
                throw new IOException();
            }
            return ((AsmDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(AsmEditorSupport.class);
        }
    }
}

