/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.io.File;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.profiler.MavenProjectTypeProfiler;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.util.RequestProcessor;

public class RunCheckerImpl
implements LateBoundPrerequisitesChecker {
    private static final String ACTION_PROFILE = "profile";
    private static final String ACTION_PROFILE_SINGLE = "profile-single";
    private static final String ACTION_PROFILE_TESTS = "profile-tests";
    private static final String PROFILER_ARGS = "${profiler.args}";
    private static final String PROFILER_JAVA = "${profiler.java}";
    private Project project;

    public RunCheckerImpl(Project prj) {
        this.project = prj;
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        Properties configProperties = config.getProperties();
        if (ACTION_PROFILE.equals(config.getActionName()) || ACTION_PROFILE_TESTS.equals(config.getActionName()) || config.getActionName() != null && config.getActionName().startsWith(ACTION_PROFILE_SINGLE)) {
            final ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler((Project)this.project);
            if (!(ptp instanceof MavenProjectTypeProfiler)) {
                return false;
            }
            Properties sessionProperties = ((MavenProjectTypeProfiler)ptp).getLastSessionProperties();
            for (Object k : configProperties.keySet()) {
                String key = (String)k;
                String value = configProperties.getProperty(key);
                if (value.contains(PROFILER_ARGS)) {
                    String agentArg = this.fixAgentArg(sessionProperties.getProperty("profiler.info.jvmargs.agent"));
                    value = value.replace(PROFILER_ARGS, sessionProperties.getProperty("profiler.info.jvmargs") + " " + agentArg);
                    configProperties.setProperty(key, value.trim());
                }
                if (!value.contains(PROFILER_JAVA)) continue;
                String profilerJava = sessionProperties.getProperty("profiler.info.jvm");
                value = value.replace(PROFILER_JAVA, profilerJava != null && new File(profilerJava).isFile() ? profilerJava : "java");
                configProperties.setProperty(key, value.trim());
            }
            config.setProperties(configProperties);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Profiler.getDefault().connectToStartedApp(((MavenProjectTypeProfiler)ptp).getLastProfilingSettings(), ((MavenProjectTypeProfiler)ptp).getLastSessionSettings());
                }
            });
        }
        return true;
    }

    private String fixAgentArg(String agentArg) {
        if ((agentArg = agentArg.replace("\\", "/")).indexOf(32) != -1) {
            return "\"" + agentArg + "\"";
        }
        return agentArg;
    }
}

