/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.options;

import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.symfony.SymfonyScript;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class SymfonyOptions {
    public static final String DEFAULT_SECRET = "UniqueSecret";
    private static final String PREFERENCES_PATH = "symfony";
    private static final SymfonyOptions INSTANCE = new SymfonyOptions();
    private static final String SYMFONY = "symfony";
    private static final String PARAMS_FOR_PROJECT = "default.params.project";
    private static final String PARAMS_FOR_APPS = "default.params.apps";
    private static final String DEFAULT_PARAMS_FOR_APPS = "--escaping-strategy=on --csrf-secret=UniqueSecret";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean symfonySearched = false;

    private SymfonyOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                SymfonyOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static SymfonyOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized String getSymfony() {
        String symfony = this.getPreferences().get("symfony", null);
        if (symfony == null && !this.symfonySearched) {
            this.symfonySearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"symfony", SymfonyScript.SCRIPT_NAME_LONG});
            if (!scripts.isEmpty()) {
                symfony = (String)scripts.get(0);
                this.setSymfony(symfony);
            }
        }
        return symfony;
    }

    public void setSymfony(String symfony) {
        this.getPreferences().put("symfony", symfony);
    }

    public String getDefaultParamsForProject() {
        return this.getPreferences().get(PARAMS_FOR_PROJECT, "");
    }

    public void setDefaultParamsForProject(String params) {
        this.getPreferences().put(PARAMS_FOR_PROJECT, params);
    }

    public String getDefaultParamsForApps() {
        return this.getPreferences().get(PARAMS_FOR_APPS, DEFAULT_PARAMS_FOR_APPS);
    }

    public void setDefaultParamsForApps(String params) {
        this.getPreferences().put(PARAMS_FOR_APPS, params);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(SymfonyOptions.class).node("symfony");
    }
}

