/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.netbeans.modules.maven.graph.EdgeWidget;

class HighlightVisitor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private int max = Integer.MAX_VALUE;
    Rectangle rectangle = new Rectangle(0, 0, 1, 1);

    HighlightVisitor(DependencyGraphScene scene) {
        this.scene = scene;
        this.path = new Stack();
    }

    void setMaxDepth(int max) {
        this.max = max;
    }

    Rectangle getVisibleRectangle() {
        return this.rectangle;
    }

    public boolean visit(DependencyNode node) {
        if (this.root == null) {
            this.root = node;
        }
        if (node.getState() == 0) {
            ArtifactGraphNode grNode = this.scene.getGraphNodeRepresentant(node);
            ArtifactWidget aw = (ArtifactWidget)this.scene.findWidget(grNode);
            Collection edges = this.scene.findNodeEdges(grNode, true, true);
            aw.setReadable(false);
            if (this.path.size() > this.max) {
                aw.setPaintState(1);
                for (ArtifactGraphEdge e : edges) {
                    EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
                    ew.setState(1);
                }
            } else {
                this.rectangle = this.rectangle.union(aw.convertLocalToScene(aw.getBounds()));
                aw.setPaintState(2);
                for (ArtifactGraphEdge e : edges) {
                    EdgeWidget ew = (EdgeWidget)this.scene.findWidget(e);
                    ew.setState(2);
                }
            }
            this.path.push(node);
            return true;
        }
        return false;
    }

    public boolean endVisit(DependencyNode node) {
        if (node.getState() == 0) {
            this.path.pop();
        }
        return true;
    }
}

