/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public class HibernateMappingFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery query;
    private FileObject fo;

    public HibernateMappingFindUsagesPlugin(WhereUsedQuery query) {
        this.query = query;
        this.fo = (FileObject)query.getRefactoringSource().lookup(FileObject.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            if (this.fo == null || !this.fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) {
                return null;
            }
            String origResourceName = this.getOrigResourceName();
            if (origResourceName == null) {
                return null;
            }
            Project proj = FileOwnerQuery.getOwner((FileObject)this.fo);
            HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
            if (env == null) {
                return null;
            }
            List<FileObject> configFiles = env.getAllHibernateConfigFileObjects();
            if (configFiles.isEmpty()) {
                return null;
            }
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getMappingResourceOccurrences(configFiles, origResourceName, false);
            for (FileObject mappingFile : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mappingFile);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRefactoringElement elem = new HibernateRefactoringElement(mappingFile, origResourceName, foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)elem);
                }
            }
            return null;
        }
        return null;
    }

    private String getOrigResourceName() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        SourceGroup[] grp = SourceGroups.getJavaSourceGroups((Project)project);
        if (grp.length == 0) {
            return null;
        }
        String srcRoot = grp[0].getRootFolder().getPath();
        String oldPath = this.fo.getPath();
        String oldResource = oldPath.substring(srcRoot.length() + 1);
        return oldResource;
    }
}

