/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaManager;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaTableProvider;
import org.netbeans.modules.hibernate.wizards.support.EmptyTableProvider;
import org.netbeans.modules.hibernate.wizards.support.SelectedTables;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableClosure;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;
import org.netbeans.modules.hibernate.wizards.support.TableUISupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateRevengDatabaseTablesPanel
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DBSchemaManager dbschemaManager = new DBSchemaManager();
    private DatabaseConnection dbconn;
    private String schemaName;
    private String catalogName;
    private boolean sourceSchemaUpdateEnabled;
    private Project project;
    private HibernateEnvironment env;
    List<FileObject> configFileObjects;
    List<String> databaseTables;
    private TableClosure tableClosure;
    private SchemaElement sourceSchemaElement;
    private SelectedTables selectedTables;
    private static Logger logger = Logger.getLogger(HibernateRevengDatabaseTablesPanel.class.getName());
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableTablesLabel;
    private JList availableTablesList;
    private JScrollPane availableTablesScrollPane;
    private JPanel buttonPanel;
    private JComboBox cmbDatabaseConn;
    private JLabel jLabel1;
    private JScrollPane jScrollPane3;
    private JButton removeAllButton;
    private JButton removeButton;
    private ButtonGroup schemaSource;
    private JLabel selectedTablesLabel;
    private JList selectedTablesList;
    private JScrollPane selectedTablesScrollPane;
    private JCheckBox tableClosureCheckBox;
    private JTextPane tableError;
    private JPanel tablesPanel;

    public HibernateRevengDatabaseTablesPanel(Project project) {
        this.initComponents();
        this.project = project;
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HibernateRevengDatabaseTablesPanel.this.updateButtons();
            }
        };
        this.availableTablesList.getSelectionModel().addListSelectionListener(selectionListener);
        this.selectedTablesList.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void initialize(Project project) {
        this.project = project;
        this.fillConfiguration();
        this.sourceSchemaUpdateEnabled = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HibernateRevengDatabaseTablesPanel.this.fillDatabaseTables();
            }
        });
    }

    private void fillConfiguration() {
        this.env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        String[] configFiles = this.getConfigFilesFromProject(this.project);
        this.cmbDatabaseConn.setModel(new DefaultComboBoxModel<String>(configFiles));
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> configFiles = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fo : this.configFileObjects) {
            configFiles.add(fo.getNameExt());
        }
        return configFiles.toArray(new String[0]);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    private void fillDatabaseTables() {
        if (!this.sourceSchemaUpdateEnabled) {
            return;
        }
        TableProvider tableProvider = null;
        this.sourceSchemaElement = null;
        this.dbconn = null;
        Object item = this.cmbDatabaseConn.getSelectedItem();
        HibernateConfiguration hibConf = null;
        try {
            if (this.cmbDatabaseConn.getSelectedIndex() != -1) {
                hibConf = ((HibernateCfgDataObject)DataObject.find((FileObject)this.configFileObjects.get(this.cmbDatabaseConn.getSelectedIndex()))).getHibernateConfiguration();
                if (!this.env.canDirectlyConnectToDB(hibConf)) {
                    logger.info("Not able to connect to the database, aborting table fetching..");
                    return;
                }
                this.dbconn = HibernateUtil.getDBConnection(hibConf);
                if (this.dbconn != null) {
                    this.sourceSchemaElement = this.dbschemaManager.getSchemaElement(this.dbconn);
                    this.schemaName = this.dbconn.getSchema();
                    Connection jdbcConnection = this.dbconn.getJDBCConnection();
                    if (jdbcConnection != null) {
                        this.catalogName = jdbcConnection.getCatalog();
                    }
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (DatabaseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (SQLException e) {
            HibernateRevengDatabaseTablesPanel.notify(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ERR_DatabaseError"));
        }
        tableProvider = this.sourceSchemaElement != null ? new DBSchemaTableProvider(this.sourceSchemaElement) : new EmptyTableProvider();
        this.tableClosure = new TableClosure(tableProvider);
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
        TableUISupport.connectAvailable(this.availableTablesList, this.tableClosure);
        TableUISupport.connectSelected(this.selectedTablesList, this.tableClosure);
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void updateButtons() {
        Set<Table> addTables = TableUISupport.getSelectedTables(this.availableTablesList);
        this.addButton.setEnabled(this.tableClosure.canAddAllTables(addTables));
        this.addAllButton.setEnabled(this.tableClosure.canAddSomeTables(this.tableClosure.getAvailableTables()));
        Set<Table> tables = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.removeButton.setEnabled(this.tableClosure.canRemoveAllTables(tables));
        this.removeAllButton.setEnabled(this.tableClosure.getSelectedTables().size() > 0);
        this.tableError.setText("");
        for (Table t : addTables) {
            if (!t.isDisabled()) continue;
            if (t.getDisabledReason() instanceof Table.ExistingDisabledReason) {
                String existingClass = ((Table.ExistingDisabledReason)t.getDisabledReason()).getFQClassName();
                this.tableError.setText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"MSG_Already_Mapped", (Object[])new Object[]{t.getName(), existingClass}));
                break;
            }
            if (!(t.getDisabledReason() instanceof Table.NoPrimaryKeyDisabledReason)) continue;
            this.tableError.setText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"MSG_No_Primary_Key", (Object[])new Object[]{t.getName()}));
            break;
        }
    }

    public void update(TableClosure tableClosure) {
        block5: {
            try {
                if (this.selectedTables == null) {
                    try {
                        this.selectedTables = new SelectedTables(tableClosure, null, null);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.selectedTables.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent event) {
                            HibernateRevengDatabaseTablesPanel.this.changeSupport.fireChange();
                        }
                    });
                    break block5;
                }
                this.selectedTables.setTableClosureAndTargetFolder(tableClosure, null, null);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public FileObject getConfigurationFile() {
        if (this.cmbDatabaseConn.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbDatabaseConn.getSelectedIndex());
        }
        return null;
    }

    public TableClosure getTableClosure() {
        if (this.tableClosure == null) {
            this.fillDatabaseTables();
        }
        return this.tableClosure;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public SelectedTables getSelectedTables() {
        return this.selectedTables;
    }

    private static void notify(String message) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private void initComponents() {
        this.schemaSource = new ButtonGroup();
        this.cmbDatabaseConn = new JComboBox();
        this.tablesPanel = new TablesPanel();
        this.availableTablesLabel = new JLabel();
        this.availableTablesScrollPane = new JScrollPane();
        this.availableTablesList = TableUISupport.createTableList();
        this.selectedTablesLabel = new JLabel();
        this.selectedTablesScrollPane = new JScrollPane();
        this.selectedTablesList = TableUISupport.createTableList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.tableClosureCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.tableError = new JTextPane();
        this.jLabel1 = new JLabel();
        this.setName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"LBL_DatabaseTables"));
        this.cmbDatabaseConn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.cmbDatabaseConnActionPerformed(evt);
            }
        });
        this.tablesPanel.setLayout(new GridBagLayout());
        this.availableTablesLabel.setLabelFor(this.availableTablesList);
        Mnemonics.setLocalizedText((JLabel)this.availableTablesLabel, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_AvailableTables"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.availableTablesLabel, gridBagConstraints);
        this.availableTablesLabel.getAccessibleContext().setAccessibleName("");
        this.availableTablesList.setNextFocusableComponent(this.addButton);
        this.availableTablesScrollPane.setViewportView(this.availableTablesList);
        this.availableTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSN_AvailableTables"));
        this.availableTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSD_AvailableTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.availableTablesScrollPane, gridBagConstraints);
        this.selectedTablesLabel.setLabelFor(this.selectedTablesList);
        Mnemonics.setLocalizedText((JLabel)this.selectedTablesLabel, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.tablesPanel.add((Component)this.selectedTablesLabel, gridBagConstraints);
        this.selectedTablesLabel.getAccessibleContext().setAccessibleName("");
        this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
        this.selectedTablesList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSN_SelectedTables"));
        this.selectedTablesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"ACSD_SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tablesPanel.add((Component)this.selectedTablesScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Add"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_AddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.buttonPanel.add((Component)this.addAllButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_RemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.tablesPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.tableClosureCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tableClosureCheckBox, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_IncludeRelatedTables"));
        this.tableClosureCheckBox.setToolTipText(NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"TXT_HibernateRevengDatabaseTablesPanel_IncludeRelatedTables"));
        this.tableClosureCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tableClosureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.tableClosureCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.tablesPanel.add((Component)this.tableClosureCheckBox, gridBagConstraints);
        this.tableClosureCheckBox.getAccessibleContext().setAccessibleName("");
        this.jScrollPane3.setBorder(null);
        this.tableError.setEditable(false);
        this.tableError.setOpaque(false);
        this.jScrollPane3.setViewportView(this.tableError);
        this.jLabel1.setLabelFor(this.cmbDatabaseConn);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(HibernateRevengDatabaseTablesPanel.class, (String)"HibernateRevengDatabaseTablesPanel_Configuration"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cmbDatabaseConn, 0, 427, Short.MAX_VALUE)).add(2, (Component)this.tablesPanel, -1, 519, Short.MAX_VALUE).add(2, (Component)this.jScrollPane3, -1, 519, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cmbDatabaseConn, -2, -1, -2)).addPreferredGap(0, 23, Short.MAX_VALUE).add((Component)this.tablesPanel, -2, 235, -2).addPreferredGap(0).add((Component)this.jScrollPane3, -2, 38, -2)));
    }

    private void tableClosureCheckBoxItemStateChanged(ItemEvent evt) {
        this.tableClosure.setClosureEnabled(this.tableClosureCheckBox.isSelected());
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.tableClosure.removeAllTables();
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        this.tableClosure.addAllTables();
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Set<Table> tables = TableUISupport.getSelectedTables(this.selectedTablesList);
        this.tableClosure.removeTables(tables);
        this.selectedTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Set<Table> tables = TableUISupport.getSelectedTables(this.availableTablesList);
        this.tableClosure.addTables(tables);
        this.availableTablesList.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void cmbDatabaseConnActionPerformed(ActionEvent evt) {
        this.fillDatabaseTables();
        this.changeSupport.fireChange();
    }

    private final class TablesPanel
    extends JPanel {
        private TablesPanel() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Rectangle availableBounds = HibernateRevengDatabaseTablesPanel.this.availableTablesScrollPane.getBounds();
            Rectangle selectedBounds = HibernateRevengDatabaseTablesPanel.this.selectedTablesScrollPane.getBounds();
            if (Math.abs(availableBounds.width - selectedBounds.width) > 1) {
                GridBagConstraints buttonPanelConstraints = ((GridBagLayout)this.getLayout()).getConstraints(HibernateRevengDatabaseTablesPanel.this.buttonPanel);
                int totalWidth = this.getWidth() - HibernateRevengDatabaseTablesPanel.this.buttonPanel.getWidth() - buttonPanelConstraints.insets.left - buttonPanelConstraints.insets.right;
                int equalWidth = totalWidth / 2;
                int xOffset = equalWidth - availableBounds.width;
                availableBounds.width = equalWidth;
                HibernateRevengDatabaseTablesPanel.this.availableTablesScrollPane.setBounds(availableBounds);
                Rectangle buttonBounds = HibernateRevengDatabaseTablesPanel.this.buttonPanel.getBounds();
                buttonBounds.x += xOffset;
                HibernateRevengDatabaseTablesPanel.this.buttonPanel.setBounds(buttonBounds);
                Rectangle labelBounds = HibernateRevengDatabaseTablesPanel.this.selectedTablesLabel.getBounds();
                labelBounds.x += xOffset;
                HibernateRevengDatabaseTablesPanel.this.selectedTablesLabel.setBounds(labelBounds);
                selectedBounds.x += xOffset;
                selectedBounds.width = totalWidth - equalWidth;
                HibernateRevengDatabaseTablesPanel.this.selectedTablesScrollPane.setBounds(selectedBounds);
                Rectangle tableClosureBounds = HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBox.getBounds();
                tableClosureBounds.x += xOffset;
                tableClosureBounds.width = totalWidth - equalWidth;
                HibernateRevengDatabaseTablesPanel.this.tableClosureCheckBox.setBounds(tableClosureBounds);
            }
        }
    }
}

