/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataObject;
import org.netbeans.modules.hibernate.reveng.model.HibernateReverseEngineering;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDbTablesWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class HibernateRevengWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private WizardDescriptor.Panel[] panels;
    private HibernateRevengDbTablesWizardDescriptor dbTablesDescriptor;
    private final String DEFAULT_REVENG_FILENAME = "hibernate.reveng";
    private final String CATALOG_NAME = "match-catalog";
    private final String EXCLUDE_NAME = "exclude";
    private final String ATTRIBUTE_NAME = "match-schema";
    private final String MATCH_NAME = "match-name";
    private final String resourceAttr = "resource";
    private final String classAttr = "class";
    private Logger logger = Logger.getLogger(HibernateRevengWizard.class.getName());

    public static HibernateRevengWizard create() {
        return new HibernateRevengWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                Project prj = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                SourceGroup[] groups = ProjectUtils.getSources((Project)prj).getSourceGroups("generic");
                WizardDescriptor.Panel targetChooser = Templates.createSimpleTargetChooser((Project)prj, (SourceGroup[])groups);
                this.panels = new WizardDescriptor.Panel[]{targetChooser, this.dbTablesDescriptor};
            }
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String name() {
        return NbBundle.getMessage(HibernateRevengWizard.class, (String)"Templates/Hibernate/RevEng");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizardDescriptor.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    private boolean foundRevengFileInProject(List<FileObject> revengFiles, String revengFileName) {
        for (FileObject fo : revengFiles) {
            if (!fo.getName().equals(revengFileName)) continue;
            return true;
        }
        return false;
    }

    public final void initialize(WizardDescriptor wiz) {
        this.wizardDescriptor = wiz;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        String wizardTitle = NbBundle.getMessage(HibernateRevengWizard.class, (String)"Templates/Hibernate/RevEng");
        this.dbTablesDescriptor = new HibernateRevengDbTablesWizardDescriptor(this.project, wizardTitle);
        if (Templates.getTargetFolder((WizardDescriptor)wiz) == null) {
            FileObject location;
            HibernateFileLocationProvider provider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            FileObject fileObject = location = provider != null ? provider.getSourceLocation() : null;
            if (location != null) {
                Templates.setTargetFolder((WizardDescriptor)wiz, (FileObject)location);
            }
        }
        if (wiz instanceof TemplateWizard) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                return;
            }
            List<FileObject> revengFiles = hibernateEnv.getAllHibernateReverseEnggFileObjects();
            String targetName = "hibernate.reveng";
            if (!revengFiles.isEmpty() && this.foundRevengFileInProject(revengFiles, "hibernate.reveng")) {
                int revengFilesCount = revengFiles.size();
                targetName = "hibernate" + revengFilesCount++ + ".reveng";
                while (this.foundRevengFileInProject(revengFiles, targetName)) {
                    targetName = "hibernate" + revengFilesCount++ + ".reveng";
                }
            }
            ((TemplateWizard)wiz).setTargetName(targetName);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        DataFolder targetDataFolder = DataFolder.findFolder((FileObject)targetFolder);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizardDescriptor);
        FileObject templateFileObject = Templates.getTemplate((WizardDescriptor)this.wizardDescriptor);
        DataObject templateDataObject = DataObject.find((FileObject)templateFileObject);
        DataObject newOne = templateDataObject.createFromTemplate(targetDataFolder, targetName);
        try {
            HibernateRevengDataObject hro = (HibernateRevengDataObject)newOne;
            HibernateReverseEngineering hre = hro.getHibernateReverseEngineering();
            int jx = hre.addSchemaSelection(true);
            if (this.dbTablesDescriptor.getCatalogName() != null && !"".equals(this.dbTablesDescriptor.getCatalogName())) {
                hre.setAttributeValue("SchemaSelection", jx, "match-catalog", this.dbTablesDescriptor.getCatalogName());
            } else {
                hre.setAttributeValue("SchemaSelection", jx, "match-catalog", null);
            }
            if (this.dbTablesDescriptor.getSchemaName() != null && !"".equals(this.dbTablesDescriptor.getSchemaName())) {
                hre.setAttributeValue("SchemaSelection", jx, "match-schema", this.dbTablesDescriptor.getSchemaName());
            } else {
                hre.setAttributeValue("SchemaSelection", jx, "match-schema", null);
            }
            ArrayList<Table> list = new ArrayList<Table>(this.dbTablesDescriptor.getSelectedTables());
            for (int i = 0; i < list.size(); ++i) {
                int ix = hre.addTableFilter(true);
                hre.setAttributeValue("TableFilter", ix, "match-catalog", null);
                hre.setAttributeValue("TableFilter", ix, "match-schema", null);
                hre.setAttributeValue("TableFilter", ix, "match-name", ((Table)list.get(i)).getName());
                hre.setAttributeValue("TableFilter", ix, "exclude", null);
            }
            hro.addReveng();
            hro.save();
            return Collections.singleton(hro.getPrimaryFile());
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }
}

