/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.storage.types.TimeDuration;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.util.DLightExecutorService;

public final class TimerBasedVisualizerSupport
implements ComponentListener {
    private static final Lock lock = new Lock();
    private final Visualizer visualizer;
    private final TimeDuration refreshInterval;
    private DLightExecutorService.DLightScheduledTask task;
    private boolean isShown = true;

    public TimerBasedVisualizerSupport(Visualizer visualizer, TimeDuration refreshInterval) {
        this.visualizer = visualizer;
        this.refreshInterval = refreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer() {
        Lock lock = TimerBasedVisualizerSupport.lock;
        synchronized (lock) {
            if (this.task != null) {
                return;
            }
            this.task = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimerBasedVisualizerSupport.this.visualizer.refresh();
                }
            }, (long)this.refreshInterval.getValueIn(TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS, (String)("TimerBasedVisualizerSupport: timer for " + this.visualizer.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimer() {
        Lock lock = TimerBasedVisualizerSupport.lock;
        synchronized (lock) {
            if (this.task != null) {
                this.task.cancel(this.refreshInterval.getValueIn(TimeUnit.SECONDS));
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.visualizer.getComponent().isShowing();
        if (this.isShown) {
            this.startTimer();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.stopTimer();
        this.isShown = false;
    }

    public void start() {
        this.startTimer();
    }

    public void stop() {
        this.stopTimer();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

