/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.jboss;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.jboss.JBossIntegrationPanel;
import org.openide.util.NbBundle;

public abstract class AbstractJBossIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final String PROFILED_JBOSS_CONSOLE_STRING = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ProfiledJbossConsoleString");
    private static final String MANUAL_REMOTE_STEP3_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualRemoteStep3Msg");
    private static final String PATH_TO_JVM_DIR_TEXT = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_PathToJvmDirText");
    private static final String MANUAL_REMOTE_STEP4_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualRemoteStep4Msg");
    private static final String MANUAL_REMOTE_STEP5_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualRemoteStep5Msg");
    private static final String MANUAL_REMOTE_STEP6_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualRemoteStep6Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP1_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDirectDynamicStep1Msg");
    private static final String MANUAL_DIRECT_STEP2_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDirectStep2Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP3_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDirectDynamicStep3Msg");
    private static final String MANUAL_DIRECT_STEP4_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDirectStep4Msg");
    private static final String MANUAL_DYNAMIC_STEP2_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDynamicStep2Msg");
    private static final String MANUAL_DYNAMIC_STEP4_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_ManualDynamicStep4Msg");
    private static final String INTEGR_REVIEW_STEP1_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_IntegrReviewStep1Msg");
    private static final String INTEGR_REVIEW_STEP2_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_IntegrReviewStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP1_DIRECT_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsStep1DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsStep1DynamicMsg");
    private static final String ADDITIONAL_STEPS_STEP2_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP3_DIRECT_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsStep3DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsStep3DynamicPidMsg");
    private static final String ADDITIONAL_STEPS_AUTO_START_MSG = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_AdditionalStepsAutoStartMsg");
    private static final String DYNAMIC_WARNING_MESSAGE = NbBundle.getMessage(AbstractJBossIntegrationProvider.class, (String)"JBossIntegrationProvider_DynamicWarningMessage");
    private static final String JBOSS_RUN_SCRIPT = "run";
    private static final String JBOSS_HOME_VAR_STRING = "JBOSS_HOME";
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "@if not \"%ECHO%\" == \"\"";
    private static final String INSERTION_POINT_NONWIN_1_STRING = "DIRNAME=`dirname $0`";
    private static final String RUN_MOD_EXT_STRING = "_nbprofiler";
    private SettingsPersistor persistor;

    public AbstractJBossIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep("JBoss provider settings", (WizardScreen)new JBossIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "JBossIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties settings) {
                AbstractJBossIntegrationProvider.this.setTargetJava(settings.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", ""));
                AbstractJBossIntegrationProvider.this.setInstallationPath(settings.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                if (AbstractJBossIntegrationProvider.this.getInstallationPath() == null || AbstractJBossIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractJBossIntegrationProvider.this.setInstallationPath(AbstractJBossIntegrationProvider.this.getDefaultInstallationPath());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties settings = new Properties();
                settings.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractJBossIntegrationProvider.this.getTargetJava());
                settings.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractJBossIntegrationProvider.this.getInstallationPath());
                return settings;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean automation) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            instructions.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DIRECT_MSG, this.getModifiedScriptPath(targetOS, false)));
        } else {
            instructions.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG, this.getModifiedScriptPath(targetOS, false), ""));
        }
        instructions.addStep(ADDITIONAL_STEPS_STEP2_MSG);
        if (attachSettings.isDirect()) {
            instructions.addStep(ADDITIONAL_STEPS_STEP3_DIRECT_MSG);
        } else {
            instructions.addStep(ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG);
            instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        }
        instructions.addHint(ADDITIONAL_STEPS_AUTO_START_MSG);
        return instructions;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP1_MSG, new File(this.getScriptPath(targetOS, true)), this.getModifiedScriptPath(targetOS, true)));
        instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + (attachSettings.isDirect() ? "" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())) + "<br>" : "")));
        return instructions;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isRemote()) {
            return this.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings);
        }
        return this.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings);
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public void setTargetJvm(TargetPlatform javaPlatform) {
        if (javaPlatform == null) {
            return;
        }
        this.setTargetJavaHome(javaPlatform.getHomePath());
        this.setTargetJava(javaPlatform.toString());
    }

    public boolean supportsRemote() {
        return true;
    }

    public ValidationResult validateInstallation(String targetOS, String path) {
        if (!new File(path).exists()) {
            return new ValidationResult(false, "The installation path doesn't exist");
        }
        if (!new File(this.getJbossScriptPath(path, targetOS, "", false)).exists()) {
            return new ValidationResult(false, "Invalid installation directory");
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected ScriptHeaderModifier getHeaderModifier(String targetOS) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)targetOS));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP2_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()))));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MANUAL_DIRECT_STEP4_MSG);
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP2_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MANUAL_DYNAMIC_STEP4_MSG);
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(this.getManualRemoteStep1(targetOS));
        instructions.addStep(this.getManualRemoteStep2(targetOS));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_JBOSS_HOME", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())), IntegrationUtils.getRemoteAbsolutePathHint()));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP5_MSG, IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(MANUAL_REMOTE_STEP6_MSG);
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }

    protected String getModifiedScriptPath(String targetOS, boolean quoted) {
        return this.getJbossScriptPath(targetOS, RUN_MOD_EXT_STRING, quoted);
    }

    protected String getScriptPath(String targetOS, boolean quoted) {
        return this.getJbossScriptPath(targetOS, "", quoted);
    }

    protected String getWinConsoleString() {
        return PROFILED_JBOSS_CONSOLE_STRING;
    }

    protected void generateCommands(String targetOS, Collection commandsArray) {
        commandsArray.add(this.getModifiedScriptPath(targetOS, false));
    }

    protected void modifyScriptFileForDirectAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String debugJavaOpts = "";
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            debugJavaOpts = debugJavaOpts + " -Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true";
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            debugJavaOpts = debugJavaOpts + " -Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true";
        }
        String header = (isReplaceFile ? IntegrationUtils.getProfilerModifiedReplaceFileHeader((String)targetOS) : IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS)) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportNativeLibraries = IntegrationUtils.getAddProfilerLibrariesToPathString((String)targetOS, (String)this.getTargetJava(), (boolean)false, (boolean)false) + lineBreak;
        String javaOpts = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)(IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)commPort) + debugJavaOpts)) + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), javaOpts);
        currentOffset += javaOpts.length();
    }

    protected void modifyScriptFileForDynamicAttach(String targetOS, int port, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String header = IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        currentOffset += exportJavaHome.length();
    }

    private String getDefaultInstallationPath() {
        String home = "";
        try {
            File homeDir;
            String homeEnv = System.getenv(JBOSS_HOME_VAR_STRING);
            if (homeEnv != null && homeEnv.length() > 1 && (homeDir = new File(homeEnv)).exists() && homeDir.isDirectory()) {
                home = homeEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return home;
    }

    private String getJbossScriptPath(String targetOS, String scriptPostfix, boolean useQuotas) {
        return this.getJbossScriptPath(this.getInstallationPath(), targetOS, scriptPostfix, useQuotas);
    }

    private String getJbossScriptPath(String dirPath, String targetOS, String scriptPostfix, boolean useQuotas) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        String quotas = "";
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            quotas = "\"";
        }
        StringBuffer path = new StringBuffer();
        path.append(dirPath);
        if (!dirPath.endsWith(separator)) {
            path.append(separator);
        }
        path.append("bin").append(separator).append(JBOSS_RUN_SCRIPT).append(scriptPostfix).append(ext);
        if (useQuotas) {
            path.insert(0, quotas);
            path.append(quotas);
        }
        return path.toString();
    }
}

