/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.jboss;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.jboss.AbstractJBossIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.jboss.JBossIntegrationPanelUI;
import org.openide.util.HelpCtx;

public class JBossIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "JBossIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("JBossIntegrationPanel.HelpCtx");
    private JBossIntegrationPanelUI panel = null;
    private Model model = new Model();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        String targetOS = this.getContext().getAttachSettings().getHostOS();
        ValidationResult result = ((AbstractJBossIntegrationProvider)this.getContext().getIntegrationProvider()).validateInstallation(targetOS, this.model.getJbossInstall());
        if (!result.isValid()) {
            this.model.setJbossInstallHint(result.getMessage());
        } else {
            this.model.setJbossInstallHint("");
        }
        return result.isValid() && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    public boolean canFinish(AttachWizardContext context) {
        return false;
    }

    public boolean canNext(AttachWizardContext context) {
        return true;
    }

    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    public void onEnter(AttachWizardContext context) {
        this.model.setJbossInstall(((AbstractJBossIntegrationProvider)context.getIntegrationProvider()).getInstallationPath());
        String selectedJavaHome = ((AbstractJBossIntegrationProvider)context.getIntegrationProvider()).getTargetJava();
        List platformList = TargetPlatform.getPlatformList((boolean)false);
        for (TargetPlatform platform : platformList) {
            if (!platform.equals((Object)selectedJavaHome)) continue;
            this.model.setSelectedPlatform(platform);
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext context) {
        AbstractJBossIntegrationProvider provider = (AbstractJBossIntegrationProvider)this.getContext().getIntegrationProvider();
        boolean isModified = false;
        if (!provider.getInstallationPath().equals(this.model.getJbossInstall())) {
            isModified = true;
        } else if (provider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !provider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            isModified = true;
        }
        if (isModified) {
            context.setConfigChanged();
        }
        provider.setInstallationPath(this.model.getJbossInstall());
        provider.setTargetPlatform(this.model.getSelectedPlatform());
    }

    public void onFinish(AttachWizardContext context) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new JBossIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private String jbossInstall = "";
        private String jbossInstallHint = "";
        private TargetPlatform javaPlatform;
        private TargetPlatform.TargetPlatformFilter platformFilter = new TargetPlatform.TargetPlatformFilter(){

            public boolean isSupported(TargetPlatform javaPlatform) {
                AttachSettings settings = JBossIntegrationPanel.this.getContext().getAttachSettings();
                TargetPlatformEnum jvm = javaPlatform.getAsEnum();
                if (!settings.isDirect()) {
                    if (settings.isDynamic16()) {
                        if (!jvm.equals((Object)TargetPlatformEnum.JDK6) && !jvm.equals((Object)TargetPlatformEnum.JDK7)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return JBossIntegrationPanel.this.getContext().getIntegrationProvider().supportsJVM(javaPlatform.getAsEnum(), settings);
            }
        };

        Model() {
        }

        public void setJbossInstall(String path) {
            this.jbossInstall = path;
            JBossIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getJbossInstall() {
            return this.jbossInstall;
        }

        public void setJbossInstallHint(String jbossInstallHint) {
            this.jbossInstallHint = jbossInstallHint;
        }

        public String getJbossInstallHint() {
            return this.jbossInstallHint;
        }

        public TargetPlatform.TargetPlatformFilter getPlatformFilter() {
            return this.platformFilter;
        }

        public void setSelectedPlatform(TargetPlatform platform) {
            this.javaPlatform = platform;
            JBossIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public TargetPlatform getSelectedPlatform() {
            return this.javaPlatform;
        }
    }
}

