/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class URLWait {
    private static final Logger LOGGER = Logger.getLogger(URLWait.class.getName());

    private URLWait() {
    }

    public static boolean waitForUrlReady(ExecutorService service, URL url, int timeout) {
        String host = url.getHost();
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return URLWait.waitForUrlConnection(service, url, timeout, 100);
    }

    private static boolean waitForUrlConnection(ExecutorService service, URL url, int timeout, int retryTime) {
        Connect connect = new Connect(url, retryTime);
        Future<Boolean> task = service.submit(connect);
        try {
            return task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            task.cancel(true);
        }
        return false;
    }

    private static class Connect
    implements Callable<Boolean> {
        private final URL url;
        private final int retryTime;
        private final String host;

        public Connect(URL url, int retryTime) {
            this.url = url;
            this.retryTime = retryTime;
            this.host = url.getHost();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                return Boolean.FALSE;
            }
            boolean interrupted = false;
            HttpURLConnection con = null;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    boolean error;
                    con = (HttpURLConnection)this.url.openConnection();
                    int code = con.getResponseCode();
                    boolean bl = error = code == -1 || code > 399 && code < 600;
                    if (!error) {
                        Boolean bl2 = Boolean.TRUE;
                        return bl2;
                    }
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, null, ioe);
                }
                finally {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    break;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return Boolean.FALSE;
        }
    }
}

