/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;

public final class WLConnectionSupport {
    private final WLDeploymentManager deploymentManager;

    public WLConnectionSupport(WLDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeAction(Callable<T> action) throws Exception {
        WLDeploymentManager wLDeploymentManager = this.deploymentManager;
        synchronized (wLDeploymentManager) {
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(WLDeploymentFactory.getInstance().getClassLoader(this.deploymentManager));
            T t = action.call();
            return t;
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
    }

    public <T> T executeAction(final JMXAction<T> action) throws Exception {
        InstanceProperties instanceProperties = this.deploymentManager.getInstanceProperties();
        String host = instanceProperties.getProperty("host");
        String port = instanceProperties.getProperty("port");
        if (host == null || host.trim().length() == 0 && (port == null || port.trim().length() == 0)) {
            Properties domainProperties = WLPluginProperties.getDomainProperties(instanceProperties.getProperty("domainRoot"));
            host = domainProperties.getProperty("host");
            port = domainProperties.getProperty("port");
        }
        final String resolvedHost = host;
        final String resolvedPort = port;
        return this.executeAction(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                JMXServiceURL url = new JMXServiceURL("iiop", resolvedHost.trim(), Integer.parseInt(resolvedPort.trim()), action.getPath());
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
                env.put("java.naming.security.principal", WLConnectionSupport.this.deploymentManager.getInstanceProperties().getProperty("username").toString());
                env.put("java.naming.security.credentials", WLConnectionSupport.this.deploymentManager.getInstanceProperties().getProperty("password").toString());
                JMXConnector jmxConnector = JMXConnectorFactory.newJMXConnector(url, env);
                jmxConnector.connect();
                try {
                    Object t = action.call(jmxConnector.getMBeanServerConnection());
                    return t;
                }
                finally {
                    jmxConnector.close();
                }
            }
        });
    }

    public static abstract class JMXEditAction<T>
    implements JMXAction<T> {
        public abstract T call(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public final T call(MBeanServerConnection connection) throws Exception {
            ObjectName service = new ObjectName("com.bea:Name=EditService,Type=weblogic.management.mbeanservers.edit.EditServiceMBean");
            return this.call(connection, service);
        }

        @Override
        public final String getPath() {
            return "/jndi/weblogic.management.mbeanservers.edit";
        }
    }

    public static abstract class JMXRuntimeAction<T>
    implements JMXAction<T> {
        public abstract T call(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public final T call(MBeanServerConnection connection) throws Exception {
            ObjectName service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            return this.call(connection, service);
        }

        @Override
        public final String getPath() {
            return "/jndi/weblogic.management.mbeanservers.domainruntime";
        }
    }

    public static interface JMXAction<T> {
        public T call(MBeanServerConnection var1) throws Exception;

        public String getPath();
    }
}

