/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLJpa2SwitchSupport;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.CustomizerGeneral;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.PropertyDocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CustomizerJVM
extends JPanel {
    private static final long serialVersionUID = 3411155308004602121L;
    private final WLJpa2SwitchSupport support;
    private static final DefaultVendor DEFAULT_VENDOR = new DefaultVendor();
    private JTextField javaHome;
    private JLabel javaHomeLabel;
    private JButton jpa2Button;
    private JLabel jpaOptionsLabel;
    private JTextField memoryOptions;
    private JLabel memoryOptionsCommentLabel;
    private JLabel memoryOptionsLabel;
    private JLabel noteChangesLabel;
    private JLabel vendorLabel;
    private JComboBox vendorName;
    private JTextField vmOptions;
    private JLabel vmOptionsLabel;
    private JLabel vmOptionsSampleLabel;
    private WLDeploymentManager manager;

    CustomizerJVM(WLDeploymentManager manager) {
        this.manager = manager;
        this.support = new WLJpa2SwitchSupport(manager);
        this.initComponents();
        this.initValues();
    }

    private void initValues() {
        String memOpts;
        Object vendor = this.manager.getInstanceProperties().getProperty("vendor");
        LinkedList<Object> vendors = new LinkedList<Object>();
        Properties runtimeProps = WLPluginProperties.getRuntimeProperties(this.manager.getInstanceProperties().getProperty("domainRoot"));
        final String beaHome = runtimeProps.getProperty("bea_java_home");
        final String sunHome = runtimeProps.getProperty("sun_java_home");
        final Properties javaHomeProps = (Properties)runtimeProps.get("java_home");
        if (beaHome != null && beaHome.trim().length() > 0) {
            vendors.add(WLPluginProperties.Vendor.ORACLE.toString());
        }
        if (sunHome != null && sunHome.trim().length() > 0) {
            vendors.add(WLPluginProperties.Vendor.SUN.toString());
        }
        if (vendor == null || vendor.toString().trim().length() == 0) {
            vendor = DEFAULT_VENDOR;
        }
        vendors.add(DEFAULT_VENDOR);
        Enumeration<Object> keys = javaHomeProps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.length() <= 0 || key.equals(WLPluginProperties.Vendor.SUN.toString()) || key.equals(WLPluginProperties.Vendor.ORACLE.toString())) continue;
            vendors.add(key);
        }
        this.vendorName.setModel(new DefaultComboBoxModel<Object>(vendors.toArray()));
        this.vendorName.setSelectedItem(vendor);
        if (vendor == DEFAULT_VENDOR) {
            this.javaHome.setText(javaHomeProps.getProperty(""));
        } else if (vendor.equals(WLPluginProperties.Vendor.ORACLE.toString())) {
            this.javaHome.setText(beaHome);
        } else if (vendor.equals(WLPluginProperties.Vendor.SUN.toString())) {
            this.javaHome.setText(sunHome);
        } else {
            this.javaHome.setText(javaHomeProps.getProperty(vendor.toString()));
        }
        this.vendorName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object item = event.getItem();
                if (item == DEFAULT_VENDOR) {
                    CustomizerJVM.this.javaHome.setText(javaHomeProps.getProperty(""));
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("vendor", "");
                } else {
                    String vendor = event.getItem().toString();
                    if (vendor.equals(WLPluginProperties.Vendor.ORACLE.toString())) {
                        CustomizerJVM.this.javaHome.setText(beaHome);
                    } else if (vendor.equals(WLPluginProperties.Vendor.SUN.toString())) {
                        CustomizerJVM.this.javaHome.setText(sunHome);
                    } else {
                        CustomizerJVM.this.javaHome.setText(javaHomeProps.getProperty(vendor));
                    }
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("vendor", vendor);
                }
            }
        });
        String javaOpts = this.manager.getInstanceProperties().getProperty("java_opts");
        if (javaOpts != null) {
            this.vmOptions.setText(javaOpts.trim());
        }
        if ((memOpts = this.manager.getInstanceProperties().getProperty("mem_opts")) != null) {
            this.memoryOptions.setText(memOpts.trim());
        }
        this.vmOptions.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "java_opts", this.vmOptions));
        this.memoryOptions.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "mem_opts", this.memoryOptions));
        this.updateJPA20Button();
    }

    private void updateJPA20Button() {
        if (this.support.isEnabledViaSmartUpdate()) {
            this.jpa2Button.setEnabled(false);
        } else {
            this.jpa2Button.setEnabled(true);
        }
        if (this.support.isEnabled()) {
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2Button, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_DisableJPA2"));
        } else {
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2Button, (String)NbBundle.getMessage(CustomizerGeneral.class, (String)"LBL_EnableJPA2"));
        }
    }

    private void initComponents() {
        this.javaHomeLabel = new JLabel();
        this.javaHome = new JTextField();
        this.vmOptionsLabel = new JLabel();
        this.noteChangesLabel = new JLabel();
        this.vmOptions = new JTextField();
        this.vmOptionsSampleLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.vendorName = new JComboBox();
        this.memoryOptions = new JTextField();
        this.memoryOptionsLabel = new JLabel();
        this.memoryOptionsCommentLabel = new JLabel();
        this.jpa2Button = new JButton();
        this.jpaOptionsLabel = new JLabel();
        this.javaHomeLabel.setLabelFor(this.javaHome);
        Mnemonics.setLocalizedText((JLabel)this.javaHomeLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_JavaHome"));
        this.javaHome.setEditable(false);
        this.vmOptionsLabel.setLabelFor(this.vmOptions);
        Mnemonics.setLocalizedText((JLabel)this.vmOptionsLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmOptions"));
        Mnemonics.setLocalizedText((JLabel)this.noteChangesLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.noteChangesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.vmOptionsSampleLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmOptionsSample"));
        this.vendorLabel.setLabelFor(this.vendorName);
        Mnemonics.setLocalizedText((JLabel)this.vendorLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_JvmVendor"));
        this.memoryOptionsLabel.setLabelFor(this.memoryOptions);
        Mnemonics.setLocalizedText((JLabel)this.memoryOptionsLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmMemoryOptions"));
        Mnemonics.setLocalizedText((JLabel)this.memoryOptionsCommentLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmMemoryOptionsComment"));
        Mnemonics.setLocalizedText((AbstractButton)this.jpa2Button, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.jpa2Button.text"));
        this.jpa2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerJVM.this.jpa2ButtonActionPerformed(evt);
            }
        });
        this.jpaOptionsLabel.setLabelFor(this.jpa2Button);
        Mnemonics.setLocalizedText((JLabel)this.jpaOptionsLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_JPAOptions"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteChangesLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vendorLabel).addComponent(this.vmOptionsLabel).addComponent(this.javaHomeLabel).addComponent(this.memoryOptionsLabel).addComponent(this.jpaOptionsLabel)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vendorName, -2, 111, -2).addComponent(this.javaHome, -1, 634, Short.MAX_VALUE).addComponent(this.vmOptions, -1, 634, Short.MAX_VALUE).addComponent(this.memoryOptions, -1, 634, Short.MAX_VALUE).addComponent(this.vmOptionsSampleLabel).addComponent(this.memoryOptionsCommentLabel).addComponent(this.jpa2Button)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vendorLabel).addComponent(this.vendorName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaHomeLabel).addComponent(this.javaHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vmOptionsLabel).addComponent(this.vmOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vmOptionsSampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.memoryOptions, -2, -1, -2).addComponent(this.memoryOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memoryOptionsCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jpa2Button).addComponent(this.jpaOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 98, Short.MAX_VALUE).addComponent(this.noteChangesLabel).addContainerGap()));
        this.javaHomeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_JavaHome"));
        this.javaHome.getAccessibleContext().setAccessibleName(this.javaHomeLabel.getAccessibleContext().getAccessibleName());
        this.javaHome.getAccessibleContext().setAccessibleDescription(this.javaHomeLabel.getAccessibleContext().getAccessibleDescription());
        this.vmOptionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptions"));
        this.vmOptionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptions"));
        this.noteChangesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_Note"));
        this.noteChangesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_Note"));
        this.vmOptions.getAccessibleContext().setAccessibleName(this.vmOptionsLabel.getAccessibleContext().getAccessibleName());
        this.vmOptions.getAccessibleContext().setAccessibleDescription(this.vmOptionsLabel.getAccessibleContext().getAccessibleDescription());
        this.vmOptionsSampleLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptionsSample"));
        this.vmOptionsSampleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_VmOptionsSample"));
        this.vendorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_Vendor"));
        this.vendorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_Vendor"));
        this.vendorName.getAccessibleContext().setAccessibleName(this.vendorLabel.getAccessibleContext().getAccessibleName());
        this.vendorName.getAccessibleContext().setAccessibleDescription(this.vendorLabel.getAccessibleContext().getAccessibleDescription());
        this.memoryOptions.getAccessibleContext().setAccessibleName(this.memoryOptionsLabel.getAccessibleContext().getAccessibleName());
        this.memoryOptions.getAccessibleContext().setAccessibleDescription(this.memoryOptionsLabel.getAccessibleContext().getAccessibleDescription());
        this.memoryOptionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmMemoryOptions"));
        this.memoryOptionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_VmMemoryOptions"));
    }

    private void jpa2ButtonActionPerformed(ActionEvent evt) {
        if (this.support.isEnabled()) {
            this.support.disable();
        } else {
            this.support.enable();
        }
        this.updateJPA20Button();
    }

    private static final class DefaultVendor {
        private DefaultVendor() {
        }

        public String toString() {
            return NbBundle.getMessage(CustomizerJVM.class, (String)"TXT_VendorDefaultItem");
        }
    }
}

