/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.ResourceNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class LibrariesChildrenFactory
extends ChildFactory<ResourceNode>
implements RefreshModulesCookie {
    private static final Logger LOGGER = Logger.getLogger(LibrariesChildrenFactory.class.getName());
    private Lookup lookup;

    LibrariesChildrenFactory(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    protected boolean createKeys(List<ResourceNode> nodes) {
        WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        WLConnectionSupport support = new WLConnectionSupport(manager);
        try {
            Map<String, String> libraries = support.executeAction(new WLConnectionSupport.JMXRuntimeAction<Map<String, String>>(){

                @Override
                public Map<String, String> call(MBeanServerConnection con, ObjectName service) throws Exception {
                    HashMap<String, String> map = new HashMap<String, String>();
                    ObjectName domainConfig = (ObjectName)con.getAttribute(service, "DomainConfiguration");
                    this.fillLibraries(con, domainConfig, "Libraries", map);
                    this.fillLibraries(con, domainConfig, "InternalLibraries", map);
                    this.fillLibraries(con, domainConfig, "InternalAppDeployments", map);
                    this.fillLibraries(con, domainConfig, "AppDeployments", map);
                    return map;
                }

                private void fillLibraries(MBeanServerConnection connection, ObjectName domainConfig, String attrName, Map<String, String> libraries) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                    ObjectName[] beans;
                    for (ObjectName bean : beans = (ObjectName[])connection.getAttribute(domainConfig, attrName)) {
                        String type = connection.getAttribute(bean, "Type").toString();
                        if (!"Library".equals(type)) continue;
                        String name = connection.getAttribute(bean, "Name").toString();
                        Object path = connection.getAttribute(bean, "AbsoluteInstallDir");
                        if (path == null) {
                            path = connection.getAttribute(bean, "AbsoluteSourcePath");
                        }
                        if (path == null) {
                            path = name;
                        }
                        libraries.put(path.toString(), name);
                    }
                }
            });
            for (Map.Entry<String, String> entry : libraries.entrySet()) {
                String path = entry.getKey();
                String name = entry.getValue();
                nodes.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.LIBRARY, name, path));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return true;
    }

    protected Node createNodeForKey(ResourceNode key) {
        return key;
    }
}

