/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerPropertiesVisual
extends JPanel {
    private transient WLInstantiatingIterator instantiatingIterator;
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final List<Instance> instances = new ArrayList<Instance>();
    private JButton browseButton;
    private JLabel explanationLabel;
    private JComboBox localInstancesCombo;
    private JLabel localInstancesLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField usernameField;
    private JLabel usernameLabel;

    public ServerPropertiesVisual(WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.setName(NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_PROPERTIES_STEP"));
        this.initComponents();
        this.localInstancesCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.localInstancesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerPropertiesVisual.this.fireChangeEvent();
            }
        });
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        wizardDescriptor.putProperty("WizardPanel_warningMessage", null);
        Object item = this.localInstancesCombo.getEditor().getItem();
        Instance instance = null;
        instance = item instanceof Instance ? (Instance)item : this.getServerInstance(item.toString().trim());
        if (instance == null) {
            String value = item.toString().trim();
            for (Instance inst : this.instances) {
                if (!value.equals(inst.getDomainName())) continue;
                instance = inst;
                break;
            }
        }
        if (instance == null || !this.isValidDomainRoot(instance.getDomainPath())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_INVALID_DOMAIN_ROOT")));
            return false;
        }
        if (instance != null && InstanceProperties.getInstanceProperties((String)this.getUrl(instance)) != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_ALREADY_REGISTERED")));
            return false;
        }
        if (instance != null && instance.getDomainVersion() != null && this.instantiatingIterator.getServerVersion() != null && !this.instantiatingIterator.getServerVersion().equals((Object)instance.getDomainVersion())) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_INVALID_DOMAIN_VERSION")));
            return false;
        }
        if (instance != null && instance.isProductionModeEnabled()) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"WARN_PRODUCTION_MODE")));
        }
        if (instance != null && instance.getName().startsWith("examples") && this.passwordField.getPassword().length <= 0) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ERR_EMPTY_PASSWORD")));
        }
        if (instance != null) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExisting", (Object)instance.getDomainName())));
            this.instantiatingIterator.setUrl(this.getUrl(instance));
            this.instantiatingIterator.setDomainRoot(instance.getDomainPath());
            this.instantiatingIterator.setUsername(this.usernameField.getText());
            this.instantiatingIterator.setPassword(new String(this.passwordField.getPassword()));
            this.instantiatingIterator.setPort(instance.getPort());
            this.instantiatingIterator.setDomainName(instance.getDomainName());
            this.instantiatingIterator.setHost(instance.getPort());
        }
        return true;
    }

    private String getUrl(Instance instance) {
        return "deployer:WebLogic:http://" + instance.getHost() + ":" + instance.getPort() + ":" + this.instantiatingIterator.getServerRoot() + ":" + instance.getDomainPath();
    }

    private boolean isValidDomainRoot(String path) {
        String[] children = new String[]{"servers", "config", "config/config.xml"};
        return this.hasChildren(path, children);
    }

    private boolean hasChildren(String parent, String[] children) {
        if (parent == null) {
            return false;
        }
        if (children == null) {
            return true;
        }
        for (int i = 0; i < children.length; ++i) {
            if (new File(parent + File.separator + children[i]).exists()) continue;
            return false;
        }
        return true;
    }

    private List<Instance> getServerInstances() {
        ArrayList<Instance> result = new ArrayList<Instance>();
        String[] domains = WLPluginProperties.getRegisteredDomainPaths(this.instantiatingIterator.getServerRoot());
        for (int i = 0; i < domains.length; ++i) {
            Instance localInstance = this.getServerInstance(domains[i]);
            if (localInstance == null) continue;
            result.add(localInstance);
        }
        return result;
    }

    private Instance getServerInstance(String domainPath) {
        Properties properties = WLPluginProperties.getDomainProperties(domainPath);
        if (properties.isEmpty()) {
            return null;
        }
        String name = properties.getProperty("adminName");
        String port = properties.getProperty("port");
        String host = properties.getProperty("host");
        String domainName = properties.getProperty("domainName");
        String versionString = properties.getProperty("domainVersion");
        Version domainVersion = versionString != null ? Version.fromJsr277NotationWithFallback((String)versionString) : null;
        Boolean isProductionMode = (Boolean)properties.get("productionMode");
        if (name != null && !name.equals("")) {
            port = port == null || port.equals("") ? Integer.toString(7001) : port;
            host = host == null || host.equals("") ? "localhost" : host;
            return new Instance(name, host, port, domainPath, domainName, domainVersion, isProductionMode != null && isProductionMode != false);
        }
        return null;
    }

    public void updateInstancesList() {
        this.instances.clear();
        this.instances.addAll(this.getServerInstances());
        this.localInstancesCombo.setModel(new DefaultComboBoxModel<Object>(this.instances.toArray()));
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.localInstancesLabel = new JLabel();
        this.localInstancesCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getServerInstances().toArray()));
        this.usernameLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.browseButton = new JButton();
        this.explanationLabel = new JLabel();
        this.localInstancesLabel.setHorizontalAlignment(11);
        this.localInstancesLabel.setLabelFor(this.localInstancesCombo);
        Mnemonics.setLocalizedText((JLabel)this.localInstancesLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_LOCAL_INSTANCE"));
        this.localInstancesCombo.setEditable(true);
        this.localInstancesCombo.addItemListener(new LocalInstancesItemListener());
        this.usernameLabel.setHorizontalAlignment(11);
        this.usernameLabel.setLabelFor(this.usernameField);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_USERNAME"));
        this.usernameField.setColumns(15);
        this.usernameField.setText("weblogic");
        this.passwordLabel.setHorizontalAlignment(11);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"LBL_PASSWORD"));
        this.passwordField.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ServerPropertiesVisual.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerPropertiesVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.explanationLabel.setText(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ServerPropertiesVisual.explanationLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.localInstancesLabel).addPreferredGap(0).add((Component)this.localInstancesCombo, 0, 293, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.passwordLabel).add((Component)this.usernameLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.passwordField, 0, 0, Short.MAX_VALUE).add((Component)this.usernameField, -1, 147, Short.MAX_VALUE)).add(208, 208, 208)).add((Component)this.explanationLabel, -1, 471, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.localInstancesLabel).add((Component)this.localInstancesCombo, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((Component)this.explanationLabel, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.usernameLabel).add((Component)this.usernameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordField, -2, -1, -2))));
        this.localInstancesCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_localInstancesCombo"));
        this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_usernameField"));
        this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_passwordField"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        Object item = this.localInstancesCombo.getEditor().getItem();
        if (item != null && item.toString().trim().length() > 0) {
            chooser.setSelectedFile(new File(item.toString()));
        } else {
            chooser.setSelectedFile(new File(this.instantiatingIterator.getServerRoot()));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.localInstancesCombo.getEditor().setItem(chooser.getSelectedFile().getAbsolutePath());
            this.fireChangeEvent();
        }
    }

    private static class Instance {
        private String name;
        private String host;
        private String port;
        private String domainPath;
        private String domainName;
        private boolean isProductionModeEnabled;
        private Version domainVersion;

        public Instance(String name, String host, String port, String domainPath, String domainName, Version domainVersion, boolean isProductionModeEnabled) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.domainPath = domainPath;
            this.domainName = domainName;
            this.domainVersion = domainVersion;
            this.isProductionModeEnabled = isProductionModeEnabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public void setDomainName(String name) {
            this.domainName = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getDomainPath() {
            return this.domainPath;
        }

        public void setDomainPath(String domainPath) {
            this.domainPath = domainPath;
        }

        public boolean isProductionModeEnabled() {
            return this.isProductionModeEnabled;
        }

        public void setProductionModeEnabled(boolean productionMode) {
            this.isProductionModeEnabled = productionMode;
        }

        public Version getDomainVersion() {
            return this.domainVersion;
        }

        public void setDomainVersion(Version domainVersion) {
            this.domainVersion = domainVersion;
        }

        public String toString() {
            return this.domainPath;
        }
    }

    private class LocalInstancesItemListener
    implements ItemListener {
        private LocalInstancesItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ServerPropertiesVisual.this.fireChangeEvent();
        }
    }

    private class UpdateListener
    implements DocumentListener {
        private UpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }
    }
}

