/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class AttachingDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-AttachingDICookie";
    private AttachingConnector attachingConnector;
    private Map<String, ? extends Connector.Argument> args;

    private AttachingDICookie(AttachingConnector attachingConnector, Map<String, ? extends Connector.Argument> args) {
        this.attachingConnector = attachingConnector;
        this.args = args;
    }

    public static AttachingDICookie create(AttachingConnector attachingConnector, Map<String, ? extends Connector.Argument> args) {
        return new AttachingDICookie(attachingConnector, args);
    }

    public static AttachingDICookie create(String hostName, int portNumber) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("socket"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("socket"), hostName, portNumber));
    }

    public static AttachingDICookie create(String name) {
        return new AttachingDICookie(AttachingDICookie.findAttachingConnector("shmem"), AttachingDICookie.getArgs(AttachingDICookie.findAttachingConnector("shmem"), name));
    }

    public AttachingConnector getAttachingConnector() {
        return this.attachingConnector;
    }

    public Map<String, ? extends Connector.Argument> getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument a = this.args.get("port");
        if (a == null) {
            return -1;
        }
        String pn = a.value();
        if (pn == null) {
            return -1;
        }
        return Integer.parseInt(pn);
    }

    public String getHostName() {
        Connector.Argument a = this.args.get("hostname");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    public String getSharedMemoryName() {
        Connector.Argument a = this.args.get("name");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    public String getProcessID() {
        Connector.Argument a = this.args.get("pid");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    @Override
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        return this.attachingConnector.attach(this.args);
    }

    private static Map<String, ? extends Connector.Argument> getArgs(AttachingConnector attachingConnector, String hostName, int portNumber) {
        Map<String, Connector.Argument> args = attachingConnector.defaultArguments();
        args.get("hostname").setValue(hostName);
        args.get("port").setValue("" + portNumber);
        return args;
    }

    private static Map<String, ? extends Connector.Argument> getArgs(AttachingConnector attachingConnector, String name) {
        Map<String, Connector.Argument> args = attachingConnector.defaultArguments();
        args.get("name").setValue(name);
        return args;
    }

    private static AttachingConnector findAttachingConnector(String s) {
        for (AttachingConnector ac : Bootstrap.virtualMachineManager().attachingConnectors()) {
            if (ac.transport() == null || ac.transport().name().toLowerCase().indexOf(s) <= -1) continue;
            return ac;
        }
        return null;
    }
}

