/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.mapping.BeanTypeSerializer;
import org.netbeans.modules.mobility.e2e.mapping.Utils;
import org.netbeans.modules.mobility.end2end.output.OutputLogger;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.JavonTemplate;
import org.netbeans.modules.mobility.javon.OutputFileFormatter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ClientBeanGeneratorTemplate
extends JavonTemplate {
    private static final String BEANS_OUTPUT = "client-template";

    public ClientBeanGeneratorTemplate(JavonMapping mapping) {
        super(mapping);
    }

    @Override
    public Set<String> getTargets() {
        HashSet<String> targets = new HashSet<String>(1);
        targets.add(BEANS_OUTPUT);
        return targets;
    }

    @Override
    public boolean generateTarget(ProgressHandle ph, String target) {
        boolean result = true;
        if (BEANS_OUTPUT.equals(target)) {
            this.mapping.setProperty("target", "client");
            String beanGeneration = NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_Bean_Generation");
            ph.progress(beanGeneration);
            OutputLogger.getInstance().log(beanGeneration);
            Set<JavonMapping.Service> services = this.mapping.getServiceMappings();
            HashMap<String, ClassData> types = new HashMap<String, ClassData>();
            for (JavonMapping.Service service : services) {
                for (ClassData type : service.getSupportedTypes()) {
                    types.put(type.getFullyQualifiedName(), type);
                }
            }
            int progress = 0;
            for (String typeName : types.keySet()) {
                ClassData type;
                type = (ClassData)types.get(typeName);
                JavonSerializer serializer = this.mapping.getRegistry().getTypeSerializer(type);
                if (serializer instanceof BeanTypeSerializer) {
                    FileObject outputDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.mapping.getClientMapping().getOutputDirectory())));
                    String packageName = type.getPackage();
                    String packageFolder = packageName.replace('.', '/');
                    OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_DestinationFolderCreation"), new File(FileUtil.toFile((FileObject)outputDir), packageFolder)));
                    FileObject destination = null;
                    try {
                        destination = FileUtil.createFolder((FileObject)outputDir, (String)packageFolder);
                    }
                    catch (IOException e) {
                        OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_FailFolderCreation"), new File(FileUtil.toFile((FileObject)outputDir), packageFolder)));
                        this.generationFailed(e, type.getName());
                        return false;
                    }
                    FileObject beanFile = destination.getFileObject(type.getName(), "java");
                    if (beanFile == null) {
                        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_BeanFileCreation"), new File(FileUtil.toFile((FileObject)outputDir), type.getName())));
                        try {
                            beanFile = destination.createData(type.getName(), "java");
                        }
                        catch (IOException e) {
                            OutputLogger.getInstance().log(OutputLogger.LogLevel.ERROR, MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_FailBeanCreation"), new File(FileUtil.toFile((FileObject)outputDir), type.getName())));
                            this.generationFailed(e, FileUtil.toFile((FileObject)outputDir));
                            return false;
                        }
                    }
                    if (!this.generateBean(beanFile, type)) {
                        result = false;
                    }
                    if ("true".equals(this.mapping.getProperty("databinding")) && beanFile != null) {
                        Project p = FileOwnerQuery.getOwner((FileObject)beanFile);
                        OutputLogger.getInstance().log(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_RegisterDatabindingLibrary"));
                        Util.registerDataBindingLibrary(p);
                    }
                    OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_BeanGenerated"), FileUtil.toFile((FileObject)beanFile)));
                }
                ++progress;
            }
            ph.switchToIndeterminate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean generateBean(FileObject outputFile, ClassData beanType) {
        try {
            OutputFileFormatter off = new OutputFileFormatter(outputFile);
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine eng = mgr.getEngineByName("freemarker");
            Bindings bind = eng.getContext().getBindings(100);
            FileObject template = FileUtil.getConfigFile((String)"Templates/Client/Bean.java");
            OutputLogger.getInstance().log(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_ConfigureBindings"));
            bind.put("mapping", (Object)this.mapping);
            bind.put("registry", (Object)this.mapping.getRegistry());
            bind.put("bean", (Object)beanType);
            bind.put("createStubs", (Object)this.mapping.getProperty("create-stubs").equals("true"));
            bind.put("utils", (Object)new Utils(this.mapping.getRegistry()));
            StringWriter w = null;
            Reader is = null;
            OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_GenerateBean"), FileUtil.toFile((FileObject)outputFile)));
            for (Map.Entry<String, String> entry : beanType.getInvaidFields().entrySet()) {
                String field = entry.getKey();
                String type = entry.getValue();
                OutputLogger.getInstance().log(OutputLogger.LogLevel.WARNING, MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_InvalidField"), beanType.getClassName(), field, type));
            }
            try {
                w = new StringWriter();
                is = new InputStreamReader(template.getInputStream());
                eng.getContext().setWriter(w);
                eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
                eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
                eng.eval(is);
                return true;
            }
            catch (ScriptException e) {
                OutputLogger.getInstance().log(e);
                ErrorManager.getDefault().notify((Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (FileNotFoundException e) {
                OutputLogger.getInstance().log(e);
                ErrorManager.getDefault().notify((Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (w != null) {
                    off.write(((Object)w).toString());
                    ((Writer)w).close();
                }
                if (is != null) {
                    is.close();
                }
                off.close();
            }
        }
        catch (IOException e2) {
            this.generationFailed(e2, FileUtil.toFile((FileObject)outputFile));
            return false;
        }
    }

    private void generationFailed(Exception e, Object file) {
        OutputLogger.getInstance().log(e);
        ErrorManager.getDefault().notify((Throwable)e);
        OutputLogger.getInstance().log(MessageFormat.format(NbBundle.getMessage(ClientBeanGeneratorTemplate.class, (String)"MSG_FailGenerateBean"), file));
    }
}

