/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;

public abstract class SyntaxElement {
    public static final int TYPE_COMMENT = 0;
    public static final int TYPE_DECLARATION = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_TAG = 4;
    public static final int TYPE_ENDTAG = 5;
    public static final int TYPE_ENTITY_REFERENCE = 6;
    public static final String[] TYPE_NAMES = new String[]{"comment", "declaration", "error", "text", "tag", "endtag", "entity reference"};
    private CharSequence source;
    private List<ProblemDescription> problems;
    private int offset;
    private int length;

    private SyntaxElement(CharSequence doc, int offset, int length) {
        assert (offset >= 0) : "start offset must be >= 0 !";
        assert (length >= 0) : "element length must be positive!";
        this.offset = offset;
        this.length = length;
        this.source = doc;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public abstract int type();

    public CharSequence text() {
        return this.source.subSequence(this.offset(), this.offset() + this.length());
    }

    public List<ProblemDescription> getProblems() {
        return this.problems;
    }

    synchronized void addProblem(ProblemDescription problem) {
        assert (problem != null);
        if (this.problems == null) {
            this.problems = Collections.singletonList(problem);
        } else {
            if (this.problems.size() == 1) {
                ProblemDescription existing = this.problems.get(0);
                this.problems = new ArrayList<ProblemDescription>();
                this.problems.add(existing);
            }
            this.problems.add(problem);
        }
    }

    public String toString() {
        CharSequence textContent = this.text();
        return "Element(" + TYPE_NAMES[this.type()] + ")[" + this.offset + "," + (this.offset + this.length - 1) + "] \"" + textContent + "\"";
    }

    public static class TagAttribute {
        private String name;
        private String value;
        private int nameOffset;
        private int valueOffset;
        private int valueLength;

        public TagAttribute(String name, String value, int nameOffset, int valueOffset, int valueLength) {
            this.name = name;
            this.value = value;
            this.nameOffset = nameOffset;
            this.valueOffset = valueOffset;
            this.valueLength = valueLength;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        void setValue(String value) {
            this.value = value;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        void setNameOffset(int ofs) {
            this.nameOffset = ofs;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        void setValueOffset(int ofs) {
            this.valueOffset = ofs;
        }

        public String toString() {
            return "TagAttribute[name=" + this.getName() + "; value=" + this.getValue() + "; nameOffset=" + this.getNameOffset() + "; valueOffset=" + this.getValueOffset() + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof TagAttribute)) {
                return false;
            }
            return this.getName().equals(((TagAttribute)o).getName());
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    public static class Tag
    extends Named {
        private List<TagAttribute> attribs;
        private boolean empty;
        private boolean openTag;

        public Tag(CharSequence document, int from, int length, String name, List attribs, boolean openTag, boolean isEmpty) {
            super(document, from, length, name);
            this.attribs = attribs;
            this.openTag = openTag;
            this.empty = isEmpty;
        }

        @Override
        public int type() {
            return this.openTag ? 4 : 5;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isOpenTag() {
            return this.openTag;
        }

        public List<TagAttribute> getAttributes() {
            return this.attribs == null ? Collections.EMPTY_LIST : this.attribs;
        }

        public TagAttribute getAttribute(String name) {
            return this.getAttribute(name, true);
        }

        public TagAttribute getAttribute(String name, boolean ignoreCase) {
            for (TagAttribute ta : this.getAttributes()) {
                if (!ta.getName().equals(name)) continue;
                return ta;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer(super.toString());
            ret.append(" - {");
            Iterator<TagAttribute> i = this.getAttributes().iterator();
            while (i.hasNext()) {
                ret.append(i.next());
                ret.append(", ");
            }
            ret.append("}");
            if (this.isEmpty()) {
                ret.append(" (EMPTY TAG)");
            }
            return ret.toString();
        }
    }

    public static abstract class Named
    extends SyntaxElement {
        String name;

        public Named(CharSequence document, int from, int to, String name) {
            super(document, from, to);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return super.toString() + " - \"" + this.name + '\"';
        }
    }

    public static class Declaration
    extends SyntaxElement {
        private String root;
        private String publicID;
        private String file;
        private String doctypeName;

        public Declaration(CharSequence document, int from, int length, String doctypeRootElement, String doctypePI, String doctypeFile, String doctypeName) {
            super(document, from, length);
            this.root = doctypeRootElement;
            this.publicID = doctypePI;
            this.file = doctypeFile;
            this.doctypeName = doctypeName;
        }

        public String getRootElement() {
            return this.root;
        }

        public String getPublicIdentifier() {
            return this.publicID;
        }

        public String getDoctypeFile() {
            return this.file;
        }

        public String getDeclarationName() {
            return this.doctypeName;
        }

        public boolean isValidDoctype() {
            return "doctype".equalsIgnoreCase(this.getDeclarationName()) && this.getRootElement() != null;
        }

        @Override
        public int type() {
            return 1;
        }
    }

    public static class Comment
    extends SyntaxElement {
        public Comment(CharSequence doc, int offset, int length) {
            super(doc, offset, length);
        }

        @Override
        public int type() {
            return 0;
        }
    }

    public static class EntityReference
    extends SyntaxElement {
        public EntityReference(CharSequence doc, int offset, int length) {
            super(doc, offset, length);
        }

        @Override
        public int type() {
            return 6;
        }
    }

    public static class Error
    extends SyntaxElement {
        public Error(CharSequence doc, int offset, int length) {
            super(doc, offset, length);
        }

        @Override
        public int type() {
            return 2;
        }
    }

    public static class SharedTextElement
    extends SyntaxElement {
        private static final String TO_STRING = "<n/a>";

        public SharedTextElement() {
            super(null, 0, 0);
        }

        @Override
        public int length() {
            assert (false);
            return super.length();
        }

        @Override
        public int offset() {
            assert (false);
            return super.offset();
        }

        @Override
        public CharSequence text() {
            return TO_STRING;
        }

        @Override
        public int type() {
            return 3;
        }
    }
}

