/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.wizard.EclipseWizardIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class ProjectImporterWizard {
    private List<EclipseProject> projects;
    private String destination;
    private boolean recursively;
    private boolean cancelled;
    private int numberOfImportedProjects;
    private List<WizardDescriptor.Panel<WizardDescriptor>> extraPanels;

    public void start() {
        final EclipseWizardIterator iterator = new EclipseWizardIterator();
        final WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        iterator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)iterator.getErrorMessage());
            }
        });
        wizardDescriptor.setTitleFormat(new MessageFormat("{1}"));
        wizardDescriptor.setTitle(ProjectImporterWizard.getMessage("CTL_WizardTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = this.cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!this.cancelled) {
            this.projects = iterator.getProjects();
            this.destination = iterator.getDestination();
            this.recursively = iterator.getRecursively();
            this.numberOfImportedProjects = iterator.getNumberOfImportedProject();
            this.extraPanels = iterator.getExtraPanels();
        }
    }

    public List<EclipseProject> getProjects() {
        return this.projects;
    }

    public int getNumberOfImportedProject() {
        return this.numberOfImportedProjects;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean getRecursively() {
        return this.recursively;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    static String getMessage(String key) {
        return NbBundle.getMessage(ProjectImporterWizard.class, (String)key);
    }

    static String getMessage(String key, Object param1) {
        return NbBundle.getMessage(ProjectImporterWizard.class, (String)key, (Object)param1);
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getExtraPanels() {
        return this.extraPanels;
    }
}

