/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JSFUtils {
    private static final String LIB_FOLDER = "lib";
    public static String DEFAULT_JSF_1_1_NAME = "jsf1102";
    public static String DEFAULT_JSF_1_2_NAME = "jsf12";
    public static String DEFAULT_JSF_2_0_NAME = "jsf20";
    public static String DEFAULT_JSF_1_2_RI_NAME = "jsf12ri";
    public static String DEFAULT_JSF_2_0_RI_NAME = "jsf20ri";
    public static String DEFAULT_JSTL_1_1_NAME = "jstl11";
    public static final String FACES_EXCEPTION = "javax.faces.FacesException";
    public static final String JSF_1_2__API_SPECIFIC_CLASS = "javax.faces.application.StateManagerWrapper";
    public static final String JSF_2_0__API_SPECIFIC_CLASS = "javax.faces.application.ProjectStage";
    public static final String JSF_2_0__IMPL_SPECIFIC_CLASS = "com.sun.faces.facelets.Facelet";
    public static final String MYFACES_SPECIFIC_CLASS = "org.apache.myfaces.webapp.StartupServletContextListener";
    protected static final String FACELETS_SKIPCOMMNETS = "javax.faces.FACELETS_SKIP_COMMENTS";
    protected static final String FACELETS_DEVELOPMENT = "facelets.DEVELOPMENT";
    protected static final String FACELETS_DEFAULT_SUFFIX = "javax.faces.DEFAULT_SUFFIX";
    public static final String FACES_PROJECT_STAGE = "javax.faces.PROJECT_STAGE";

    public static String isJSFInstallFolder(File folder, JSFVersion maxVersion) {
        String result = null;
        if (folder.exists() && folder.isDirectory()) {
            File libFolder = new File(folder, LIB_FOLDER);
            if (libFolder.exists()) {
                File[] files = libFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        boolean accepted = false;
                        if (pathname.getName().endsWith(".jar")) {
                            accepted = true;
                        }
                        return accepted;
                    }
                });
                boolean isJSF = false;
                JSFVersion jsfVersion = JSFVersion.JSF_1_1;
                try {
                    List<File> list = Arrays.asList(files);
                    isJSF = Util.containsClass(list, (String)FACES_EXCEPTION);
                    if (Util.containsClass(list, (String)JSF_1_2__API_SPECIFIC_CLASS)) {
                        jsfVersion = JSFVersion.JSF_1_2;
                    }
                }
                catch (IOException exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                if (!isJSF) {
                    result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_JSF_API", (Object)libFolder.getPath());
                } else if (jsfVersion.compareTo(maxVersion) > 0) {
                    result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_REQUIRED_JSF_VERSION");
                }
            } else {
                result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_THERE_IS_NOT_LIB_FOLDER", (Object)folder.getPath());
            }
        } else {
            result = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_IS_NOT_VALID_PATH", (Object)folder.getPath());
        }
        return result;
    }

    public static boolean createJSFUserLibrary(File folder, String libraryName) throws IOException {
        boolean result = false;
        File libFolder = new File(folder, LIB_FOLDER);
        if (libFolder.exists() && libFolder.isDirectory()) {
            File[] jars = libFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar");
                }
            });
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < jars.length; ++i) {
                URL url = FileUtil.urlForArchiveOrDir((File)jars[i]);
                if (url == null) continue;
                urls.add(url);
            }
            LibraryManager libraryManager = LibraryManager.getDefault();
            LibraryImplementation libImpl = LibrariesSupport.getLibraryTypeProvider((String)"j2se").createLibrary();
            libImpl.setName(libraryName);
            libImpl.setDescription(libraryName);
            libImpl.setContent("classpath", urls);
            libraryManager.addLibrary(LibraryFactory.createLibrary((LibraryImplementation)libImpl));
            result = true;
        }
        return result;
    }

    public static boolean debugFacelets(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", FACELETS_DEVELOPMENT);
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static boolean skipCommnets(FileObject dd) {
        boolean value = false;
        if (dd != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                InitParam param = null;
                if (webApp != null) {
                    param = (InitParam)webApp.findBeanByName("InitParam", "ParamName", "facelets.SKIP_COMMENTS");
                }
                if (param != null) {
                    value = "true".equals(param.getParamValue().trim());
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return value;
    }

    public static String getRelativePath(FileObject fromFO, FileObject toFO) {
        String path = "./";
        String tmpPath = null;
        for (FileObject parent = fromFO.getParent(); parent != null && (tmpPath = FileUtil.getRelativePath((FileObject)parent, (FileObject)toFO)) == null; parent = parent.getParent()) {
            path = path + "../";
        }
        return tmpPath != null ? path + tmpPath : null;
    }

    public static boolean isJSF20(WebModule wm) {
        if (wm == null) {
            return false;
        }
        ClassPath classpath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        boolean isJSF20 = classpath.findResource(JSF_2_0__API_SPECIFIC_CLASS.replace('.', '/') + ".class") != null;
        return isJSF20;
    }

    public static boolean isJavaEE5(TemplateWizard wizard) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            Profile profile = wm.getJ2eeProfile();
            return profile == Profile.JAVA_EE_5;
        }
        return false;
    }

    public static boolean isCDIEnabled(WebModule wm) {
        FileObject confRoot;
        return wm != null && (confRoot = wm.getWebInf()) != null && confRoot.getFileObject("beans.xml") != null;
    }
}

