/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.metamodel;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.ModelUnit;
import org.netbeans.modules.web.jsf.impl.metamodel.JsfModelImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class JsfModelFactory {
    private static final Map<WebModule, MetadataModel<JsfModel>> MODELS = new WeakHashMap<WebModule, MetadataModel<JsfModel>>();

    private JsfModelFactory() {
    }

    public static MetadataModel<JsfModel> createMetaModel(ModelUnit unit) {
        return MetadataModelFactory.createMetadataModel(JsfModelImplementation.create(unit));
    }

    public static synchronized MetadataModel<JsfModel> getModel(WebModule module) {
        MetadataModel<JsfModel> model = MODELS.get(module);
        if (model == null) {
            ModelUnit unit = JsfModelFactory.getUnit(module);
            if (unit == null) {
                return null;
            }
            model = JsfModelFactory.createMetaModel(unit);
            MODELS.put(module, model);
        }
        return model;
    }

    private static ModelUnit getUnit(WebModule module) {
        Project project;
        if (module == null) {
            return null;
        }
        FileObject fileObject = JsfModelFactory.getFileObject(module);
        Project project2 = project = fileObject == null ? null : FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClassPath boot = JsfModelFactory.getClassPath(project, "classpath/boot");
        ClassPath compile = JsfModelFactory.getClassPath(project, "classpath/compile");
        ClassPath src = JsfModelFactory.getClassPath(project, "classpath/source");
        return src == null ? null : ModelUnit.create(boot, compile, src, module);
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        int i$ = 0;
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        SourceGroup[] arr$ = sourceGroups;
        int len$ = arr$.length;
        if (i$ < len$) {
            SourceGroup sourceGroup = arr$[i$];
            FileObject rootFolder = sourceGroup.getRootFolder();
            ClassPath path = provider.findClassPath(rootFolder, type);
            return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{path});
        }
        return null;
    }

    private static FileObject getFileObject(WebModule module) {
        FileObject fileObject = module.getDocumentBase();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getDeploymentDescriptor();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getWebInf();
        if (fileObject != null) {
            return fileObject;
        }
        FileObject[] facesConfigFiles = ConfigurationUtils.getFacesConfigFiles(module);
        if (facesConfigFiles != null && facesConfigFiles.length > 0) {
            return facesConfigFiles[0];
        }
        FileObject[] fileObjects = module.getJavaSources();
        if (fileObjects != null) {
            for (FileObject source : fileObjects) {
                if (source == null) continue;
                return source;
            }
        }
        return null;
    }
}

