/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class EntityClass {
    public static final int FORM_TYPE_EMPTY = 0;
    public static final int FORM_TYPE_DETAIL = 1;
    public static final int FORM_TYPE_NEW = 2;
    public static final int FORM_TYPE_EDIT = 3;
    protected String variable = "";
    protected String bean = "";
    protected int formType = 0;

    protected abstract String getName();

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public int getFormType() {
        return this.formType;
    }

    public void setFormType(int formType) {
        this.formType = formType;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        try {
            Caret caret = targetComponent.getCaret();
            int position0 = Math.min(caret.getDot(), caret.getMark());
            int position1 = Math.max(caret.getDot(), caret.getMark());
            int len = targetComponent.getDocument().getLength() - position1;
            boolean containsFView = targetComponent.getText(0, position0).contains("<f:view>") && targetComponent.getText(position1, len).contains("</f:view>");
            String body = this.createBody(targetComponent, !containsFView);
            JSFPaletteUtilities.insert(body, targetComponent);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return false;
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return false;
        }
        return true;
    }

    protected abstract String createBody(JTextComponent var1, boolean var2) throws IOException;

    static boolean isId(ExecutableElement method, boolean isFieldAccess) {
        Element element;
        Element element2 = element = isFieldAccess ? JpaControllerUtil.guessField((ExecutableElement)method) : method;
        return element != null && (JpaControllerUtil.isAnnotatedWith((Element)element, (String)"javax.persistence.Id") || JpaControllerUtil.isAnnotatedWith((Element)element, (String)"javax.persistence.EmbeddedId"));
    }

    static String getTemporal(ExecutableElement method, boolean isFieldAccess) {
        AnnotationValue annotationValue;
        Collection<? extends AnnotationValue> attributes;
        AnnotationMirror annotationMirror;
        Element element;
        Element element2 = element = isFieldAccess ? JpaControllerUtil.guessField((ExecutableElement)method) : method;
        if (element != null && (annotationMirror = JpaControllerUtil.findAnnotation((Element)element, (String)"javax.persistence.Temporal")) != null && (attributes = annotationMirror.getElementValues().values()).iterator().hasNext() && (annotationValue = attributes.iterator().next()) != null) {
            return annotationValue.getValue().toString();
        }
        return null;
    }

    static FileObject getFO(JTextComponent target) {
        Document doc = target.getDocument();
        if (doc != null) {
            return NbEditorUtilities.getFileObject((Document)doc);
        }
        return null;
    }

    static ClasspathInfo createClasspathInfo(FileObject fileObject) {
        return ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source"));
    }

    public static boolean isEntityClass(TypeElement typeElement) {
        return JpaControllerUtil.isAnnotatedWith((Element)typeElement, (String)"javax.persistence.Entity");
    }

    static String getDateTimeFormat(String temporal) {
        if ("DATE".equals(temporal)) {
            return "MM/dd/yyyy";
        }
        if ("TIME".equals(temporal)) {
            return "HH:mm:ss";
        }
        return "MM/dd/yyyy HH:mm:ss";
    }

    protected boolean classExists(FileObject referenceFO, final String className) throws IOException {
        if (referenceFO == null) {
            return false;
        }
        ClasspathInfo cpi = ClasspathInfo.create((FileObject)referenceFO);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)cpi, (Collection)Collections.EMPTY_LIST);
        if (javaSource == null) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                result[0] = typeElement != null;
            }
        }, true);
        return result[0];
    }

    public void addManagedBean(FileObject referenceFO, String beanName, String className) {
        try {
            String file;
            WebModule webModule = WebModule.getWebModule((FileObject)referenceFO);
            if (webModule == null) {
                return;
            }
            FileObject cfFileObject = null;
            FileObject documentBase = webModule.getDocumentBase();
            String[] arr$ = JSFConfigUtilities.getConfigFiles(webModule);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (cfFileObject = documentBase.getFileObject(file = arr$[i$])) == null; ++i$) {
            }
            if (cfFileObject == null) {
                return;
            }
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(cfFileObject, true).getRootComponent();
            ManagedBean managedBean = facesConfig.getModel().getFactory().createManagedBean();
            managedBean.setManagedBeanName(beanName);
            managedBean.setManagedBeanClass(className);
            managedBean.setManagedBeanScope(ManagedBean.Scope.REQUEST);
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean(managedBean);
            facesConfig.getModel().endTransaction();
            facesConfig.getModel().sync();
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

