/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ManagedBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private ManagedBeanPanel managedBeanPanel;
    private transient WizardDescriptor.Panel[] panels;
    private transient boolean debug = false;
    private static final Map<ManagedBean.Scope, String> FACES_SCOPE = new HashMap<ManagedBean.Scope, String>();
    private static final Map<String, String> CDI_SCOPE;
    private static final Map<NamedScope, String> NAMED_SCOPE;

    public void initialize(TemplateWizard wizard) {
        WizardDescriptor.Panel javaPanel;
        if (this.debug) {
            this.log("initialize");
        }
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (this.debug) {
            this.log("\tproject: " + project);
            this.log("\ttargetFolder: " + targetFolder);
            this.log("\tsourceGroups.length: " + sourceGroups.length);
        }
        this.managedBeanPanel = new ManagedBeanPanel(project, wizard);
        if (sourceGroups.length == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanIterator.class, (String)"MSG_No_Sources_found"));
            javaPanel = this.managedBeanPanel;
        } else {
            javaPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.managedBeanPanel);
            javaPanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ManagedBeanIterator.this.managedBeanPanel.updateManagedBeanName((WizardDescriptor.Panel)e.getSource());
                }
            });
        }
        this.panels = new WizardDescriptor.Panel[]{javaPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        if (this.debug) {
            this.log("instantiate");
        }
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String configFile = (String)wizard.getProperty("ConfigFile");
        Project project = Templates.getProject((WizardDescriptor)wizard);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        dir = wm.getDocumentBase();
        if (configFile == null && !JSFConfigUtilities.hasJsfFramework(dir)) {
            JSFConfigUtilities.extendJsfFramework(dir, false);
        }
        String beanName = this.getUniqueName((String)wizard.getProperty("Name"), wm);
        Object scope = wizard.getProperty("Scope");
        boolean isAnnotate = !this.managedBeanPanel.isAddBeanToConfig();
        DataObject dobj = null;
        if (isAnnotate && (Utilities.isJavaEE6((TemplateWizard)wizard) || JSFUtils.isJSF20(wm) && JSFUtils.isJavaEE5(wizard))) {
            HashMap<String, String> templateProperties = new HashMap<String, String>();
            String targetName = Templates.getTargetName((WizardDescriptor)wizard);
            if (JSFUtils.isCDIEnabled(wm)) {
                templateProperties.put("CDIEnabled", "true");
                templateProperties.put("classAnnotation", "@Named(value=\"" + beanName + "\")");
                templateProperties.put("scopeAnnotation", NAMED_SCOPE.get((Object)((NamedScope)((Object)scope))).toString());
                NamedScope namedScope = (NamedScope)((Object)scope);
                switch (namedScope) {
                    case SESSION: 
                    case CONVERSATION: {
                        templateProperties.put("passivationCapable", "true");
                        break;
                    }
                }
            } else {
                if (targetName.equalsIgnoreCase(beanName) && targetName.substring(0, 1).toLowerCase().equals(beanName.substring(0, 1))) {
                    templateProperties.put("classAnnotation", "@ManagedBean");
                } else {
                    templateProperties.put("classAnnotation", "@ManagedBean(name=\"" + beanName + "\")");
                }
                templateProperties.put("scopeAnnotation", FACES_SCOPE.get((Object)((ManagedBean.Scope)((Object)scope))).toString());
            }
            dobj = dTemplate.createFromTemplate(df, targetName, templateProperties);
        } else {
            FileObject fo = dir.getFileObject(configFile);
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fo, true).getRootComponent();
            JSFBeanCache.getBeans(wm);
            dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wizard));
            ManagedBean bean = facesConfig.getModel().getFactory().createManagedBean();
            String targetName = Templates.getTargetName((WizardDescriptor)wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            String packageName = null;
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            for (int i = 0; i < groups.length && packageName == null && (packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder)) == null; ++i) {
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            String className = null;
            className = packageName.length() > 0 ? packageName + "." + targetName : targetName;
            bean.setManagedBeanName(beanName);
            bean.setManagedBeanClass(className);
            if (scope == null) {
                scope = ManagedBean.Scope.REQUEST;
            }
            bean.setManagedBeanScope((ManagedBean.Scope)((Object)scope));
            String description = (String)wizard.getProperty("Description");
            if (description != null && description.length() > 0) {
                Description beanDescription = bean.getModel().getFactory().createDescription();
                beanDescription.setValue(description);
                bean.addDescription(beanDescription);
            }
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean(bean);
            facesConfig.getModel().endTransaction();
            facesConfig.getModel().sync();
        }
        return Collections.singleton(dobj);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(ManagedBeanIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private void log(String message) {
        System.out.println("ActionIterator:: \t" + message);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private void replaceInDocument(Document document, String replaceFrom, String replaceTo) {
        AbstractDocument doc = (AbstractDocument)document;
        int len = replaceFrom.length();
        try {
            String content = doc.getText(0, doc.getLength());
            int index = content.lastIndexOf(replaceFrom);
            while (index >= 0) {
                doc.replace(index, len, replaceTo, null);
                content = content.substring(0, index);
                index = content.lastIndexOf(replaceFrom);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    private String getUniqueName(String original, WebModule wm) {
        String value = original;
        int count = 0;
        for (FacesManagedBean managedBean : JSFBeanCache.getBeans(wm)) {
            if (!value.equals(managedBean.getManagedBeanName())) continue;
            value = original + ++count;
        }
        return value;
    }

    static {
        FACES_SCOPE.put(ManagedBean.Scope.APPLICATION, "ApplicationScoped");
        FACES_SCOPE.put(ManagedBean.Scope.NONE, "NoneScoped");
        FACES_SCOPE.put(ManagedBean.Scope.REQUEST, "RequestScoped");
        FACES_SCOPE.put(ManagedBean.Scope.SESSION, "SessionScoped");
        FACES_SCOPE.put(ManagedBean.Scope.VIEW, "ViewScoped");
        CDI_SCOPE = new HashMap<String, String>();
        CDI_SCOPE.put(null, "Dependent");
        NAMED_SCOPE = new HashMap<NamedScope, String>();
        NAMED_SCOPE.put(NamedScope.DEPENDENT, "Dependent");
        NAMED_SCOPE.put(NamedScope.APPLICATION, "ApplicationScoped");
        NAMED_SCOPE.put(NamedScope.REQUEST, "RequestScoped");
        NAMED_SCOPE.put(NamedScope.SESSION, "SessionScoped");
        NAMED_SCOPE.put(NamedScope.CONVERSATION, "ConversationScoped");
    }

    protected static enum NamedScope {
        DEPENDENT("dependent"),
        APPLICATION("application"),
        REQUEST("request"),
        SESSION("session"),
        CONVERSATION("conversation");

        private String scope;

        private NamedScope(String scope) {
            this.scope = scope;
        }

        public String toString() {
            return this.scope;
        }
    }
}

