/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public final class FilterSet {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.filters.Bundle");
    public static final String DEFAULT_FILTERSET_NAME = bundle.getString("FilterSet_DefaultFilterSetName");
    public static final String PROP_FILTER_TYPE_VALUE = "profiler.filter.set";
    public static final boolean FILTER_SET_EXCLUSIVE = false;
    public static final boolean FILTER_SET_INCLUSIVE = true;
    private String filterSetName;
    private String[] activeGlobalFilters;
    private boolean filterSetType;

    public FilterSet() {
        this(DEFAULT_FILTERSET_NAME);
    }

    public FilterSet(String name) {
        this(name, false, new String[0]);
    }

    public FilterSet(String name, boolean type, String[] activeFilters) {
        this.setFilterSetName(name);
        this.setFilterSetType(type);
        this.activeGlobalFilters = activeFilters;
    }

    public FilterSet(FilterSet filterSet) {
        this.setValuesFrom(filterSet);
    }

    public int getActiveGlobalFilterIndex(String globalFilterName) {
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            if (!this.activeGlobalFilters[i].equals(globalFilterName)) continue;
            return i;
        }
        return -1;
    }

    public void setActiveGlobalFilters(String[] globalFilters) {
        if (globalFilters == null) {
            return;
        }
        this.activeGlobalFilters = globalFilters;
    }

    public String[] getActiveGlobalFilters() {
        return this.activeGlobalFilters;
    }

    public void setExclusive() {
        this.filterSetType = false;
    }

    public boolean isExclusive() {
        return !this.filterSetType;
    }

    public void setFilterSetName(String name) {
        if (name == null) {
            return;
        }
        this.filterSetName = name;
    }

    public String getFilterSetName() {
        return this.filterSetName;
    }

    public void setFilterSetType(boolean type) {
        this.filterSetType = type;
    }

    public boolean getFilterSetType() {
        return this.filterSetType;
    }

    public void setInclusive() {
        this.filterSetType = true;
    }

    public boolean isInclusive() {
        return this.filterSetType;
    }

    public void setValuesFrom(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.setFilterSetName(filterSet.getFilterSetName());
        this.setFilterSetType(filterSet.getFilterSetType());
        int nGlobalFilters = filterSet.getActiveGlobalFilters().length;
        this.activeGlobalFilters = new String[nGlobalFilters];
        for (int i = 0; i < nGlobalFilters; ++i) {
            this.activeGlobalFilters[i] = filterSet.getActiveGlobalFilters()[i];
        }
    }

    public void addActiveGlobalFilter(String globalFilterName) {
        int nCurrentFilters = this.activeGlobalFilters.length;
        String[] newFilters = new String[nCurrentFilters + 1];
        System.arraycopy(this.activeGlobalFilters, 0, newFilters, 0, nCurrentFilters);
        newFilters[nCurrentFilters] = globalFilterName;
        this.activeGlobalFilters = newFilters;
    }

    public void clear() {
        this.setFilterSetName(DEFAULT_FILTERSET_NAME);
        this.setFilterSetType(false);
        this.activeGlobalFilters = new String[0];
    }

    public boolean containsActiveGlobalFilter(String globalFilterName) {
        return this.getActiveGlobalFilterIndex(globalFilterName) != -1;
    }

    public String debug() {
        StringBuffer sb = new StringBuffer();
        sb.append("FilterSet name: " + this.filterSetName);
        sb.append("\n");
        sb.append("  Type: " + (!this.filterSetType ? "Exclusive" : "Inclusive"));
        sb.append("\n");
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            sb.append("  GlobalFilter " + i + ": " + this.activeGlobalFilters[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterSet)) {
            return false;
        }
        FilterSet filterSet = (FilterSet)o;
        if (!this.filterSetName.equals(filterSet.filterSetName)) {
            return false;
        }
        if (this.filterSetType != filterSet.filterSetType) {
            return false;
        }
        if (this.activeGlobalFilters.length != filterSet.activeGlobalFilters.length) {
            return false;
        }
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            if (this.activeGlobalFilters[i].equals(filterSet.activeGlobalFilters[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.filterSetName != null ? this.filterSetName.hashCode() : 0);
        hash = 97 * hash + Arrays.deepHashCode(this.activeGlobalFilters);
        hash = 97 * hash + (this.filterSetType ? 1 : 0);
        return hash;
    }

    public FilterSet load(Map props, int index) {
        return this.load(props, index, "");
    }

    public FilterSet load(Map props, String prefix) {
        if (!FilterSet.getProperty(props, prefix + "profiler.filter.type", "").equals(PROP_FILTER_TYPE_VALUE)) {
            throw new RuntimeException("Trying to load incompatible filter");
        }
        return this.load(props, -1, prefix);
    }

    public FilterSet load(Map props, int index, String prefix) {
        String activeFilterName;
        String itemPrefix = "FilterSet-" + (index == -1 ? "" : Integer.valueOf(index).toString() + "-");
        this.filterSetName = FilterSet.getProperty(props, prefix + itemPrefix + "name", DEFAULT_FILTERSET_NAME);
        this.filterSetType = Boolean.valueOf(FilterSet.getProperty(props, prefix + itemPrefix + "type", "false"));
        Vector<String> activeFilters = new Vector<String>();
        while ((activeFilterName = (String)props.get(prefix + itemPrefix + "active_filter-" + activeFilters.size())) != null) {
            activeFilters.add(activeFilterName);
        }
        this.activeGlobalFilters = new String[activeFilters.size()];
        for (int i = 0; i < activeFilters.size(); ++i) {
            this.activeGlobalFilters[i] = (String)activeFilters.get(i);
        }
        return this;
    }

    public void removeActiveGlobalFilter(String globalFilterName) {
        int filterIndex = this.getActiveGlobalFilterIndex(globalFilterName);
        if (filterIndex == -1) {
            return;
        }
        int nCurrentFilters = this.activeGlobalFilters.length;
        String[] newFilters = new String[nCurrentFilters - 1];
        if (filterIndex > 0) {
            System.arraycopy(this.activeGlobalFilters, 0, newFilters, 0, filterIndex);
        }
        if (filterIndex < nCurrentFilters - 1) {
            System.arraycopy(this.activeGlobalFilters, filterIndex + 1, newFilters, filterIndex, nCurrentFilters - filterIndex - 1);
        }
        this.activeGlobalFilters = newFilters;
    }

    public void store(Map props, int index) {
        this.store(props, index, "");
    }

    public void store(Map props, String prefix) {
        props.put(prefix + "profiler.filter.type", PROP_FILTER_TYPE_VALUE);
        this.store(props, -1, prefix);
    }

    public void store(Map props, int index, String prefix) {
        String itemPrefix = "FilterSet-" + (index == -1 ? "" : Integer.valueOf(index).toString() + "-");
        props.put(prefix + itemPrefix + "name", this.filterSetName);
        props.put(prefix + itemPrefix + "type", Boolean.toString(this.filterSetType));
        for (int i = 0; i < this.activeGlobalFilters.length; ++i) {
            props.put(prefix + itemPrefix + "active_filter-" + i, this.activeGlobalFilters[i]);
        }
    }

    public String toString() {
        return this.getFilterSetName();
    }

    private static String getProperty(Map props, Object key, String defaultValue) {
        Object ret = props.get(key);
        return ret != null ? (String)ret : defaultValue;
    }
}

