/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.openide.util.NbBundle;

public final class ToolchainScriptGenerator {
    private static final boolean TRACE = true;
    private static final String[] platforms = new String[]{"PLATFORM_SOLARIS_SPARC", "PLATFORM_SOLARIS_INTEL", "PLATFORM_LINUX", "PLATFORM_MACOSX", "PLATFORM_NONE"};
    private static final int[] platformsID = new int[]{0, 1, 2, 4, 6};
    private final StringBuilder buf = new StringBuilder();
    private int level = 0;

    private ToolchainScriptGenerator() {
    }

    public static String generateScript(String path) {
        ToolchainScriptGenerator generator = new ToolchainScriptGenerator();
        generator.prefix(path);
        generator.scanPaths();
        return generator.buf.toString();
    }

    private void prefix(String path) {
        this.line("#!/bin/sh");
        this.lines(NbBundle.getMessage(ToolchainScriptGenerator.class, (String)"DetectHostInfo"));
        if (path != null) {
            this.line("PATHSLIST=\"" + path + "\"");
        } else {
            this.line("echo $PLATFORM_NAME");
            for (int i = 0; i < platforms.length; ++i) {
                this.line("if [ \"$PLATFORM\" = \"$" + platforms[i] + "\" ]; then");
                if (platformsID[i] == 3) {
                    this.line("PATH=$PATH;C:/WINDOWS/System32;C:/WINDOWS;C:/WINDOWS/System32/WBem");
                } else if (platformsID[i] != 6) {
                    this.line("PATH=$PATH:/bin:/usr/bin:/sbin:/usr/sbin");
                } else {
                    this.line("PATH=$PATH");
                }
                ArrayList<String> dirlist = new ArrayList<String>();
                CompilerSetManagerImpl.appendDefaultLocations(platformsID[i], dirlist);
                for (String s : dirlist) {
                    this.line("PATH=$PATH:" + s);
                }
                this.line("fi");
            }
            this.line("PATHSLIST=$PATH");
        }
        this.line("if [ \"$PLATFORM\" = \"$PLATFORM_WINDOWS\" ]; then");
        this.line(" IFS=;");
        this.line("else");
        this.line(" IFS=:");
        this.line("fi");
        this.line("foundFlavors=\";\"");
    }

    private void scanPaths() {
        this.line("for f in $PATHSLIST; do");
        this.line("  line=");
        this.line("  flavor=");
        this.line("  echo $f | egrep -e \"^/\" >/dev/null");
        this.line("  if [ \"$?\" != \"0\" ]; then");
        this.line("    continue  # skip relative directories");
        this.line("  fi");
        this.line("  echo $f | egrep -e \"^/usr/ucb\" >/dev/null");
        this.line("  if [ \"$?\" = \"0\" ]; then");
        this.line("    continue  # skip /usr/ucb (IZ #142780)");
        this.line("  fi");
        this.scanPath();
        this.line("done");
    }

    private void scanPath() {
        for (int i = 0; i < platforms.length; ++i) {
            this.line("if [ \"$PLATFORM\" = \"$" + platforms[i] + "\" ]; then");
            this.platformPath(platformsID[i]);
            this.line("fi");
        }
    }

    private void platformPath(int platform) {
        for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(platform)) {
            ToolchainManager.CompilerDescriptor c;
            if (d.isAbstract() || d.getModuleID() != null || (c = d.getC()) == null || c.getNames().length == 0) continue;
            this.line("status=");
            this.line("while [ ! -n \"$status\" ]; do");
            if (c.getPathPattern() != null) {
                this.line("  echo $f | egrep -e \"" + c.getPathPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                if (c.getExistFolder() == null) {
                    this.line("    break");
                } else {
                    this.line("    if [ ! -d \"$f/" + c.getExistFolder() + "\" ]; then");
                    this.line("      break");
                    this.line("    fi");
                }
                this.line("  fi");
            }
            this.line("  file=\"$f/" + c.getNames()[0] + "\"");
            this.line("  if [ ! -x \"$file\" ]; then");
            if (platform == 3) {
                this.line("    file=\"$f/" + c.getNames()[0] + ".exe\"");
                this.line("    if [ ! -x \"$f/" + c.getNames()[0] + ".exe\" ]; then");
                this.line("      break");
                this.line("    fi");
            } else {
                this.line("    break");
            }
            this.line("  fi");
            if (c.getVersionFlags() != null && c.getVersionPattern() != null) {
                this.line("  $file " + c.getVersionFlags() + " 2>&1 | egrep -e \"" + c.getVersionPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                this.line("    break");
                this.line("  fi");
            }
            this.line("  line=\"" + d.getName() + ";$f\"");
            this.line("  flavor=\"" + d.getName() + ";\"");
            this.addTool("c", d.getC().getNames(), platform);
            if (d.getCpp() != null) {
                this.addTool("cpp", d.getCpp().getNames(), platform);
            }
            if (d.getFortran() != null) {
                this.addTool("fortran", d.getFortran().getNames(), platform);
            }
            if (d.getAssembler() != null) {
                this.addTool("assembler", d.getAssembler().getNames(), platform);
            }
            if (d.getMake() != null) {
                this.addTool("make", d.getMake().getNames(), platform);
            }
            if (d.getDebugger() != null) {
                this.addTool("debugger", d.getDebugger().getNames(), platform);
            }
            if (d.getCMake() != null) {
                this.addTool("cmake", d.getCMake().getNames(), platform);
            }
            if (d.getQMake() != null) {
                this.addTool("qmake", d.getQMake().getNames(), platform);
            }
            this.line("  addNewToolChain");
            this.line("  break");
            this.line("done");
        }
    }

    private void addTool(String kind, String[] names, int platform) {
        if (names != null) {
            StringBuilder list = new StringBuilder();
            for (String name : names) {
                if (list.length() > 0) {
                    if (platform == 3) {
                        list.append(';');
                    } else {
                        list.append(':');
                    }
                }
                list.append(name);
            }
            this.line("findCompiler \"" + list.toString() + "\" \"" + kind + "\"");
        }
    }

    private void lines(String lines) {
        StringTokenizer st = new StringTokenizer(lines, "\n");
        while (st.hasMoreTokens()) {
            this.line(st.nextToken());
        }
    }

    private void line(String line) {
        String l = line.trim();
        if (l.equals("fi") || l.equals("done") || l.equals("else") || l.equals("}")) {
            --this.level;
        }
        if (this.level >= 0) {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append(' ');
                this.buf.append(' ');
            }
        }
        if (l.startsWith("while ") || l.startsWith("if ") || l.startsWith("for ") || l.equals("else") || l.endsWith("{")) {
            ++this.level;
        }
        this.buf.append(l).append('\n');
    }
}

