/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.PersistentList;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.openide.util.Utilities;

abstract class CCCCompiler
extends AbstractCompiler {
    private static final String DEV_NULL = "/dev/null";
    private volatile Pair compilerDefinitions;
    private static File emptyFile = null;

    protected CCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> values) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)values).equals(this.compilerDefinitions.systemIncludeDirectoriesList)) {
            return false;
        }
        ArrayList<String> systemIncludeDirectoriesList = new ArrayList<String>(values);
        this.normalizePaths(systemIncludeDirectoriesList);
        this.compilerDefinitions.systemIncludeDirectoriesList = systemIncludeDirectoriesList;
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> values) {
        assert (values != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)values).equals(this.compilerDefinitions.systemPreprocessorSymbolsList)) {
            return false;
        }
        this.compilerDefinitions.systemPreprocessorSymbolsList = new ArrayList<String>(values);
        return true;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        if (this.compilerDefinitions == null) {
            this.resetSystemProperties();
        }
        return this.compilerDefinitions.systemPreprocessorSymbolsList;
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        if (this.compilerDefinitions == null) {
            this.resetSystemProperties();
        }
        return this.compilerDefinitions.systemIncludeDirectoriesList;
    }

    @Override
    public boolean isReady() {
        return this.compilerDefinitions != null;
    }

    @Override
    public void waitReady(boolean reset) {
        if (reset || !this.isReady()) {
            this.resetSystemProperties();
        }
    }

    @Override
    public void resetSystemProperties(boolean lazy) {
        if (lazy) {
            this.compilerDefinitions = null;
        } else {
            CndUtils.assertNonUiThread();
            this.compilerDefinitions = this.getFreshSystemIncludesAndDefines();
        }
    }

    @Override
    public void loadSettings(Preferences prefs, String prefix) {
        PersistentList<String> oldPreprocSymbolList;
        PersistentList<String> oldIncludeDirList;
        ArrayList<String> includeDirList = new ArrayList<String>();
        String includeDirPrefix = prefix + ".systemIncludes";
        int includeDirCount = prefs.getInt(includeDirPrefix + ".count", 0);
        for (int i = 0; i < includeDirCount; ++i) {
            String includeDir = prefs.get(includeDirPrefix + '.' + i, null);
            if (includeDir == null) continue;
            includeDirList.add(includeDir);
        }
        if (includeDirList.isEmpty() && (oldIncludeDirList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList")) != null) {
            includeDirList.addAll(oldIncludeDirList);
        }
        this.setSystemIncludeDirectories(includeDirList);
        ArrayList<String> preprocSymbolList = new ArrayList<String>();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        int preprocSymbolCount = prefs.getInt(preprocSymbolPrefix + ".count", 0);
        for (int i = 0; i < preprocSymbolCount; ++i) {
            String preprocSymbol = prefs.get(preprocSymbolPrefix + '.' + i, null);
            if (preprocSymbol == null) continue;
            preprocSymbolList.add(preprocSymbol);
        }
        if (preprocSymbolList.isEmpty() && (oldPreprocSymbolList = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList")) != null) {
            preprocSymbolList.addAll(oldPreprocSymbolList);
        }
        this.setSystemPreprocessorSymbols(preprocSymbolList);
    }

    @Override
    public void saveSettings(Preferences prefs, String prefix) {
        List<String> includeDirList = this.getSystemIncludeDirectories();
        String includeDirPrefix = prefix + ".systemIncludes";
        prefs.putInt(includeDirPrefix + ".count", includeDirList.size());
        for (int i = 0; i < includeDirList.size(); ++i) {
            prefs.put(includeDirPrefix + '.' + i, includeDirList.get(i));
        }
        List<String> preprocSymbolList = this.getSystemPreprocessorSymbols();
        String preprocSymbolPrefix = prefix + ".systemMacros";
        prefs.putInt(preprocSymbolPrefix + ".count", preprocSymbolList.size());
        for (int i = 0; i < preprocSymbolList.size(); ++i) {
            prefs.put(preprocSymbolPrefix + '.' + i, preprocSymbolList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getSystemIncludesAndDefines(String arguments, boolean stdout, Pair pair) throws IOException {
        block10: {
            String compilerPath = this.getPath();
            if (compilerPath == null || compilerPath.length() == 0) {
                return;
            }
            ExecutionEnvironment execEnv = this.getExecutionEnvironment();
            try {
                InputStream stream;
                if (execEnv.isLocal() && Utilities.isWindows()) {
                    compilerPath = LinkSupport.resolveWindowsLink((String)compilerPath);
                }
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath)) {
                    compilerPath = this.getDefaultPath();
                }
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)compilerPath)) {
                    return;
                }
                ArrayList<String> argsList = new ArrayList<String>();
                argsList.addAll(Arrays.asList(arguments.trim().split(" +")));
                argsList.add(this.getEmptyFile(execEnv));
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
                npb.setExecutable(compilerPath);
                npb.setArguments(argsList.toArray(new String[argsList.size()]));
                npb.getEnvironment().prependPathVariable("PATH", ToolUtils.getDirName(compilerPath));
                NativeProcess process = npb.call();
                if (process.getState() == NativeProcess.State.ERROR) break block10;
                InputStream inputStream = stream = stdout ? process.getInputStream() : process.getErrorStream();
                if (stream == null) break block10;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    this.parseCompilerOutput(reader, pair);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IOException(ex);
            }
        }
    }

    protected abstract void parseCompilerOutput(BufferedReader var1, Pair var2);

    protected abstract Pair getFreshSystemIncludesAndDefines();

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getNames().length > 0) {
            return compiler.getNames()[0];
        }
        return "";
    }

    protected boolean containsMacro(List<String> macrosList, String macroToFind) {
        int len = macroToFind.length();
        for (String macro : macrosList) {
            if (!macro.startsWith(macroToFind)) continue;
            if (macro.length() == len) {
                return true;
            }
            if (macro.charAt(len) != '=') continue;
            return true;
        }
        return false;
    }

    protected void parseUserMacros(String line, List<String> preprocessorList) {
        int defineIndex = line.indexOf("-D");
        while (defineIndex >= 0) {
            String token;
            int spaceIndex = line.indexOf(32, defineIndex + 1);
            if (spaceIndex > 0) {
                token = line.substring(defineIndex + 2, spaceIndex);
                if (defineIndex > 0 && line.charAt(defineIndex - 1) == '\"' && token.length() > 0 && token.charAt(token.length() - 1) == '\"') {
                    token = token.substring(0, token.length() - 1);
                }
                CCCCompiler.addUnique(preprocessorList, token);
                defineIndex = line.indexOf("-D", spaceIndex);
                continue;
            }
            token = line.substring(defineIndex + 2);
            if (defineIndex > 0 && line.charAt(defineIndex - 1) == '\"' && token.length() > 0 && token.charAt(token.length() - 1) == '\"') {
                token = token.substring(0, token.length() - 1);
            }
            CCCCompiler.addUnique(preprocessorList, token);
            break;
        }
    }

    private String getEmptyFile(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal() && Utilities.isWindows()) {
            if (emptyFile == null) {
                try {
                    File tmpFile = File.createTempFile("xyz", ".c");
                    tmpFile.deleteOnExit();
                    emptyFile = tmpFile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return emptyFile == null ? DEV_NULL : emptyFile.getAbsolutePath();
        }
        return DEV_NULL;
    }

    protected String getUniqueID() {
        if (this.getCompilerSet() == null || this.getCompilerSet().isAutoGenerated()) {
            return this.getClass().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
        }
        return this.getClass().getName() + this.getCompilerSet().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
    }

    protected static <T> void addUnique(List<? super T> list, T element) {
        if (!list.contains(element)) {
            list.add(element);
        }
    }

    protected static final class Pair {
        public List<String> systemIncludeDirectoriesList = new ArrayList<String>(0);
        public List<String> systemPreprocessorSymbolsList = new ArrayList<String>(0);
    }
}

