/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainScriptGenerator;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetPreferences;
import org.netbeans.modules.cnd.toolchain.compilerset.NoCompilersPanel;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainValidator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CompilerSetManagerAccessorImpl {
    private static final HashMap<ExecutionEnvironment, CompilerSetManagerImpl> managers = new HashMap();
    private static final Object MASTER_LOCK = new Object();

    private CompilerSetManagerAccessorImpl() {
    }

    public static CompilerSetManager getDefault(ExecutionEnvironment env) {
        return CompilerSetManagerAccessorImpl.getDefaultImpl(env, true);
    }

    public static CompilerSetManagerImpl create(ExecutionEnvironment env) {
        CompilerSetManagerImpl newCsm = new CompilerSetManagerImpl(env);
        if (newCsm.getCompilerSets().size() == 1 && newCsm.getCompilerSets().get(0).getName().equals("None")) {
            newCsm.remove(newCsm.getCompilerSets().get(0));
        }
        return newCsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManagers(Collection<CompilerSetManager> csms, List<ExecutionEnvironment> liveServers) {
        Object object = MASTER_LOCK;
        synchronized (object) {
            CompilerSetPreferences.storeExecutionEnvironmentList(liveServers);
            managers.clear();
            for (CompilerSetManager csm : csms) {
                CompilerSetManagerImpl impl = (CompilerSetManagerImpl)csm;
                impl.completeCompilerSets();
                CompilerSetPreferences.saveToDisk(impl);
                managers.put(impl.getExecutionEnvironment(), impl);
            }
        }
    }

    public static String getRemoteScript(String path) {
        return ToolchainScriptGenerator.generateScript(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(CompilerSetManagerImpl csm) {
        Object object = MASTER_LOCK;
        synchronized (object) {
            CompilerSetPreferences.saveToDisk(csm);
        }
    }

    public static CompilerSetManager getDeepCopy(ExecutionEnvironment execEnv, boolean initialize) {
        return ((CompilerSetManagerImpl)CompilerSetManagerAccessorImpl.getDefaultImpl(execEnv, initialize)).deepCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerSetManager getDefaultImpl(ExecutionEnvironment env, boolean initialize) {
        CompilerSetManagerImpl csm = null;
        boolean no_compilers = false;
        Object object = MASTER_LOCK;
        synchronized (object) {
            csm = managers.get(env);
            if (csm == null) {
                csm = CompilerSetPreferences.restoreFromDisk(env);
                if (csm != null && csm.getDefaultCompilerSet() == null) {
                    CompilerSetPreferences.saveToDisk(csm);
                }
                if (csm != null) {
                    ToolchainValidator.INSTANCE.validate(env, csm);
                }
            }
            if (csm == null) {
                csm = new CompilerSetManagerImpl(env, initialize);
                if (csm.isValid()) {
                    CompilerSetPreferences.saveToDisk(csm);
                } else if (!csm.isPending() && !csm.isUninitialized()) {
                    no_compilers = true;
                }
            }
            if (csm != null) {
                managers.put(env, csm);
            }
        }
        if (no_compilers) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new NoCompilersPanel(), CompilerSetManagerAccessorImpl.getString("NO_COMPILERS_FOUND_TITLE"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                }
            });
        }
        return csm;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CompilerSetManagerAccessorImpl.class, (String)s);
    }
}

