/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.execution.ErrorParser;
import org.netbeans.modules.cnd.toolchain.execution.OutputListenerFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;

public final class SUNErrorParser
extends ErrorParser {
    private final List<Pattern> errorScuners = new ArrayList<Pattern>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final List<String> severity = new ArrayList<String>();
    private final List<Pattern> SunStudioOutputFilters = new ArrayList<Pattern>();
    private Pattern SUN_DIRECTORY_ENTER;
    private final OutputListenerFactory listenerFactory = new OutputListenerFactory();

    public SUNErrorParser(Project project, CompilerFlavor flavor, ExecutionEnvironment execEnv, FileObject relativeTo) {
        super(project, execEnv, relativeTo);
        this.init(flavor);
    }

    private void init(CompilerFlavor flavor) {
        ToolchainManager.ScannerDescriptor scanner = flavor.getToolchainDescriptor().getScanner();
        for (ToolchainManager.ScannerPattern scannerPattern : scanner.getPatterns()) {
            Pattern pattern = Pattern.compile(scannerPattern.getPattern());
            this.patterns.add(pattern);
            this.severity.add(scannerPattern.getSeverity());
            this.errorScuners.add(pattern);
        }
        if (scanner.getEnterDirectoryPattern() != null) {
            this.SUN_DIRECTORY_ENTER = Pattern.compile(scanner.getEnterDirectoryPattern());
            this.patterns.add(this.SUN_DIRECTORY_ENTER);
        }
        for (String string : scanner.getFilterOutPatterns()) {
            this.SunStudioOutputFilters.add(Pattern.compile(string));
        }
    }

    @Override
    public ErrorParserProvider.Result handleLine(String line) throws IOException {
        ErrorParserProvider.Result res = this.handleLineImpl(line);
        if (res == null || res == ErrorParserProvider.NO_RESULT) {
            for (Pattern pattern : this.SunStudioOutputFilters) {
                Matcher skipper = pattern.matcher(line);
                boolean found = skipper.find();
                if (!found || skipper.start() != 0) continue;
                return ErrorParserProvider.REMOVE_LINE;
            }
        }
        return res;
    }

    private ErrorParserProvider.Result handleLineImpl(String line) throws IOException {
        for (Pattern p : this.patterns) {
            Matcher m = p.matcher(line);
            boolean found = m.find();
            if (!found || m.start() != 0) continue;
            return this.handleLine(line, m);
        }
        return null;
    }

    private ErrorParserProvider.Result handleLine(String line, Matcher m) throws IOException {
        if (m.pattern() == this.SUN_DIRECTORY_ENTER) {
            FileObject myObj = this.resolveFile(m.group(1));
            if (myObj != null) {
                this.relativeTo = myObj;
            }
            return ErrorParserProvider.NO_RESULT;
        }
        int i = this.errorScuners.indexOf(m.pattern());
        if (i >= 0) {
            try {
                String file = m.group(1);
                Integer lineNumber = Integer.valueOf(m.group(2));
                FileObject fo = this.resolveRelativePath(this.relativeTo, file);
                boolean important = this.severity.get(i).equals("error");
                if (fo != null && fo.isValid()) {
                    String description = null;
                    if (m.groupCount() <= 3) {
                        description = m.group(3);
                    }
                    return new ErrorParserProvider.Results(line, this.listenerFactory.register(fo, lineNumber - 1, important, description));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return ErrorParserProvider.NO_RESULT;
        }
        throw new IllegalArgumentException("Unknown pattern: " + m.pattern().pattern());
    }
}

