/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.ClassMemberPanel;
import org.netbeans.modules.java.navigation.DeclarationTopComponent;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.filesystems.FileObject;

public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private CaretListeningFactory caretListeningFactory;
    private FileObject fileObject;
    private boolean canceled;
    private static ElementHandle<Element> lastEh;
    private static ElementHandle<Element> lastEhForNavigator;
    private static final Set<JavaTokenId> TOKENS_TO_SKIP;

    CaretListeningTask(CaretListeningFactory whichElementJavaSourceTaskFactory, FileObject fileObject) {
        this.caretListeningFactory = whichElementJavaSourceTaskFactory;
        this.fileObject = fileObject;
    }

    static void resetLastEH() {
        lastEh = null;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        boolean navigatorShouldUpdate = ClassMemberPanel.getInstance() != null;
        boolean javadocShouldUpdate = JavadocTopComponent.shouldUpdate();
        boolean declarationShouldUpdate = DeclarationTopComponent.shouldUpdate();
        if (this.isCancelled() || !navigatorShouldUpdate && !javadocShouldUpdate && !declarationShouldUpdate) {
            return;
        }
        int lastPosition = CaretListeningFactory.getLastPosition((FileObject)this.fileObject);
        TokenHierarchy tokens = compilationInfo.getTokenHierarchy();
        TokenSequence ts = tokens.tokenSequence();
        boolean inJavadoc = false;
        int offset = ts.move(lastPosition);
        if (ts.moveNext() && ts.token() != null) {
            Token token = ts.token();
            TokenId tid = token.id();
            if (tid == JavaTokenId.JAVADOC_COMMENT) {
                inJavadoc = true;
            }
            if (this.shouldGoBack(token.toString(), offset < 0 ? 0 : offset) && ts.movePrevious()) {
                token = ts.token();
                tid = token.id();
            }
            if (TOKENS_TO_SKIP.contains(tid)) {
                this.skipTokens(ts, TOKENS_TO_SKIP);
            }
            lastPosition = ts.offset();
        }
        if (ts.token() != null && ts.token().length() > 1) {
            ++lastPosition;
        }
        TreePath tp = compilationInfo.getTreeUtilities().pathFor(lastPosition);
        if (this.isCancelled()) {
            return;
        }
        if (navigatorShouldUpdate) {
            this.updateNavigatorSelection(compilationInfo, tp);
        }
        Element element = compilationInfo.getTrees().getElement(tp);
        if (this.isCancelled()) {
            return;
        }
        if (element == null || inJavadoc) {
            element = CaretListeningTask.outerElement(compilationInfo, tp);
        }
        if (this.isCancelled() || element == null) {
            return;
        }
        if (lastEh != null && lastEh.signatureEquals(element) && !inJavadoc) {
            return;
        }
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: {
                lastEh = ElementHandle.create((Element)element);
                this.setDeclaration("");
                this.setJavadoc(null);
                break;
            }
            case PARAMETER: {
                element = element.getEnclosingElement();
                lastEh = ElementHandle.create((Element)element);
                this.setDeclaration("");
                this.setJavadoc(null);
                break;
            }
            case LOCAL_VARIABLE: {
                lastEh = null;
                this.setDeclaration(Utils.format(element));
                this.setJavadoc(null);
                return;
            }
            default: {
                this.setDeclaration("");
                this.setJavadoc(null);
                return;
            }
        }
        if (javadocShouldUpdate) {
            this.computeAndSetJavadoc(compilationInfo, element);
        }
        if (this.isCancelled()) {
            return;
        }
        if (declarationShouldUpdate) {
            this.computeAndSetDeclaration(compilationInfo, element);
        }
    }

    private void setDeclaration(final String declaration) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeclarationTopComponent declarationTopComponent = DeclarationTopComponent.findInstance();
                if (declarationTopComponent != null && declarationTopComponent.isOpened()) {
                    declarationTopComponent.setDeclaration(declaration);
                }
            }
        });
    }

    private void setJavadoc(final ElementJavadoc javadoc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(javadoc);
                }
            }
        });
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element));
    }

    private void computeAndSetDeclaration(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            this.setDeclaration("package " + element.toString() + ";");
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (this.isCancelled()) {
            return;
        }
        if (tree != null) {
            String declaration = this.unicodeToUtf(tree.toString());
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                String constructorName = element.getEnclosingElement().getSimpleName().toString();
                declaration = declaration.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(constructorName));
            } else if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement executableElement;
                AnnotationValue annotationValue;
                if (declaration != null && (annotationValue = (executableElement = (ExecutableElement)element).getDefaultValue()) != null) {
                    int lastSemicolon = declaration.lastIndexOf(";");
                    declaration = lastSemicolon == -1 ? declaration + " default " + String.valueOf(annotationValue) + ";" : declaration.substring(0, lastSemicolon) + " default " + String.valueOf(annotationValue) + declaration.substring(lastSemicolon);
                }
            } else if (element.getKind() == ElementKind.FIELD) {
                declaration = declaration + ";";
            }
            this.setDeclaration(declaration);
            return;
        }
    }

    private String unicodeToUtf(String s) {
        char[] buf = new char[s.length()];
        s.getChars(0, s.length(), buf, 0);
        int j = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == '\\') {
                char ch;
                if ((ch = buf[++i]) == 'u') {
                    int d;
                    while ((ch = buf[++i]) == 'u') {
                    }
                    int limit = i + 3;
                    if (limit >= buf.length) continue;
                    int code = d = this.digit(16, buf[i]);
                    while (i < limit && d >= 0) {
                        ch = buf[++i];
                        d = this.digit(16, ch);
                        code = (code << 4) + d;
                    }
                    if (d < 0) continue;
                    buf[j] = ch = (char)code;
                    ++j;
                    continue;
                }
                --i;
                ++j;
                continue;
            }
            buf[j] = buf[i];
            ++j;
        }
        return new String(buf, 0, j);
    }

    private int digit(int base, char ch) {
        char c = ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void updateNavigatorSelection(CompilationInfo ci, TreePath tp) {
        Element e = CaretListeningTask.outerElement(ci, tp);
        if (e != null) {
            final ElementHandle eh = ElementHandle.create((Element)e);
            if (lastEhForNavigator != null && eh.signatureEquals(lastEhForNavigator)) {
                return;
            }
            lastEhForNavigator = eh;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassMemberPanel cmp = ClassMemberPanel.getInstance();
                    if (cmp != null) {
                        cmp.selectElement((ElementHandle<Element>)eh);
                    }
                }
            });
        }
    }

    private static Element outerElement(CompilationInfo ci, TreePath tp) {
        Element e = null;
        while (tp != null) {
            switch (tp.getLeaf().getKind()) {
                case METHOD: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case COMPILATION_UNIT: {
                    e = ci.getTrees().getElement(tp);
                    break;
                }
                case VARIABLE: {
                    e = ci.getTrees().getElement(tp);
                    if (e == null || e.getKind().isField()) break;
                    e = null;
                }
            }
            if (e != null) break;
            tp = tp.getParentPath();
        }
        return e;
    }

    private void skipTokens(TokenSequence ts, Set<JavaTokenId> typesToSkip) {
        while (ts.moveNext()) {
            if (typesToSkip.contains(ts.token().id())) continue;
            return;
        }
    }

    private boolean shouldGoBack(String s, int offset) {
        int nlBefore = 0;
        int nlAfter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            if (i < offset) {
                ++nlBefore;
            } else {
                ++nlAfter;
            }
            if (nlAfter <= nlBefore) continue;
            return true;
        }
        if (nlBefore < nlAfter) {
            return false;
        }
        return offset < s.length() - offset;
    }

    static {
        TOKENS_TO_SKIP = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }
}

