/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.java.nodes.JavaConstructorNode;
import org.netbeans.modules.profiler.selector.java.nodes.JavaMethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;

public class JavaClassNode
extends ClassNode {
    private ClasspathInfo cpInfo;
    private ElementHandle<TypeElement> typeHandle;
    private ClientUtils.SourceCodeSelection signature;

    public JavaClassNode(ClasspathInfo cpInfo, String displayName, boolean isAnonymous, TypeElement type, ContainerNode parent) {
        super(ElementUtilities.getBinaryName((TypeElement)type), displayName, isAnonymous, parent);
        this.cpInfo = cpInfo;
        this.typeHandle = ElementHandle.create((Element)type);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)type), "*", "");
    }

    public JavaClassNode(ClasspathInfo cpInfo, boolean isAnonymous, TypeElement type, ContainerNode parent) {
        this(cpInfo, JavaClassNode.getSimpleName(ElementUtilities.getBinaryName((TypeElement)type)), isAnonymous, type, parent);
    }

    public JavaClassNode(ClasspathInfo cpInfo, TypeElement type, ContainerNode parent) {
        this(cpInfo, false, type, parent);
    }

    public JavaClassNode(ClasspathInfo cpInfo, String displayName, Icon icon, boolean isAnonymous, TypeElement type, ContainerNode parent) {
        super(ElementUtilities.getBinaryName((TypeElement)type), displayName, icon, isAnonymous, parent);
        this.cpInfo = cpInfo;
        this.typeHandle = ElementHandle.create((Element)type);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)type), "*", "");
    }

    public JavaClassNode(ClasspathInfo cpInfo, Icon icon, boolean isAnonymous, TypeElement type, ContainerNode parent) {
        this(cpInfo, type.getSimpleName().toString(), icon, isAnonymous, type, parent);
        this.cpInfo = cpInfo;
        this.typeHandle = ElementHandle.create((Element)type);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)type), "*", "");
    }

    public JavaClassNode(ClasspathInfo cpInfo, Icon icon, TypeElement type, ContainerNode parent) {
        this(cpInfo, icon, false, type, parent);
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    protected ConstructorsNode getConstructorsNode() {
        return new ConstructorsNode(this){

            protected List<SelectorNode> getConstructorNodes(final ConstructorsNode parent) {
                final ArrayList<SelectorNode> constructorNodes = new ArrayList<SelectorNode>();
                try {
                    JavaSource js = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController controller) throws Exception {
                            controller.toPhase(JavaSource.Phase.RESOLVED);
                            TypeElement type = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)controller);
                            List<ExecutableElement> methods = ElementFilter.constructorsIn(type.getEnclosedElements());
                            for (ExecutableElement method : methods) {
                                constructorNodes.add(new JavaConstructorNode(JavaClassNode.this.cpInfo, method, method.getSimpleName().toString(), parent));
                            }
                        }
                    }, true);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return constructorNodes;
            }
        };
    }

    protected InnerClassesNode getInnerClassesNode() {
        return new InnerClassesNode(this){

            private String getInterfaceNames(TypeElement classElement, CompilationInfo ci) {
                String ifcNames = null;
                List<? extends TypeMirror> ifcs = classElement.getInterfaces();
                if (ifcs != null) {
                    StringBuilder sb = new StringBuilder();
                    boolean firstRun = true;
                    for (TypeMirror typeMirror : ifcs) {
                        Element superclassElement = ci.getTypes().asElement(typeMirror);
                        if (superclassElement == null || superclassElement.getKind() != ElementKind.INTERFACE) continue;
                        if (!firstRun) {
                            sb.append(", ");
                        }
                        sb.append(ElementUtilities.getBinaryName((TypeElement)((TypeElement)superclassElement)));
                    }
                    ifcNames = sb.toString();
                }
                return ifcNames;
            }

            private String getSuperTypeClassName(TypeElement classElement, CompilationInfo ci) {
                String superclassName;
                Element superclassElement;
                String superClassName = null;
                TypeMirror superclass = classElement.getSuperclass();
                if (superclass != null && (superclassElement = ci.getTypes().asElement(superclass)) != null && superclassElement.getKind() == ElementKind.CLASS && !(superclassName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)superclassElement))).equals("java.lang.Object")) {
                    superClassName = superclassName;
                }
                return superClassName;
            }

            private void addAnonymousInnerClasses(final CompilationController controller, final InnerClassesNode parentClass, final Set<ClassNode> innerClassNodes) throws IOException {
                final Pattern anonymousInnerClassPattern = Pattern.compile("\\$[0-9]*");
                final int parentClassNameLength = JavaClassNode.this.typeHandle.getBinaryName().length();
                FileObject fo = SourceUtils.getFile((ElementHandle)JavaClassNode.this.typeHandle, (ClasspathInfo)controller.getClasspathInfo());
                JavaSource.forFileObject((FileObject)fo).runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(final CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitClass(ClassTree node, Void v) {
                                TypeElement innerClassElement;
                                String className;
                                Element classElement = controller.getTrees().getElement(this.getCurrentPath());
                                if (classElement != null && classElement.getKind() == ElementKind.CLASS && anonymousInnerClassPattern.matcher(className = (className = ElementUtilities.getBinaryName((TypeElement)(innerClassElement = (TypeElement)classElement))).length() <= parentClassNameLength ? "" : className.substring(parentClassNameLength)).matches()) {
                                    String implementedClassName = this.getSuperTypeClassName(innerClassElement, (CompilationInfo)cc);
                                    if (implementedClassName == null) {
                                        implementedClassName = this.getInterfaceNames(innerClassElement, (CompilationInfo)cc);
                                    }
                                    if (implementedClassName != null) {
                                        StringBuilder sb = new StringBuilder();
                                        sb.append(className).append("[").append(implementedClassName).append("]");
                                        className = sb.toString();
                                        innerClassNodes.add(new JavaClassNode(JavaClassNode.this.cpInfo, true, innerClassElement, (ContainerNode)parentClass));
                                    }
                                }
                                super.visitClass(node, v);
                                return null;
                            }
                        };
                        scanner.scan(cc.getCompilationUnit(), null);
                    }
                }, false);
            }

            protected Set<ClassNode> getInnerClassNodes(final InnerClassesNode parent) {
                final HashSet<ClassNode> innerClassNodes = new HashSet<ClassNode>();
                try {
                    JavaSource js = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController controller) throws Exception {
                            if (controller.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                                return;
                            }
                            TypeElement type = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)controller);
                            List<TypeElement> elements = ElementFilter.typesIn(type.getEnclosedElements());
                            for (TypeElement element : elements) {
                                innerClassNodes.add(new JavaClassNode(JavaClassNode.this.cpInfo, false, element, (ContainerNode)parent));
                            }
                            this.addAnonymousInnerClasses(controller, parent, innerClassNodes);
                        }
                    }, true);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return innerClassNodes;
            }
        };
    }

    protected MethodsNode getMethodsNode() {
        return new MethodsNode(this){

            protected List<MethodNode> getMethodNodes(final MethodsNode parent) {
                final ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
                try {
                    JavaSource js = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController controller) throws Exception {
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement type = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)controller);
                            List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
                            for (ExecutableElement method : methods) {
                                JavaMethodNode methodNode = new JavaMethodNode(JavaClassNode.this.cpInfo, method, parent);
                                if (methodNode.getSignature() == null) continue;
                                methodNodes.add(methodNode);
                            }
                        }
                    }, true);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return methodNodes;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JavaClassNode other = (JavaClassNode)((Object)obj);
        return this.typeHandle == other.typeHandle || this.typeHandle != null && this.typeHandle.equals(other.typeHandle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.typeHandle != null ? this.typeHandle.hashCode() : 0);
        return hash;
    }

    private static String getSimpleName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        if (index > -1) {
            return qualifiedName.substring(index + 1);
        }
        return qualifiedName;
    }
}

