/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.openide.filesystems.FileObject;

public class JavaMethodNode
extends MethodNode {
    private ClasspathInfo cpInfo;
    private ClientUtils.SourceCodeSelection signature;
    private Set<org.netbeans.modules.profiler.selector.spi.nodes.Modifier> modifiers;

    public JavaMethodNode(ClasspathInfo cpInfo, final ExecutableElement method, MethodsNode parent) {
        super(method.getSimpleName().toString(), parent);
        this.cpInfo = cpInfo;
        final String[] signatureString = new String[1];
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    signatureString[0] = SourceUtils.getVMMethodSignature((ExecutableElement)method, (CompilationInfo)controller);
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (signatureString[0] != null) {
            this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)this.getEnclosingClass(method)), method.getSimpleName().toString(), signatureString[0]);
            this.modifiers = new HashSet<org.netbeans.modules.profiler.selector.spi.nodes.Modifier>();
            for (Modifier modifier : method.getModifiers()) {
                switch (modifier) {
                    case STATIC: {
                        this.modifiers.add(org.netbeans.modules.profiler.selector.spi.nodes.Modifier.STATIC);
                        break;
                    }
                    case PUBLIC: {
                        this.modifiers.add(org.netbeans.modules.profiler.selector.spi.nodes.Modifier.PUBLIC);
                        break;
                    }
                    case PROTECTED: {
                        this.modifiers.add(org.netbeans.modules.profiler.selector.spi.nodes.Modifier.PROTECTED);
                        break;
                    }
                    case PRIVATE: {
                        this.modifiers.add(org.netbeans.modules.profiler.selector.spi.nodes.Modifier.PRIVATE);
                    }
                }
            }
        }
    }

    protected Set<org.netbeans.modules.profiler.selector.spi.nodes.Modifier> getModifiers() {
        return this.modifiers;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    private TypeElement getEnclosingClass(Element element) {
        Element parent = element.getEnclosingElement();
        if (parent != null) {
            if (parent.getKind() == ElementKind.CLASS || parent.getKind() == ElementKind.ENUM) {
                return (TypeElement)parent;
            }
            return this.getEnclosingClass(parent);
        }
        return null;
    }
}

