/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddBusinessMethodAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddCmpFieldAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddCreateMethodAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddFinderMethodAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddHomeMethodAction;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddSelectMethodAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class EJBActionGroup
extends NodeAction
implements Presenter.Popup {
    Lookup actionContext;

    public String getName() {
        return NbBundle.getMessage(EJBActionGroup.class, (String)"LBL_EJBActionGroup");
    }

    protected Action[] grouped() {
        return new Action[]{new AddBusinessMethodAction(), new AddCreateMethodAction(), new AddFinderMethodAction(), new AddHomeMethodAction(), new AddSelectMethodAction(), SystemAction.get(AddCmpFieldAction.class)};
    }

    public JMenuItem getPopupPresenter() {
        if (this.isEnabled() && this.isEjbProject(this.getActivatedNodes())) {
            return this.getMenu();
        }
        JMenuItem jMenuItem = super.getPopupPresenter();
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    protected JMenu getMenu() {
        return new LazyMenu(this.actionContext);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(final Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        final FileObject fileObject = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        final AtomicBoolean enabled = new AtomicBoolean(false);
        try {
            Future future = javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    String className = null;
                    ElementHandle<TypeElement> elementHandle = _RetoucheUtil.getJavaClassFromNode(activatedNodes[0]);
                    if (elementHandle != null) {
                        className = elementHandle.getQualifiedName();
                    }
                    EjbMethodController ejbMethodController = null;
                    if (className != null) {
                        ejbMethodController = EjbMethodController.createFromClass(fileObject, className);
                    }
                    enabled.set(ejbMethodController != null);
                }
            }, true);
            future.cancel(true);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return enabled.get();
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public boolean isEjbProject(Node[] activatedNodes) {
        return activatedNodes.length == 1 && EJBActionGroup.isContainingProjectEjb((FileObject)activatedNodes[0].getLookup().lookup(FileObject.class));
    }

    private static boolean isContainingProjectEjb(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        return EjbJar.getEjbJars((Project)project).length > 0;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        this.actionContext = actionContext;
        return super.createContextAwareInstance(actionContext);
    }

    private final class LazyMenu
    extends JMenu {
        private final Lookup lookup;

        public LazyMenu(Lookup lookup) {
            super(EJBActionGroup.this.getName());
            this.lookup = lookup;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (this.getItemCount() == 0) {
                Action[] grouped = EJBActionGroup.this.grouped();
                for (int i = 0; i < grouped.length; ++i) {
                    Action action = grouped[i];
                    if (action == null && this.getItemCount() != 0) {
                        this.addSeparator();
                        continue;
                    }
                    if (action instanceof ContextAwareAction) {
                        action = ((ContextAwareAction)action).createContextAwareInstance(this.lookup);
                    }
                    if (!(action instanceof Presenter.Popup)) continue;
                    this.add(((Presenter.Popup)action).getPopupPresenter());
                }
            }
            return super.getPopupMenu();
        }
    }
}

