/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.mdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.DeleteEJBDialog;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MessageNode
extends AbstractNode
implements OpenCookie {
    private final PropertyChangeListener nameChangeListener;
    private final EjbViewController controller;

    public static MessageNode create(final String ejbClass, EjbJar ejbModule, Project project) {
        String ejbName = null;
        try {
            ejbName = (String)ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

                public String run(EjbJarMetadata metadata) throws Exception {
                    Ejb ejb = metadata.findByEjbClass(ejbClass);
                    return ejb == null ? null : ejb.getEjbName();
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (ejbName == null) {
            return null;
        }
        return new MessageNode(new InstanceContent(), new EjbViewController(ejbClass, ejbModule), ejbName, project);
    }

    private MessageNode(InstanceContent content, EjbViewController controller, String ejbName, Project project) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.controller = controller;
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/ejb/mdb/MessageNodeIcon.gif");
        this.setName(ejbName + "");
        this.setDisplayName();
        this.nameChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                MessageNode.this.setDisplayName();
            }
        };
        content.add((Object)this);
        ElementHandle<TypeElement> beanClassHandle = controller.getBeanClass();
        if (beanClassHandle != null) {
            content.add(beanClassHandle);
        }
        if (controller.getBeanDo() != null) {
            content.add((Object)controller.getBeanDo().getPrimaryFile());
        }
    }

    private void setDisplayName() {
        this.setDisplayName(this.controller.getDisplayName());
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        String deleteOptions = DeleteEJBDialog.open(this.controller.getDisplayName());
        if (!deleteOptions.equals("deleteNothing")) {
            if (deleteOptions.equals("deleteOnlyDD")) {
                this.controller.delete(false);
            } else {
                this.controller.delete(true);
            }
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void open() {
        FileObject fo = this.controller.getBeanFo();
        ElementHandle<TypeElement> beh = this.controller.getBeanClass();
        ElementOpen.open((FileObject)fo, beh);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Object getValue(String attributeName) {
        Object retValue = attributeName.equals("customDelete") ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }
}

