/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.DatasourceComboBoxCustomizer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DataSourceReferencePanel
extends JPanel {
    public static final String IS_VALID = DataSourceReferencePanel.class.getName() + ".IS_VALID";
    private final J2eeModuleProvider provider;
    private final Set<String> refNames;
    private final Set<Datasource> moduleDatasources;
    private final Set<Datasource> serverDatasources;
    private final boolean isDsApiSupportedByServerPlugin;
    private NotificationLineSupport statusLine;
    private JButton addButton;
    private JCheckBox dsCopyToProjectCheck;
    private ButtonGroup dsGroup;
    private JLabel dsReferenceLabel;
    private JTextField dsReferenceText;
    private JComboBox projectDsCombo;
    private JRadioButton projectDsRadio;
    private JComboBox serverDsCombo;
    private JRadioButton serverDsRadio;
    private JLabel warningLabel;

    public DataSourceReferencePanel(J2eeModuleProvider provider, Set<String> refNames, Set<Datasource> moduleDatasources, Set<Datasource> serverDatasources) {
        this.initComponents();
        this.provider = provider;
        this.refNames = refNames;
        this.moduleDatasources = moduleDatasources;
        this.serverDatasources = serverDatasources;
        this.isDsApiSupportedByServerPlugin = this.isDsApiSupportedByServerPlugin();
        this.registerListeners();
        this.setupAddButton();
        this.setupComboBoxes();
        this.handleComboBoxes();
        this.populate();
    }

    public void setNotificationLine(NotificationLineSupport statusLine) {
        this.statusLine = statusLine;
        this.verify();
    }

    public String getReferenceName() {
        return this.dsReferenceText.getText().trim();
    }

    public Datasource getDataSource() {
        if (this.projectDsRadio.isSelected()) {
            return (Datasource)this.projectDsCombo.getSelectedItem();
        }
        return (Datasource)this.serverDsCombo.getSelectedItem();
    }

    public boolean copyDataSourceToProject() {
        if (this.projectDsRadio.isSelected()) {
            return false;
        }
        return this.dsCopyToProjectCheck.isSelected();
    }

    private boolean isDsApiSupportedByServerPlugin() {
        return this.provider != null && this.provider.isDatasourceCreationSupported() && Util.isValidServerInstance((J2eeModuleProvider)this.provider);
    }

    private void registerListeners() {
        this.dsReferenceText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.projectDsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
                DataSourceReferencePanel.this.handleComboBoxes();
            }
        });
        this.serverDsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
                DataSourceReferencePanel.this.handleComboBoxes();
            }
        });
        this.projectDsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.serverDsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSourceReferencePanel.this.verify();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                DataSourceReferencePanel.this.verify();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                DataSourceReferencePanel.this.verify();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                DataSourceReferencePanel.this.verify();
            }
        });
    }

    private void setupComboBoxes() {
        this.projectDsCombo.setPrototypeDisplayValue("jdbc:pointbase://localhost/sample [pbpublic on PBPUBLIC] ");
        this.projectDsCombo.setRenderer(DatasourceUIHelper.createDatasourceListCellRenderer());
        this.serverDsCombo.setRenderer(DatasourceUIHelper.createDatasourceListCellRenderer());
    }

    private void handleComboBoxes() {
        this.projectDsCombo.setEnabled(this.projectDsRadio.isSelected());
        this.serverDsCombo.setEnabled(this.serverDsRadio.isSelected());
        this.dsCopyToProjectCheck.setEnabled(this.serverDsRadio.isSelected());
    }

    private void populate() {
        DataSourceReferencePanel.populateDataSources(this.moduleDatasources, this.projectDsCombo);
        DataSourceReferencePanel.populateDataSources(this.serverDatasources, this.serverDsCombo);
    }

    private static void populateDataSources(Set<Datasource> datasources, JComboBox comboBox) {
        assert (datasources != null && comboBox != null);
        ArrayList<Datasource> sortedDatasources = new ArrayList<Datasource>(datasources);
        Collections.sort(sortedDatasources, DatasourceUIHelper.createDatasourceComparator());
        comboBox.removeAllItems();
        for (Datasource ds : sortedDatasources) {
            comboBox.addItem(ds);
        }
    }

    private void setupAddButton() {
        this.addButton.setEnabled(this.isDsApiSupportedByServerPlugin);
        this.warningLabel.setVisible(!this.isDsApiSupportedByServerPlugin);
        this.projectDsRadio.setEnabled(this.isDsApiSupportedByServerPlugin);
        this.projectDsRadio.setSelected(this.isDsApiSupportedByServerPlugin);
        this.serverDsRadio.setSelected(!this.isDsApiSupportedByServerPlugin);
    }

    public void verify() {
        boolean isValid = this.verifyComponents();
        this.firePropertyChange(IS_VALID, !isValid, isValid);
    }

    private boolean verifyComponents() {
        String refName = this.dsReferenceText.getText();
        if (refName == null || refName.trim().length() == 0) {
            this.setInfo("ERR_NO_REFNAME");
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)(refName = refName.trim()))) {
            this.setError("ERR_INVALID_REFNAME");
            return false;
        }
        if (this.refNames.contains(refName)) {
            this.setError("ERR_DUPLICATE_REFNAME");
            return false;
        }
        if (this.dsGroup.getSelection() == null) {
            this.setInfo("ERR_NO_DATASOURCE_SELECTED");
            return false;
        }
        if (this.projectDsRadio.isSelected()) {
            if (this.projectDsCombo.getItemCount() == 0 || this.projectDsCombo.getSelectedIndex() == -1) {
                this.setInfo("ERR_NO_DATASOURCE_SELECTED");
                return false;
            }
        } else if (this.serverDsRadio.isSelected() && (this.serverDsCombo.getItemCount() == 0 || this.serverDsCombo.getSelectedIndex() == -1)) {
            this.setInfo("ERR_NO_DATASOURCE_SELECTED");
            return false;
        }
        if (!this.isDsApiSupportedByServerPlugin) {
            this.statusLine.setWarningMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DSC_Warning"));
            return true;
        }
        this.statusLine.clearMessages();
        return true;
    }

    private void setError(String key) {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)key));
        }
    }

    private void setInfo(String key) {
        if (this.statusLine != null) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(DataSourceReferencePanel.class, (String)key));
        }
    }

    private void initComponents() {
        this.dsGroup = new ButtonGroup();
        this.dsReferenceLabel = new JLabel();
        this.dsReferenceText = new JTextField();
        this.projectDsRadio = new JRadioButton();
        this.serverDsRadio = new JRadioButton();
        this.projectDsCombo = new JComboBox();
        this.serverDsCombo = new JComboBox();
        this.dsCopyToProjectCheck = new JCheckBox();
        this.addButton = new JButton();
        this.warningLabel = new JLabel();
        this.dsReferenceLabel.setLabelFor(this.dsReferenceText);
        Mnemonics.setLocalizedText((JLabel)this.dsReferenceLabel, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DsReferenceName"));
        this.dsGroup.add(this.projectDsRadio);
        this.projectDsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDsRadio, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_ProjectDs"));
        this.projectDsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectDsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dsGroup.add(this.serverDsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDsRadio, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_ServerDs"));
        this.serverDsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverDsRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.dsCopyToProjectCheck, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DsCopyToProject"));
        this.dsCopyToProjectCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dsCopyToProjectCheck.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataSourceReferencePanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(DataSourceReferencePanel.class, (String)"LBL_DSC_Warning"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((Component)this.dsCopyToProjectCheck, -1, 560, Short.MAX_VALUE)).add((Component)this.serverDsRadio))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.warningLabel, -1, 486, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.projectDsRadio).add((Component)this.dsReferenceLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.serverDsCombo, 0, 351, Short.MAX_VALUE).add(1, (Component)this.dsReferenceText, -1, 351, Short.MAX_VALUE).add(1, (Component)this.projectDsCombo, 0, 351, Short.MAX_VALUE)))).addPreferredGap(0).add((Component)this.addButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dsReferenceLabel).add((Component)this.dsReferenceText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.projectDsRadio).add((Component)this.projectDsCombo, -2, -1, -2).add((Component)this.addButton)).addPreferredGap(0).add((Component)this.warningLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.serverDsRadio).add((Component)this.serverDsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.dsCopyToProjectCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.dsReferenceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ReferenceName"));
        this.projectDsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ProjectDataSource"));
        this.serverDsRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_ServerDataSource"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSource"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSourceRef"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DataSourceReferencePanel.class, (String)"ACSD_AddDataSourceRef"));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Datasource datasource = this.handleDataSourceCustomizer();
        if (datasource != null) {
            this.moduleDatasources.add(datasource);
            DataSourceReferencePanel.populateDataSources(this.moduleDatasources, this.projectDsCombo);
            this.projectDsCombo.setSelectedItem(datasource);
        }
    }

    private Datasource handleDataSourceCustomizer() {
        Datasource datasource = null;
        HashSet<Datasource> datasources = new HashSet<Datasource>(this.moduleDatasources);
        datasources.addAll(this.serverDatasources);
        DatasourceComboBoxCustomizer dsc = new DatasourceComboBoxCustomizer(datasources);
        if (dsc.showDialog()) {
            datasource = this.createDataSource(dsc);
        }
        return datasource;
    }

    private Datasource createDataSource(DatasourceComboBoxCustomizer dsc) {
        if (this.isDsApiSupportedByServerPlugin) {
            return this.createServerDataSource(dsc);
        }
        return this.createProjectDataSource(dsc);
    }

    private Datasource createServerDataSource(DatasourceComboBoxCustomizer dsc) {
        final Datasource[] ds = new Datasource[1];
        final String password = dsc.getPassword();
        final String jndiName = dsc.getJndiName();
        final String url = dsc.getUrl();
        final String username = dsc.getUsername();
        final String driverClassName = dsc.getDriverClassName();
        ProgressSupport.BackgroundAction action = new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_creatingDS");
                actionContext.progress(msg);
                try {
                    ds[0] = DataSourceReferencePanel.this.provider.createDatasource(jndiName, url, username, password, driverClassName);
                }
                catch (DatasourceAlreadyExistsException daee) {
                    StringBuilder sb = new StringBuilder();
                    for (Datasource conflict : daee.getDatasources()) {
                        sb.append(conflict.toString() + "\n");
                    }
                    String message = NbBundle.getMessage(DatasourceUIHelper.class, (String)"ERR_DsConflict", (Object)sb.toString());
                    Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)daee, (String)message));
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            }

            public boolean isEnabled() {
                return password != null;
            }
        };
        Set<8> actions = Collections.singleton(action);
        ProgressSupport.invoke(actions);
        return ds[0];
    }

    private Datasource createProjectDataSource(DatasourceComboBoxCustomizer dsc) {
        return new DatasourceImpl(dsc.getJndiName(), dsc.getUrl(), dsc.getUsername(), dsc.getPassword(), dsc.getDriverClassName());
    }

    private static class DatasourceImpl
    implements Datasource {
        private final String jndiName;
        private final String url;
        private final String username;
        private final String password;
        private final String driverClassName;
        private String displayName;

        public DatasourceImpl(String jndiName, String url, String username, String password, String driverClassName) {
            this.jndiName = jndiName;
            this.url = url;
            this.username = username;
            this.password = password;
            this.driverClassName = driverClassName;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.getJndiName() + " [" + this.getUrl() + "]";
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

