/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";
    private static final Logger LOGGER = Logger.getLogger(CodeUtils.class.getName());

    private CodeUtils() {
    }

    @CheckForNull
    public static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    public static boolean isPhp_53(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        PhpLanguageOptions.Properties props = PhpLanguageOptions.getDefault().getProperties(file);
        return props.getPhpVersion() == PhpLanguageOptions.PhpVersion.PHP_53;
    }

    @CheckForNull
    public static Identifier extractUnqualifiedIdentifier(Expression typeName) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return (Identifier)typeName;
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedIdentifier((NamespaceName)typeName);
        }
        if (typeName instanceof Variable) {
            Variable v = (Variable)typeName;
            return CodeUtils.extractUnqualifiedIdentifier(v.getName());
        }
        if (typeName instanceof FieldAccess) {
            return CodeUtils.extractUnqualifiedIdentifier(((FieldAccess)typeName).getField());
        }
        return null;
    }

    public static String extractUnqualifiedName(Expression typeName) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return ((Identifier)typeName).getName();
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedName((NamespaceName)typeName);
        }
        return null;
    }

    public static String extractQualifiedName(Expression typeName) {
        Parameters.notNull((CharSequence)"clsName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return ((Identifier)typeName).getName();
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractQualifiedName((NamespaceName)typeName);
        }
        assert (false) : typeName.getClass();
        return null;
    }

    public static String extractUnqualifiedClassName(StaticDispatch dispatch) {
        Parameters.notNull((CharSequence)"dispatch", (Object)dispatch);
        Expression clsName = dispatch.getClassName();
        return CodeUtils.extractUnqualifiedName(clsName);
    }

    public static String extractUnqualifiedTypeName(FormalParameter param) {
        Parameters.notNull((CharSequence)"param", (Object)param);
        Expression typeName = param.getParameterType();
        return typeName != null ? CodeUtils.extractUnqualifiedName(typeName) : null;
    }

    public static String extractUnqualifiedTypeName(CatchClause catchClause) {
        Parameters.notNull((CharSequence)"catchClause", (Object)catchClause);
        Expression typeName = catchClause.getClassName();
        return typeName != null ? CodeUtils.extractUnqualifiedName(typeName) : null;
    }

    public static String extractUnqualifiedSuperClassName(ClassDeclaration clsDeclaration) {
        Parameters.notNull((CharSequence)"clsDeclaration", (Object)clsDeclaration);
        Expression clsName = clsDeclaration.getSuperClass();
        return clsName != null ? CodeUtils.extractUnqualifiedName(clsName) : null;
    }

    public static String extractUnqualifiedName(NamespaceName namespaceName) {
        List<Identifier> segments = namespaceName.getSegments();
        return segments.get(segments.size() - 1).getName();
    }

    public static String extractQualifiedName(NamespaceName namespaceName) {
        Parameters.notNull((CharSequence)"namespaceName", (Object)namespaceName);
        StringBuilder sb = new StringBuilder();
        List<Identifier> segments = namespaceName.getSegments();
        for (Identifier identifier : segments) {
            if (sb.length() > 0) {
                sb.append("\\");
            }
            sb.append(identifier.getName());
        }
        return sb.toString();
    }

    public static Identifier extractUnqualifiedIdentifier(NamespaceName name) {
        NamespaceName namespaceName;
        List<Identifier> segments;
        if (name instanceof NamespaceName && (segments = (namespaceName = name).getSegments()).size() >= 1) {
            return segments.get(segments.size() - 1);
        }
        return null;
    }

    public static String extractClassName(ClassName clsName) {
        Expression name = clsName.getName();
        while (name instanceof Variable || name instanceof FieldAccess) {
            if (name instanceof Variable) {
                Variable var = (Variable)name;
                name = var.getName();
                continue;
            }
            if (!(name instanceof FieldAccess)) continue;
            FieldAccess fld = (FieldAccess)name;
            name = fld.getField().getName();
        }
        if (name instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedName((NamespaceName)name);
        }
        return name instanceof Identifier ? ((Identifier)name).getName() : "";
    }

    public static String extractClassName(ClassDeclaration clsDeclaration) {
        return clsDeclaration.getName().getName();
    }

    @CheckForNull
    public static String extractVariableName(Variable var) {
        return VariableNameVisitor.getInstance().findName(var);
    }

    public static String extractVariableType(Assignment assignment) {
        Expression rightSideExpression = assignment.getRightHandSide();
        if (rightSideExpression instanceof Assignment) {
            return CodeUtils.extractVariableType((Assignment)assignment.getRightHandSide());
        }
        if (rightSideExpression instanceof Reference) {
            Reference ref = (Reference)rightSideExpression;
            rightSideExpression = ref.getExpression();
        }
        if (rightSideExpression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)rightSideExpression;
            Expression className = classInstanceCreation.getClassName().getName();
            return CodeUtils.extractUnqualifiedName(className);
        }
        if (rightSideExpression instanceof ArrayCreation) {
            return "array";
        }
        if (rightSideExpression instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)rightSideExpression;
            String fname = CodeUtils.extractFunctionName(functionInvocation);
            return FUNCTION_TYPE_PREFIX + fname;
        }
        if (rightSideExpression instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)rightSideExpression;
            String className = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String methodName = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (className != null && methodName != null) {
                return STATIC_METHOD_TYPE_PREFIX + className + '.' + methodName;
            }
        } else if (rightSideExpression instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)rightSideExpression;
            String varName = null;
            if (methodInvocation.getDispatcher() instanceof Variable) {
                Variable var = (Variable)methodInvocation.getDispatcher();
                varName = CodeUtils.extractVariableName(var);
            }
            String methodName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (varName != null && methodName != null) {
                return METHOD_TYPE_PREFIX + varName + '.' + methodName;
            }
        }
        return null;
    }

    public static String extractFunctionName(FunctionInvocation functionInvocation) {
        return CodeUtils.extractFunctionName(functionInvocation.getFunctionName());
    }

    public static String extractFunctionName(FunctionDeclaration functionDeclaration) {
        return functionDeclaration.getFunctionName().getName();
    }

    public static String extractMethodName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    public static String extractFunctionName(FunctionName functionName) {
        if (functionName.getName() instanceof Identifier) {
            Identifier id = (Identifier)functionName.getName();
            return id.getName();
        }
        if (functionName.getName() instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedName((NamespaceName)functionName.getName());
        }
        if (functionName.getName() instanceof Variable) {
            Variable var = (Variable)functionName.getName();
            return CodeUtils.extractVariableName(var);
        }
        return null;
    }

    @CheckForNull
    public static String getParamDefaultValue(FormalParameter param) {
        Expression expr = param.getDefaultValue();
        if (expr instanceof Scalar) {
            Scalar scalar = (Scalar)expr;
            return scalar.getStringValue();
        }
        if (expr instanceof ArrayCreation) {
            return "array()";
        }
        return expr == null ? null : " ";
    }

    public static String getParamDisplayName(FormalParameter param) {
        Expression paramNameExpr = param.getParameterName();
        StringBuilder paramName = new StringBuilder();
        if (paramNameExpr instanceof Variable) {
            Variable var = (Variable)paramNameExpr;
            Identifier id = (Identifier)var.getName();
            if (var.isDollared()) {
                paramName.append("$");
            }
            paramName.append(id.getName());
        } else if (paramNameExpr instanceof Reference) {
            paramName.append("&");
            Reference reference = (Reference)paramNameExpr;
            if (reference.getExpression() instanceof Variable) {
                Variable var = (Variable)reference.getExpression();
                if (var.isDollared()) {
                    paramName.append("$");
                }
                Identifier id = (Identifier)var.getName();
                paramName.append(id.getName());
            }
        }
        return paramName.length() == 0 ? null : paramName.toString();
    }

    private static class VariableNameVisitor
    extends DefaultVisitor {
        private String name = null;
        private boolean isDollared = false;

        private VariableNameVisitor() {
        }

        public static VariableNameVisitor getInstance() {
            return SingletonHolder.INSTANCE;
        }

        public String findName(Variable var) {
            this.name = null;
            this.scan(var);
            return this.name;
        }

        @Override
        public void visit(Scalar node) {
            this.name = node.getStringValue();
        }

        @Override
        public void visit(Variable node) {
            this.isDollared = node.isDollared();
            super.visit(node);
        }

        @Override
        public void visit(InfixExpression node) {
        }

        @Override
        public void visit(Identifier identifier) {
            this.name = this.isDollared ? "$" + identifier.getName() : identifier.getName();
        }

        @Override
        public void visit(ArrayAccess node) {
            this.scan(node.getName());
        }

        private static class SingletonHolder {
            public static final VariableNameVisitor INSTANCE = new VariableNameVisitor();

            private SingletonHolder() {
            }
        }
    }
}

